/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jetbrains.jps.model.java;

import java.util.Arrays;
import java.util.EnumSet;

import static org.jetbrains.jps.model.java.JpsJavaClasspathKind.PRODUCTION_COMPILE;
import static org.jetbrains.jps.model.java.JpsJavaClasspathKind.PRODUCTION_RUNTIME;
import static org.jetbrains.jps.model.java.JpsJavaClasspathKind.TEST_COMPILE;
import static org.jetbrains.jps.model.java.JpsJavaClasspathKind.TEST_RUNTIME;

public enum JpsJavaDependencyScope {
  COMPILE(PRODUCTION_COMPILE, PRODUCTION_RUNTIME, TEST_COMPILE, TEST_RUNTIME),
  TEST(TEST_COMPILE, TEST_RUNTIME),
  RUNTIME(PRODUCTION_RUNTIME, TEST_RUNTIME),
  PROVIDED(PRODUCTION_COMPILE, TEST_COMPILE, TEST_RUNTIME);
  private final EnumSet<JpsJavaClasspathKind> myAffectedClasspath;

  JpsJavaDependencyScope(JpsJavaClasspathKind... classpath) {
    myAffectedClasspath = EnumSet.copyOf(Arrays.asList(classpath));
  }

  public boolean isIncludedIn(JpsJavaClasspathKind kind) {
    return myAffectedClasspath.contains(kind);
  }
}
