// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

// Generated by JFlex 1.9.1 http://jflex.de/  (tweaked for IntelliJ platform)
// source: _ScopesLexer.flex

/* It's an automatically generated code. Do not modify it. */
package com.intellij.psi.search.scope.packageSet.lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.lexer.FlexLexer;


class _ScopesLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\41\u1f00\1\u0100\1\u2f00\1\u3000\1\u0100\1\u3100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\1\u0100"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u4100"+
    "\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800\1\u4900"+
    "\1\u4a00\1\u4b00\1\u4c00\1\u4d00\1\u1f00\1\u4e00\1\u4f00\1\u5000"+
    "\1\u5100\3\u0100\1\u5200\1\u5300\1\u5400\12\u1f00\4\u0100\1\u5500"+
    "\17\u1f00\2\u0100\1\u5600\41\u1f00\2\u0100\1\u5700\1\u5800\2\u1f00"+
    "\1\u5900\1\u5a00\27\u0100\1\u5b00\4\u0100\1\u5c00\1\u5d00\42\u1f00"+
    "\1\u0100\1\u5e00\1\u5f00\11\u1f00\1\u6000\24\u1f00\1\u6100\1\u6200"+
    "\1\u1f00\1\u6300\1\u6400\1\u6500\1\u6600\2\u1f00\1\u6700\5\u1f00"+
    "\1\u6800\1\u6900\1\u6a00\5\u1f00\1\u6b00\1\u6c00\2\u1f00\1\u6d00"+
    "\1\u1f00\1\u6e00\14\u1f00\1\u6f00\4\u1f00\246\u0100\1\u7000\20\u0100"+
    "\1\u7100\1\u7200\25\u0100\1\u7300\34\u0100\1\u7400\14\u1f00\2\u0100"+
    "\1\u7500\5\u1f00\23\u0100\1\u7600\u0aec\u1f00\1\u7700\1\u7800\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\2\1\1\2\2\1\16\0\4\2\1\1\1\3"+
    "\1\2\1\4\1\5\1\2\1\6\1\2\1\7\1\10"+
    "\1\11\2\2\1\12\1\13\1\14\12\15\1\16\6\2"+
    "\32\5\1\17\1\2\1\20\1\2\1\5\1\2\32\5"+
    "\1\2\1\21\1\2\1\22\41\0\2\2\4\5\4\2"+
    "\1\5\2\2\1\0\7\2\1\5\4\2\1\5\5\2"+
    "\27\5\1\2\37\5\1\2\u01ca\5\4\2\14\5\16\2"+
    "\5\5\7\2\1\5\1\2\1\5\21\2\160\0\5\5"+
    "\1\2\2\5\2\2\4\5\1\2\1\5\6\2\1\5"+
    "\1\2\3\5\1\2\1\5\1\2\24\5\1\2\123\5"+
    "\1\2\213\5\1\2\5\0\2\2\246\5\1\2\46\5"+
    "\2\2\1\5\6\2\51\5\6\2\1\5\1\2\55\0"+
    "\1\2\1\0\1\2\2\0\1\2\2\0\1\2\1\0"+
    "\10\2\33\5\4\2\4\5\15\2\6\0\5\2\1\5"+
    "\4\2\13\0\1\2\1\0\3\2\53\5\37\0\4\2"+
    "\2\5\1\0\143\5\1\2\1\5\10\0\1\2\6\0"+
    "\2\5\2\0\1\2\4\0\2\5\12\0\3\5\2\2"+
    "\1\5\17\2\1\0\1\5\1\0\36\5\33\0\2\2"+
    "\131\5\13\0\1\5\16\2\12\0\41\5\11\0\2\5"+
    "\4\2\1\5\2\2\1\0\30\5\4\0\1\5\11\0"+
    "\1\5\3\0\1\5\5\0\22\2\31\5\3\0\4\2"+
    "\13\5\65\2\25\5\1\2\22\5\13\2\61\0\66\5"+
    "\3\0\1\5\22\0\1\5\7\0\12\5\2\0\2\2"+
    "\12\0\1\2\20\5\3\0\1\2\10\5\2\2\2\5"+
    "\2\2\26\5\1\2\7\5\1\2\1\5\3\2\4\5"+
    "\2\2\1\0\1\5\7\0\2\2\2\0\2\2\3\0"+
    "\1\5\10\2\1\0\4\2\2\5\1\2\3\5\2\0"+
    "\2\2\12\0\4\5\7\2\2\5\1\2\1\0\2\2"+
    "\3\0\1\2\6\5\4\2\2\5\2\2\26\5\1\2"+
    "\7\5\1\2\2\5\1\2\2\5\1\2\2\5\2\2"+
    "\1\0\1\2\5\0\4\2\2\0\2\2\3\0\3\2"+
    "\1\0\7\2\4\5\1\2\1\5\7\2\14\0\3\5"+
    "\1\0\13\2\3\0\1\2\11\5\1\2\3\5\1\2"+
    "\26\5\1\2\7\5\1\2\2\5\1\2\5\5\2\2"+
    "\1\0\1\5\10\0\1\2\3\0\1\2\3\0\2\2"+
    "\1\5\17\2\2\5\2\0\2\2\12\0\1\2\1\5"+
    "\7\2\1\5\6\0\1\2\3\0\1\2\10\5\2\2"+
    "\2\5\2\2\26\5\1\2\7\5\1\2\2\5\1\2"+
    "\5\5\2\2\1\0\1\5\7\0\2\2\2\0\2\2"+
    "\3\0\7\2\3\0\4\2\2\5\1\2\3\5\2\0"+
    "\2\2\12\0\1\2\1\5\20\2\1\0\1\5\1\2"+
    "\6\5\3\2\3\5\1\2\4\5\3\2\2\5\1\2"+
    "\1\5\1\2\2\5\3\2\2\5\3\2\3\5\3\2"+
    "\14\5\4\2\5\0\3\2\3\0\1\2\4\0\2\2"+
    "\1\5\6\2\1\0\16\2\12\0\11\2\1\5\6\2"+
    "\5\0\10\5\1\2\3\5\1\2\27\5\1\2\20\5"+
    "\3\2\1\5\7\0\1\2\3\0\1\2\4\0\7\2"+
    "\2\0\1\2\3\5\5\2\2\5\2\0\2\2\12\0"+
    "\20\2\1\5\3\0\1\2\10\5\1\2\3\5\1\2"+
    "\27\5\1\2\12\5\1\2\5\5\2\2\1\0\1\5"+
    "\7\0\1\2\3\0\1\2\4\0\7\2\2\0\7\2"+
    "\1\5\1\2\2\5\2\0\2\2\12\0\1\2\2\5"+
    "\15\2\4\0\11\5\1\2\3\5\1\2\51\5\2\0"+
    "\1\5\7\0\1\2\3\0\1\2\4\0\1\5\5\2"+
    "\3\5\1\0\7\2\3\5\2\0\2\2\12\0\12\2"+
    "\6\5\1\2\3\0\1\2\22\5\3\2\30\5\1\2"+
    "\11\5\1\2\1\5\2\2\7\5\3\2\1\0\4\2"+
    "\6\0\1\2\1\0\1\2\10\0\6\2\12\0\2\2"+
    "\2\0\15\2\60\5\1\0\2\5\7\0\4\2\10\5"+
    "\10\0\1\2\12\0\47\2\2\5\1\2\1\5\1\2"+
    "\5\5\1\2\30\5\1\2\1\5\1\2\12\5\1\0"+
    "\2\5\11\0\1\5\2\2\5\5\1\2\1\5\1\2"+
    "\6\0\2\2\12\0\2\2\4\5\40\2\1\5\27\2"+
    "\2\0\6\2\12\0\13\2\1\0\1\2\1\0\1\2"+
    "\1\0\4\2\2\0\10\5\1\2\44\5\4\2\24\0"+
    "\1\2\2\0\5\5\13\0\1\2\44\0\11\2\1\0"+
    "\71\2\53\5\24\0\1\5\12\0\6\2\6\5\4\0"+
    "\4\5\3\0\1\5\3\0\2\5\7\0\3\5\4\0"+
    "\15\5\14\0\1\5\17\0\2\2\46\5\1\2\1\5"+
    "\5\2\1\5\2\2\53\5\1\2\115\5\1\2\4\5"+
    "\2\2\7\5\1\2\1\5\1\2\4\5\2\2\51\5"+
    "\1\2\4\5\2\2\41\5\1\2\4\5\2\2\7\5"+
    "\1\2\1\5\1\2\4\5\2\2\17\5\1\2\71\5"+
    "\1\2\4\5\2\2\103\5\2\2\3\0\40\2\20\5"+
    "\20\2\126\5\2\2\6\5\3\2\u016c\5\2\2\21\5"+
    "\1\2\32\5\5\2\113\5\3\2\13\5\7\2\15\5"+
    "\1\2\4\5\3\0\13\2\22\5\3\0\13\2\22\5"+
    "\2\0\14\2\15\5\1\2\3\5\1\2\2\0\14\2"+
    "\64\5\40\0\3\2\1\5\3\2\2\5\1\0\2\2"+
    "\12\0\41\2\4\0\1\2\12\0\6\2\131\5\7\2"+
    "\5\5\2\0\42\5\1\0\1\5\5\2\106\5\12\2"+
    "\37\5\1\2\14\0\4\2\14\0\12\2\12\0\36\5"+
    "\2\2\5\5\13\2\54\5\4\2\32\5\6\2\12\0"+
    "\46\2\27\5\5\0\4\2\65\5\12\0\1\2\35\0"+
    "\2\2\13\0\6\2\12\0\15\2\1\5\10\2\16\0"+
    "\1\2\2\0\77\2\5\0\57\5\21\0\7\5\4\2"+
    "\12\0\21\2\11\0\14\2\3\0\36\5\15\0\2\5"+
    "\12\0\54\5\16\0\14\2\44\5\24\0\10\2\12\0"+
    "\3\2\3\5\12\0\44\5\2\2\11\5\7\2\53\5"+
    "\2\2\3\5\20\2\3\0\1\2\25\0\4\5\1\0"+
    "\6\5\1\0\2\5\3\0\1\5\5\2\300\5\72\0"+
    "\1\2\5\0\26\5\2\2\6\5\2\2\46\5\2\2"+
    "\6\5\2\2\10\5\1\2\1\5\1\2\1\5\1\2"+
    "\1\5\1\2\37\5\2\2\65\5\1\2\7\5\1\2"+
    "\1\5\3\2\3\5\1\2\7\5\3\2\4\5\2\2"+
    "\6\5\4\2\15\5\5\2\3\5\1\2\7\5\16\2"+
    "\5\0\32\2\5\0\20\2\2\5\23\2\1\5\13\2"+
    "\5\0\1\2\12\0\1\2\1\5\15\2\1\5\20\2"+
    "\15\5\3\2\40\5\20\2\15\0\4\2\1\0\3\2"+
    "\14\0\21\2\1\5\4\2\1\5\2\2\12\5\1\2"+
    "\1\5\3\2\5\5\6\2\1\5\1\2\1\5\1\2"+
    "\1\5\1\2\4\5\1\2\13\5\2\2\4\5\5\2"+
    "\5\5\4\2\1\5\21\2\51\5\u0177\2\57\5\1\2"+
    "\57\5\1\2\205\5\6\2\4\5\3\0\2\5\14\2"+
    "\46\5\1\2\1\5\5\2\1\5\2\2\70\5\7\2"+
    "\1\5\17\2\1\0\27\5\11\2\7\5\1\2\7\5"+
    "\1\2\7\5\1\2\7\5\1\2\7\5\1\2\7\5"+
    "\1\2\7\5\1\2\7\5\1\2\40\0\57\2\1\5"+
    "\325\2\3\5\31\2\11\5\6\0\1\2\5\5\2\2"+
    "\5\5\4\2\126\5\2\2\2\0\2\2\3\5\1\2"+
    "\132\5\1\2\4\5\5\2\53\5\1\2\136\5\21\2"+
    "\40\5\60\2\320\5\100\2\375\5\3\2\215\5\103\2"+
    "\56\5\2\2\15\5\3\2\20\5\12\0\2\5\24\2"+
    "\57\5\1\0\4\2\12\0\1\2\37\5\2\0\120\5"+
    "\2\0\45\2\11\5\2\2\147\5\2\2\65\5\2\2"+
    "\11\5\52\2\15\5\1\0\3\5\1\0\4\5\1\0"+
    "\27\5\5\0\4\2\1\0\13\2\1\5\7\2\64\5"+
    "\14\2\2\0\62\5\22\0\12\2\12\0\6\2\22\0"+
    "\6\5\3\2\1\5\1\2\2\5\13\0\34\5\10\0"+
    "\2\2\27\5\15\0\14\2\35\5\3\2\4\0\57\5"+
    "\16\0\16\2\1\5\12\0\6\2\5\5\1\0\12\5"+
    "\12\0\5\5\1\2\51\5\16\0\11\2\3\5\1\0"+
    "\10\5\2\0\2\2\12\0\6\2\27\5\3\2\1\5"+
    "\3\0\62\5\1\0\1\5\3\0\2\5\2\0\5\5"+
    "\2\0\1\5\1\0\1\5\30\2\3\5\2\2\13\5"+
    "\5\0\2\2\3\5\2\0\12\2\6\5\2\2\6\5"+
    "\2\2\6\5\11\2\7\5\1\2\7\5\1\2\53\5"+
    "\1\2\16\5\6\2\163\5\10\0\1\2\2\0\2\2"+
    "\12\0\6\2\244\5\14\2\27\5\4\2\61\5\4\2"+
    "\156\5\2\2\152\5\46\2\7\5\14\2\5\5\5\2"+
    "\1\5\1\0\12\5\1\2\15\5\1\2\5\5\1\2"+
    "\1\5\1\2\2\5\1\2\2\5\1\2\154\5\41\2"+
    "\153\5\22\2\100\5\2\2\66\5\50\2\15\5\3\2"+
    "\20\0\20\2\20\0\3\2\2\5\30\2\3\5\31\2"+
    "\1\5\6\2\5\5\1\2\207\5\2\2\1\0\4\2"+
    "\1\5\13\2\12\0\7\2\32\5\4\2\1\5\1\2"+
    "\32\5\13\2\131\5\3\2\6\5\2\2\6\5\2\2"+
    "\6\5\2\2\3\5\3\2\2\5\3\2\2\5\22\2"+
    "\3\0\4\2\14\5\1\2\32\5\1\2\23\5\1\2"+
    "\2\5\1\2\17\5\2\2\16\5\42\2\173\5\105\2"+
    "\65\5\210\2\1\0\202\2\35\5\3\2\61\5\17\2"+
    "\1\0\37\2\40\5\15\2\36\5\5\2\46\5\5\0"+
    "\5\2\36\5\2\2\44\5\4\2\10\5\1\2\5\5"+
    "\52\2\236\5\2\2\12\0\6\2\44\5\4\2\44\5"+
    "\4\2\50\5\10\2\64\5\234\2\67\5\11\2\26\5"+
    "\12\2\10\5\230\2\6\5\2\2\1\5\1\2\54\5"+
    "\1\2\2\5\3\2\1\5\2\2\27\5\12\2\27\5"+
    "\11\2\37\5\101\2\23\5\1\2\2\5\12\2\26\5"+
    "\12\2\32\5\106\2\70\5\6\2\2\5\100\2\1\5"+
    "\3\0\1\2\2\0\5\2\4\0\4\5\1\2\3\5"+
    "\1\2\35\5\2\2\3\0\4\2\1\0\40\2\35\5"+
    "\3\2\35\5\43\2\10\5\1\2\34\5\2\0\31\2"+
    "\66\5\12\2\26\5\12\2\23\5\15\2\22\5\156\2"+
    "\111\5\67\2\63\5\15\2\63\5\15\2\44\5\4\0"+
    "\10\2\12\0\u0146\2\52\5\1\2\2\0\3\2\2\5"+
    "\116\2\35\5\12\2\1\5\10\2\26\5\13\0\137\2"+
    "\25\5\33\2\27\5\11\2\3\0\65\5\17\0\37\2"+
    "\12\0\17\2\4\0\55\5\13\0\2\2\1\0\17\2"+
    "\1\0\2\2\31\5\7\2\12\0\6\2\3\0\44\5"+
    "\16\0\1\2\12\0\4\2\1\5\2\0\1\5\10\2"+
    "\43\5\1\0\2\2\1\5\11\2\3\0\60\5\16\0"+
    "\4\5\4\2\4\0\1\2\14\0\1\5\1\2\1\5"+
    "\43\2\22\5\1\2\31\5\14\0\6\2\1\0\101\2"+
    "\7\5\1\2\1\5\1\2\4\5\1\2\17\5\1\2"+
    "\12\5\7\2\57\5\14\0\5\2\12\0\6\2\4\0"+
    "\1\2\10\5\2\2\2\5\2\2\26\5\1\2\7\5"+
    "\1\2\2\5\1\2\5\5\1\2\2\0\1\5\7\0"+
    "\2\2\2\0\2\2\3\0\2\2\1\5\6\2\1\0"+
    "\5\2\5\5\2\0\2\2\7\0\3\2\5\0\213\2"+
    "\65\5\22\0\4\5\5\2\12\0\4\2\1\0\3\5"+
    "\36\2\60\5\24\0\2\5\1\2\1\5\10\2\12\0"+
    "\246\2\57\5\7\0\2\2\11\0\27\2\4\5\2\0"+
    "\42\2\60\5\21\0\3\2\1\5\13\2\12\0\46\2"+
    "\53\5\15\0\1\5\7\2\12\0\66\2\33\5\2\2"+
    "\17\0\4\2\12\0\306\2\54\5\17\0\145\2\100\5"+
    "\12\0\25\2\10\5\2\2\1\5\2\2\10\5\1\2"+
    "\2\5\1\2\30\5\6\0\1\2\2\0\2\2\4\0"+
    "\1\5\1\0\1\5\2\0\14\2\12\0\106\2\10\5"+
    "\2\2\47\5\7\0\2\2\7\0\1\5\1\2\1\5"+
    "\1\0\33\2\1\5\12\0\50\5\7\0\1\5\4\0"+
    "\10\2\1\0\10\2\1\5\13\0\56\5\20\0\3\2"+
    "\1\5\42\2\71\5\7\2\11\5\1\2\45\5\10\0"+
    "\1\2\10\0\1\5\17\2\12\0\30\2\36\5\2\2"+
    "\26\0\1\2\16\0\111\2\7\5\1\2\2\5\1\2"+
    "\46\5\6\0\3\2\1\0\1\2\2\0\1\2\7\0"+
    "\1\5\1\0\10\2\12\0\6\2\6\5\1\2\2\5"+
    "\1\2\40\5\5\0\1\2\2\0\1\2\5\0\1\5"+
    "\7\2\12\0\u0136\2\23\5\4\0\271\2\1\5\54\2"+
    "\4\5\37\2\232\5\146\2\157\5\21\2\304\5\274\2"+
    "\57\5\1\2\11\0\307\2\107\5\271\2\71\5\7\2"+
    "\37\5\1\2\12\0\146\2\36\5\2\2\5\0\13\2"+
    "\60\5\7\0\11\2\4\5\14\2\12\0\11\2\25\5"+
    "\5\2\23\5\260\2\100\5\200\2\113\5\4\2\1\0"+
    "\1\5\67\0\7\2\4\0\15\5\100\2\2\5\1\2"+
    "\1\5\1\0\13\2\2\0\16\2\370\5\10\2\326\5"+
    "\52\2\11\5\367\2\37\5\61\2\3\5\21\2\4\5"+
    "\10\2\u018c\5\4\2\153\5\5\2\15\5\3\2\11\5"+
    "\7\2\12\5\3\2\2\0\1\2\4\0\301\2\5\0"+
    "\3\2\26\0\2\2\7\0\36\2\4\0\224\2\3\0"+
    "\273\2\125\5\1\2\107\5\1\2\2\5\2\2\1\5"+
    "\2\2\2\5\2\2\4\5\1\2\14\5\1\2\1\5"+
    "\1\2\7\5\1\2\101\5\1\2\4\5\2\2\10\5"+
    "\1\2\7\5\1\2\34\5\1\2\4\5\1\2\5\5"+
    "\1\2\1\5\3\2\7\5\1\2\u0154\5\2\2\31\5"+
    "\1\2\31\5\1\2\37\5\1\2\31\5\1\2\37\5"+
    "\1\2\31\5\1\2\37\5\1\2\31\5\1\2\37\5"+
    "\1\2\31\5\1\2\10\5\2\2\151\0\4\2\62\0"+
    "\10\2\1\0\16\2\1\0\26\2\5\0\1\2\17\0"+
    "\120\2\7\0\1\2\21\0\2\2\7\0\1\2\2\0"+
    "\1\2\5\0\325\2\55\5\3\2\7\0\7\5\2\2"+
    "\12\0\4\2\1\5\u0171\2\54\5\16\0\5\2\306\5"+
    "\13\2\7\0\51\2\104\5\7\0\1\5\4\2\12\0"+
    "\u0156\2\1\5\117\2\4\5\1\2\33\5\1\2\2\5"+
    "\1\2\1\5\2\2\1\5\1\2\12\5\1\2\4\5"+
    "\1\2\1\5\1\2\1\5\6\2\1\5\4\2\1\5"+
    "\1\2\1\5\1\2\1\5\1\2\3\5\1\2\2\5"+
    "\1\2\1\5\2\2\1\5\1\2\1\5\1\2\1\5"+
    "\1\2\1\5\1\2\1\5\1\2\2\5\1\2\1\5"+
    "\2\2\4\5\1\2\7\5\1\2\4\5\1\2\4\5"+
    "\1\2\1\5\1\2\12\5\1\2\21\5\5\2\3\5"+
    "\1\2\5\5\1\2\21\5\u0134\2\12\0\6\2\336\5"+
    "\42\2\65\5\13\2\336\5\2\2\u0182\5\16\2\u0131\5"+
    "\37\2\36\5\342\2\113\5\266\2\1\0\36\2\140\0"+
    "\200\2\360\0\20\2";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[30976];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\1\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\1\1\20\1\21\1\22";

  private static int [] zzUnpackAction() {
    int [] result = new int[21];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\23\0\46\0\23\0\23\0\71\0\114\0\23"+
    "\0\23\0\23\0\23\0\23\0\23\0\137\0\23\0\23"+
    "\0\23\0\162\0\23\0\23\0\23";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[21];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\2\1\4\1\5\1\6\1\7\1\10"+
    "\1\11\1\12\1\13\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\24\0\1\3\21\0\1\6\4\0"+
    "\1\6\7\0\1\6\13\0\1\24\31\0\1\16\26\0"+
    "\1\25\1\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[133];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\1\1\2\11\2\1\6\11\1\1\3\11"+
    "\1\1\3\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[21];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public _ScopesLexer() {
    this((java.io.Reader)null);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _ScopesLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return ScopeTokenTypes.BAD_CHARACTER;
            }
          // fall through
          case 19: break;
          case 2:
            { return ScopeTokenTypes.WHITE_SPACE;
            }
          // fall through
          case 20: break;
          case 3:
            { return ScopeTokenTypes.EXCL;
            }
          // fall through
          case 21: break;
          case 4:
            { return ScopeTokenTypes.SHARP;
            }
          // fall through
          case 22: break;
          case 5:
            { return ScopeTokenTypes.IDENTIFIER;
            }
          // fall through
          case 23: break;
          case 6:
            { return ScopeTokenTypes.LPARENTH;
            }
          // fall through
          case 24: break;
          case 7:
            { return ScopeTokenTypes.RPARENTH;
            }
          // fall through
          case 25: break;
          case 8:
            { return ScopeTokenTypes.ASTERISK;
            }
          // fall through
          case 26: break;
          case 9:
            { return ScopeTokenTypes.MINUS;
            }
          // fall through
          case 27: break;
          case 10:
            { return ScopeTokenTypes.DOT;
            }
          // fall through
          case 28: break;
          case 11:
            { return ScopeTokenTypes.DIV;
            }
          // fall through
          case 29: break;
          case 12:
            { return ScopeTokenTypes.INTEGER_LITERAL;
            }
          // fall through
          case 30: break;
          case 13:
            { return ScopeTokenTypes.COLON;
            }
          // fall through
          case 31: break;
          case 14:
            { return ScopeTokenTypes.LBRACKET;
            }
          // fall through
          case 32: break;
          case 15:
            { return ScopeTokenTypes.RBRACKET;
            }
          // fall through
          case 33: break;
          case 16:
            { return ScopeTokenTypes.TILDE;
            }
          // fall through
          case 34: break;
          case 17:
            { return ScopeTokenTypes.ANDAND;
            }
          // fall through
          case 35: break;
          case 18:
            { return ScopeTokenTypes.OROR;
            }
          // fall through
          case 36: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
