/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.formatting.commandLine

import java.io.PrintWriter


open class MessageOutput(private val infoOut: PrintWriter, private val errorOut: PrintWriter) {

  fun info(message: String): Unit = infoOut.printAndFlush(message)

  fun error(message: String): Unit = errorOut.printAndFlush(message)

  private fun PrintWriter.printAndFlush(message: String) {
    print(message)
    flush()
  }

}

object StdIoMessageOutput : MessageOutput(PrintWriter(System.out), PrintWriter(System.err))
