/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.BooleanAccessor;
import com.intellij.application.options.codeStyle.properties.BraceStyleAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValues;
import com.intellij.application.options.codeStyle.properties.CommaSeparatedValuesAccessor;
import com.intellij.application.options.codeStyle.properties.EnumPropertyAccessor;
import com.intellij.application.options.codeStyle.properties.ForceBracesAccessor;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.application.options.codeStyle.properties.StringAccessor;
import com.intellij.application.options.codeStyle.properties.WrapOnTypingAccessor;
import com.intellij.application.options.codeStyle.properties.WrappingAccessor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FieldAccessorFactory {
    private final Field myField;

    FieldAccessorFactory(Field field) {
        this.myField = field;
    }

    private ValueType getValueType() {
        String fieldName = this.myField.getName();
        Class<?> fieldType = this.myField.getType();
        String name = fieldType.getName();
        if (fieldType.isPrimitive()) {
            if ("int".equals(name)) {
                CommonCodeStyleSettings.WrapConstant wrapAnnotation = this.myField.getAnnotation(CommonCodeStyleSettings.WrapConstant.class);
                if (wrapAnnotation != null) {
                    return ValueType.WRAP;
                }
                CommonCodeStyleSettings.BraceStyleConstant braceAnnotation = this.myField.getAnnotation(CommonCodeStyleSettings.BraceStyleConstant.class);
                if (braceAnnotation != null) {
                    return ValueType.BRACE_STYLE;
                }
                if (fieldName.endsWith("_BRACE_FORCE")) {
                    return ValueType.FORCE_BRACES;
                }
                return ValueType.INT;
            }
            if ("boolean".equals(name)) {
                return ValueType.BOOLEAN;
            }
        } else {
            if ("java.lang.String".equals(name)) {
                return ValueType.STRING;
            }
            if (fieldType.isEnum()) {
                return ValueType.ENUM;
            }
        }
        return ValueType.OTHER;
    }

    @Nullable
    CodeStyleFieldAccessor<?, ?> createAccessor(@NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            FieldAccessorFactory.$$$reportNull$$$0(0);
        }
        if (this.mayHaveAccessor()) {
            return switch (this.getValueType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if ("USE_TAB_CHARACTER".equals(this.myField.getName())) {
                        yield new TabCharPropertyAccessor(codeStyleObject, this.myField);
                    }
                    yield new BooleanAccessor(codeStyleObject, this.myField);
                }
                case 1 -> {
                    if ("WRAP_ON_TYPING".equals(this.myField.getName())) {
                        yield new WrapOnTypingAccessor(codeStyleObject, this.myField);
                    }
                    yield new IntegerAccessor(codeStyleObject, this.myField);
                }
                case 2 -> {
                    CommaSeparatedValues annotation = this.myField.getAnnotation(CommaSeparatedValues.class);
                    if (annotation != null) {
                        yield new CommaSeparatedValuesAccessor(codeStyleObject, this.myField);
                    }
                    yield new StringAccessor(codeStyleObject, this.myField);
                }
                case 3 -> new WrappingAccessor(codeStyleObject, this.myField);
                case 4 -> new BraceStyleAccessor(codeStyleObject, this.myField);
                case 5 -> new ForceBracesAccessor(codeStyleObject, this.myField);
                case 6 -> new EnumPropertyAccessor(codeStyleObject, this.myField);
                case 7 -> null;
            };
        }
        return null;
    }

    private boolean mayHaveAccessor() {
        int modifiers = this.myField.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && this.myField.getType().getCanonicalName() != null && this.myField.getAnnotation(Deprecated.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleObject", "com/intellij/application/options/codeStyle/properties/FieldAccessorFactory", "createAccessor"));
    }

    private static enum ValueType {
        BOOLEAN,
        INT,
        STRING,
        WRAP,
        BRACE_STYLE,
        FORCE_BRACES,
        ENUM,
        OTHER;

    }

    private static class TabCharPropertyAccessor
    extends CodeStyleFieldAccessor<Boolean, String> {
        TabCharPropertyAccessor(@NotNull Object object, @NotNull Field field) {
            if (object == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(1);
            }
            super(object, field);
        }

        @Override
        @Nullable
        protected String parseString(@NotNull String string) {
            if (string == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected String valueToString(@NotNull String value) {
            if (value == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(3);
            }
            return value;
        }

        @Override
        @Nullable
        protected Boolean fromExternal(@NotNull String str) {
            if (str == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(4);
            }
            return "tab".equalsIgnoreCase(str);
        }

        @Override
        @NotNull
        protected String toExternal(@NotNull Boolean value) {
            if (value == null) {
                TabCharPropertyAccessor.$$$reportNull$$$0(5);
            }
            return value != false ? "tab" : "space";
        }

        @Override
        public String getPropertyName() {
            return "indent_style";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/application/options/codeStyle/properties/FieldAccessorFactory$TabCharPropertyAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueToString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromExternal";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toExternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

