/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.SuggestedRefactoringStateKt;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupportKt;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003@ABBy\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u0014\u00103\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001a\u00104\u001a\u00020\u00002\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0012J+\u00105\u001a\u00020\u0000\"\b\b\u0000\u00106*\u00020\u00012\f\u00107\u001a\b\u0012\u0004\u0012\u0002H6082\u0006\u00109\u001a\u0002H6\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0000H\u0002J\b\u0010>\u001a\u0004\u0018\u00010\u0003J\b\u0010?\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001aR\u0010\u0010>\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "", "anchor", "Lcom/intellij/psi/PsiElement;", "refactoringSupport", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "errorLevel", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$ErrorLevel;", "oldDeclarationText", "", "oldImportsText", "oldSignature", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;", "newSignature", "parameterMarkers", "", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$ParameterMarker;", "disappearedParameters", "", "featureUsageId", "", "additionalData", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$ErrorLevel;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;Ljava/util/List;Ljava/util/Map;ILcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;)V", "getAnchor", "()Lcom/intellij/psi/PsiElement;", "getRefactoringSupport", "()Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "getErrorLevel", "()Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$ErrorLevel;", "getOldDeclarationText", "()Ljava/lang/String;", "getOldImportsText", "getOldSignature", "()Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;", "getNewSignature", "getParameterMarkers", "()Ljava/util/List;", "getDisappearedParameters", "()Ljava/util/Map;", "getFeatureUsageId", "()I", "getAdditionalData", "()Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "declaration", "getDeclaration", "withAnchor", "withErrorLevel", "withOldSignature", "withNewSignature", "withParameterMarkers", "withDisappearedParameters", "withAdditionalData", "T", "key", "Lcom/intellij/openapi/util/Key;", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "copyRestoredDeclaration", "", "toState", "restoredDeclarationCopy", "createRestoredDeclarationCopy", "ParameterMarker", "AdditionalData", "ErrorLevel", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nSuggestedRefactoringState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestedRefactoringState.kt\ncom/intellij/refactoring/suggested/SuggestedRefactoringState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public final class SuggestedRefactoringState {
    @NotNull
    private final PsiElement anchor;
    @NotNull
    private final SuggestedRefactoringSupport refactoringSupport;
    @NotNull
    private final ErrorLevel errorLevel;
    @NotNull
    private final String oldDeclarationText;
    @Nullable
    private final String oldImportsText;
    @NotNull
    private final SuggestedRefactoringSupport.Signature oldSignature;
    @NotNull
    private final SuggestedRefactoringSupport.Signature newSignature;
    @NotNull
    private final List<ParameterMarker> parameterMarkers;
    @NotNull
    private final Map<String, Object> disappearedParameters;
    private final int featureUsageId;
    @NotNull
    private final AdditionalData additionalData;
    @Nullable
    private PsiElement restoredDeclarationCopy;

    public SuggestedRefactoringState(@NotNull PsiElement anchor, @NotNull SuggestedRefactoringSupport refactoringSupport, @NotNull ErrorLevel errorLevel, @NotNull String oldDeclarationText, @Nullable String oldImportsText, @NotNull SuggestedRefactoringSupport.Signature oldSignature, @NotNull SuggestedRefactoringSupport.Signature newSignature, @NotNull List<ParameterMarker> parameterMarkers, @NotNull Map<String, ? extends Object> disappearedParameters, int featureUsageId, @NotNull AdditionalData additionalData) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
        Intrinsics.checkNotNullParameter((Object)((Object)errorLevel), (String)"errorLevel");
        Intrinsics.checkNotNullParameter((Object)oldDeclarationText, (String)"oldDeclarationText");
        Intrinsics.checkNotNullParameter((Object)oldSignature, (String)"oldSignature");
        Intrinsics.checkNotNullParameter((Object)newSignature, (String)"newSignature");
        Intrinsics.checkNotNullParameter(parameterMarkers, (String)"parameterMarkers");
        Intrinsics.checkNotNullParameter(disappearedParameters, (String)"disappearedParameters");
        Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
        this.anchor = anchor;
        this.refactoringSupport = refactoringSupport;
        this.errorLevel = errorLevel;
        this.oldDeclarationText = oldDeclarationText;
        this.oldImportsText = oldImportsText;
        this.oldSignature = oldSignature;
        this.newSignature = newSignature;
        this.parameterMarkers = parameterMarkers;
        this.disappearedParameters = disappearedParameters;
        this.featureUsageId = featureUsageId;
        this.additionalData = additionalData;
    }

    public /* synthetic */ SuggestedRefactoringState(PsiElement psiElement, SuggestedRefactoringSupport suggestedRefactoringSupport, ErrorLevel errorLevel, String string, String string2, SuggestedRefactoringSupport.Signature signature, SuggestedRefactoringSupport.Signature signature2, List list, Map map, int n, AdditionalData additionalData, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x100) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 0x200) != 0) {
            int n3 = SuggestedRefactoringStateKt.access$getNextFeatureUsageId$p();
            SuggestedRefactoringStateKt.access$setNextFeatureUsageId$p(n3 + 1);
            n = n3;
        }
        if ((n2 & 0x400) != 0) {
            additionalData = AdditionalData.Companion.getEmpty();
        }
        this(psiElement, suggestedRefactoringSupport, errorLevel, string, string2, signature, signature2, list, map, n, additionalData);
    }

    @NotNull
    public final PsiElement getAnchor() {
        return this.anchor;
    }

    @NotNull
    public final SuggestedRefactoringSupport getRefactoringSupport() {
        return this.refactoringSupport;
    }

    @NotNull
    public final ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    @NotNull
    public final String getOldDeclarationText() {
        return this.oldDeclarationText;
    }

    @Nullable
    public final String getOldImportsText() {
        return this.oldImportsText;
    }

    @NotNull
    public final SuggestedRefactoringSupport.Signature getOldSignature() {
        return this.oldSignature;
    }

    @NotNull
    public final SuggestedRefactoringSupport.Signature getNewSignature() {
        return this.newSignature;
    }

    @NotNull
    public final List<ParameterMarker> getParameterMarkers() {
        return this.parameterMarkers;
    }

    @NotNull
    public final Map<String, Object> getDisappearedParameters() {
        return this.disappearedParameters;
    }

    public final int getFeatureUsageId() {
        return this.featureUsageId;
    }

    @NotNull
    public final AdditionalData getAdditionalData() {
        return this.additionalData;
    }

    @Nullable
    public final PsiElement getDeclaration() {
        return this.refactoringSupport.getStateChanges().findDeclaration(this.anchor);
    }

    @NotNull
    public final SuggestedRefactoringState withAnchor(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        SuggestedRefactoringState state = new SuggestedRefactoringState(anchor, this.refactoringSupport, this.errorLevel, this.oldDeclarationText, this.oldImportsText, this.oldSignature, this.newSignature, this.parameterMarkers, this.disappearedParameters, this.featureUsageId, this.additionalData);
        this.copyRestoredDeclaration(state);
        return state;
    }

    @NotNull
    public final SuggestedRefactoringState withErrorLevel(@NotNull ErrorLevel errorLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorLevel), (String)"errorLevel");
        SuggestedRefactoringState state = new SuggestedRefactoringState(this.anchor, this.refactoringSupport, errorLevel, this.oldDeclarationText, this.oldImportsText, this.oldSignature, this.newSignature, this.parameterMarkers, this.disappearedParameters, this.featureUsageId, this.additionalData);
        this.copyRestoredDeclaration(state);
        return state;
    }

    @NotNull
    public final SuggestedRefactoringState withOldSignature(@NotNull SuggestedRefactoringSupport.Signature oldSignature) {
        Intrinsics.checkNotNullParameter((Object)oldSignature, (String)"oldSignature");
        SuggestedRefactoringState state = new SuggestedRefactoringState(this.anchor, this.refactoringSupport, this.errorLevel, this.oldDeclarationText, this.oldImportsText, oldSignature, this.newSignature, this.parameterMarkers, this.disappearedParameters, this.featureUsageId, this.additionalData);
        this.copyRestoredDeclaration(state);
        return state;
    }

    @NotNull
    public final SuggestedRefactoringState withNewSignature(@NotNull SuggestedRefactoringSupport.Signature newSignature) {
        Intrinsics.checkNotNullParameter((Object)newSignature, (String)"newSignature");
        SuggestedRefactoringState state = new SuggestedRefactoringState(this.anchor, this.refactoringSupport, this.errorLevel, this.oldDeclarationText, this.oldImportsText, this.oldSignature, newSignature, this.parameterMarkers, this.disappearedParameters, this.featureUsageId, this.additionalData);
        this.copyRestoredDeclaration(state);
        return state;
    }

    @NotNull
    public final SuggestedRefactoringState withParameterMarkers(@NotNull List<ParameterMarker> parameterMarkers) {
        Intrinsics.checkNotNullParameter(parameterMarkers, (String)"parameterMarkers");
        SuggestedRefactoringState state = new SuggestedRefactoringState(this.anchor, this.refactoringSupport, this.errorLevel, this.oldDeclarationText, this.oldImportsText, this.oldSignature, this.newSignature, parameterMarkers, this.disappearedParameters, this.featureUsageId, this.additionalData);
        this.copyRestoredDeclaration(state);
        return state;
    }

    @NotNull
    public final SuggestedRefactoringState withDisappearedParameters(@NotNull Map<String, ? extends Object> disappearedParameters) {
        Intrinsics.checkNotNullParameter(disappearedParameters, (String)"disappearedParameters");
        SuggestedRefactoringState state = new SuggestedRefactoringState(this.anchor, this.refactoringSupport, this.errorLevel, this.oldDeclarationText, this.oldImportsText, this.oldSignature, this.newSignature, this.parameterMarkers, disappearedParameters, this.featureUsageId, this.additionalData);
        this.copyRestoredDeclaration(state);
        return state;
    }

    @NotNull
    public final <T> SuggestedRefactoringState withAdditionalData(@NotNull Key<T> key, @NotNull T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        SuggestedRefactoringState state = new SuggestedRefactoringState(this.anchor, this.refactoringSupport, this.errorLevel, this.oldDeclarationText, this.oldImportsText, this.oldSignature, this.newSignature, this.parameterMarkers, this.disappearedParameters, this.featureUsageId, this.additionalData.withData(key, value));
        this.copyRestoredDeclaration(state);
        return state;
    }

    private final void copyRestoredDeclaration(SuggestedRefactoringState toState) {
        if (Intrinsics.areEqual((Object)toState.anchor, (Object)this.anchor)) {
            toState.restoredDeclarationCopy = this.restoredDeclarationCopy;
        }
    }

    @Nullable
    public final PsiElement restoredDeclarationCopy() {
        if (!(this.errorLevel != ErrorLevel.INCONSISTENT)) {
            boolean bl = false;
            String string = "restoredDeclarationCopy() should not be invoked for inconsistent state";
            throw new IllegalArgumentException(string.toString());
        }
        PsiElement decl = this.getDeclaration();
        if (decl != this.anchor) {
            return decl;
        }
        if (this.restoredDeclarationCopy == null) {
            this.restoredDeclarationCopy = this.createRestoredDeclarationCopy();
        }
        PsiElement psiElement = this.restoredDeclarationCopy;
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    private final PsiElement createRestoredDeclarationCopy() {
        if (!this.anchor.isValid()) {
            throw new ProcessCanceledException();
        }
        PsiFile psiFile = this.anchor.getContainingFile();
        TextRange textRange = this.refactoringSupport.signatureRange(this.anchor);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange signatureRange = textRange;
        Intrinsics.checkNotNull((Object)psiFile);
        TextRange importsRange = this.refactoringSupport.importsRange(psiFile);
        if (importsRange != null && importsRange.getLength() != 0 && !(importsRange.getEndOffset() < signatureRange.getStartOffset())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        PsiElement psiElement = psiFile.copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        PsiFile fileCopy = (PsiFile)psiElement;
        Document document = fileCopy.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        document2.replaceString(signatureRange.getStartOffset(), signatureRange.getEndOffset(), (CharSequence)this.oldDeclarationText);
        if (this.oldImportsText != null) {
            TextRange textRange2 = importsRange;
            Intrinsics.checkNotNull((Object)textRange2);
            document2.replaceString(textRange2.getStartOffset(), importsRange.getEndOffset(), (CharSequence)this.oldImportsText);
        }
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document2);
        int originalSignatureStart = signatureRange.getStartOffset();
        if (this.oldImportsText != null) {
            TextRange textRange3 = importsRange;
            Intrinsics.checkNotNull((Object)textRange3);
            originalSignatureStart -= textRange3.getLength();
            originalSignatureStart += this.oldImportsText.length();
        }
        PsiElement psiElement2 = SuggestedRefactoringSupportKt.anchorByOffset(this.refactoringSupport, fileCopy, originalSignatureStart);
        Intrinsics.checkNotNull((Object)psiElement2);
        return psiElement2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0086\u0002\u00a2\u0006\u0002\u0010\nJ+\u0010\u000b\u001a\u00020\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\f\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "", "map", "Lcom/intellij/util/keyFMap/KeyFMap;", "<init>", "(Lcom/intellij/util/keyFMap/KeyFMap;)V", "get", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "withData", "data", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "Companion", "intellij.platform.lang"})
    public static final class AdditionalData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final KeyFMap map;
        @NotNull
        private static final AdditionalData Empty;

        private AdditionalData(KeyFMap map) {
            this.map = map;
        }

        @Nullable
        public final <T> T get(@NotNull Key<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return (T)this.map.get(key);
        }

        @NotNull
        public final <T> AdditionalData withData(@NotNull Key<T> key, @NotNull T data) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            KeyFMap keyFMap = this.map.plus(key, data);
            Intrinsics.checkNotNullExpressionValue((Object)keyFMap, (String)"plus(...)");
            return new AdditionalData(keyFMap);
        }

        static {
            KeyFMap keyFMap = KeyFMap.EMPTY_MAP;
            Intrinsics.checkNotNullExpressionValue((Object)keyFMap, (String)"EMPTY_MAP");
            Empty = new AdditionalData(keyFMap);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData$Companion;", "", "<init>", "()V", "Empty", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "getEmpty", "()Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$AdditionalData;", "intellij.platform.lang"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AdditionalData getEmpty() {
                return Empty;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$ErrorLevel;", "", "<init>", "(Ljava/lang/String;I)V", "NO_ERRORS", "SYNTAX_ERROR", "INCONSISTENT", "intellij.platform.lang"})
    public static final class ErrorLevel
    extends Enum<ErrorLevel> {
        public static final /* enum */ ErrorLevel NO_ERRORS = new ErrorLevel();
        public static final /* enum */ ErrorLevel SYNTAX_ERROR = new ErrorLevel();
        public static final /* enum */ ErrorLevel INCONSISTENT = new ErrorLevel();
        private static final /* synthetic */ ErrorLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ErrorLevel[] values() {
            return (ErrorLevel[])$VALUES.clone();
        }

        public static ErrorLevel valueOf(String value) {
            return Enum.valueOf(ErrorLevel.class, value);
        }

        @NotNull
        public static EnumEntries<ErrorLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = errorLevelArray = new ErrorLevel[]{ErrorLevel.NO_ERRORS, ErrorLevel.SYNTAX_ERROR, ErrorLevel.INCONSISTENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringState$ParameterMarker;", "", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "parameterId", "<init>", "(Lcom/intellij/openapi/editor/RangeMarker;Ljava/lang/Object;)V", "getRangeMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "getParameterId", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang"})
    public static final class ParameterMarker {
        @NotNull
        private final RangeMarker rangeMarker;
        @NotNull
        private final Object parameterId;

        public ParameterMarker(@NotNull RangeMarker rangeMarker, @NotNull Object parameterId) {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
            Intrinsics.checkNotNullParameter((Object)parameterId, (String)"parameterId");
            this.rangeMarker = rangeMarker;
            this.parameterId = parameterId;
        }

        @NotNull
        public final RangeMarker getRangeMarker() {
            return this.rangeMarker;
        }

        @NotNull
        public final Object getParameterId() {
            return this.parameterId;
        }

        @NotNull
        public final RangeMarker component1() {
            return this.rangeMarker;
        }

        @NotNull
        public final Object component2() {
            return this.parameterId;
        }

        @NotNull
        public final ParameterMarker copy(@NotNull RangeMarker rangeMarker, @NotNull Object parameterId) {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
            Intrinsics.checkNotNullParameter((Object)parameterId, (String)"parameterId");
            return new ParameterMarker(rangeMarker, parameterId);
        }

        public static /* synthetic */ ParameterMarker copy$default(ParameterMarker parameterMarker, RangeMarker rangeMarker, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                rangeMarker = parameterMarker.rangeMarker;
            }
            if ((n & 2) != 0) {
                object = parameterMarker.parameterId;
            }
            return parameterMarker.copy(rangeMarker, object);
        }

        @NotNull
        public String toString() {
            return "ParameterMarker(rangeMarker=" + this.rangeMarker + ", parameterId=" + this.parameterId + ")";
        }

        public int hashCode() {
            int result = this.rangeMarker.hashCode();
            result = result * 31 + this.parameterId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterMarker)) {
                return false;
            }
            ParameterMarker parameterMarker = (ParameterMarker)other;
            if (!Intrinsics.areEqual((Object)this.rangeMarker, (Object)parameterMarker.rangeMarker)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parameterId, (Object)parameterMarker.parameterId);
        }
    }
}

