/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.IconSize;
import com.intellij.ide.bookmark.MnemonicPainter;
import com.intellij.lang.LangBundle;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconWrapperWithToolTip;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.RegionPaintIcon;
import com.intellij.util.ui.RegionPainter;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/bookmark/BookmarkIcon;", "Lcom/intellij/ui/icons/IconWrapperWithToolTip;", "mnemonic", "", "size", "Lcom/intellij/ide/bookmark/IconSize;", "<init>", "(CLcom/intellij/ide/bookmark/IconSize;)V", "icon", "Ljavax/swing/Icon;", "(CLjavax/swing/Icon;)V", "getMnemonic", "()C", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "Companion", "intellij.platform.lang"})
public final class BookmarkIcon
extends IconWrapperWithToolTip {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char mnemonic;

    public final char getMnemonic() {
        return this.mnemonic;
    }

    public BookmarkIcon(char mnemonic, @NotNull IconSize size) {
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        this(mnemonic, BookmarkIcon.Companion.createBookmarkIcon(mnemonic, size));
    }

    private BookmarkIcon(char mnemonic, Icon icon) {
        Supplier<String> supplier = LangBundle.messagePointer("tooltip.bookmarked", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(icon, supplier);
        this.mnemonic = mnemonic;
    }

    @NotNull
    public BookmarkIcon replaceBy(@NotNull IconReplacer replacer) {
        Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
        Icon icon = replacer.replaceIcon(this.retrieveIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
        return new BookmarkIcon(this.mnemonic, icon);
    }

    @JvmStatic
    private static final Icon createBookmarkIcon(char mnemonic, IconSize size) {
        return BookmarkIcon.Companion.createBookmarkIcon(mnemonic, size);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/bookmark/BookmarkIcon$Companion;", "", "<init>", "()V", "createBookmarkIcon", "Ljavax/swing/Icon;", "mnemonic", "", "size", "Lcom/intellij/ide/bookmark/IconSize;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final Icon createBookmarkIcon(char mnemonic, IconSize size) {
            if (mnemonic == '\u0000') {
                Icon icon;
                if (WhenMappings.$EnumSwitchMapping$0[size.ordinal()] == 1) {
                    Icon icon2 = AllIcons.Gutter.Bookmark;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Bookmark");
                } else {
                    Icon icon3 = AllIcons.Nodes.Bookmark;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Bookmark");
                }
                return icon;
            }
            Icon icon = WhenMappings.$EnumSwitchMapping$0[size.ordinal()] == 1 ? AllIcons.Gutter.Mnemonic : AllIcons.Nodes.Mnemonic;
            Intrinsics.checkNotNull((Object)icon);
            Icon icon4 = icon;
            MnemonicPainter painter = new MnemonicPainter(icon4, String.valueOf(mnemonic));
            int paintSize = WhenMappings.$EnumSwitchMapping$0[size.ordinal()] == 1 ? (ExperimentalUI.Companion.isNewUI() ? 14 : 12) : 16;
            JBScalableIcon jBScalableIcon = new RegionPaintIcon(paintSize, paintSize, 0, (RegionPainter)painter).withIconPreScaled(false);
            Intrinsics.checkNotNullExpressionValue((Object)jBScalableIcon, (String)"withIconPreScaled(...)");
            return (Icon)jBScalableIcon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IconSize.values().length];
                try {
                    nArray[IconSize.GUTTER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

