/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.parameters;

import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.url.parameters.PathVariableDefinitionsSearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolvingHint;
import org.jetbrains.annotations.NotNull;

public class PathVariableUsageReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements ResolvingHint,
HighlightedReference {
    private final PathVariableDefinitionsSearcher mySearcher;

    public PathVariableUsageReference(@NotNull PsiElement host, PathVariableDefinitionsSearcher searcher) {
        if (host == null) {
            PathVariableUsageReference.$$$reportNull$$$0(0);
        }
        super(host, false);
        this.mySearcher = searcher;
    }

    public PathVariableUsageReference(@NotNull PsiElement host, @NotNull TextRange rangeInElement, PathVariableDefinitionsSearcher searcher) {
        if (host == null) {
            PathVariableUsageReference.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            PathVariableUsageReference.$$$reportNull$$$0(2);
        }
        super(host, rangeInElement);
        this.mySearcher = searcher;
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = this.mySearcher.getPathVariables(this.getElement()).toArray((Object[])new PomTargetPsiElement[0]);
        if (objectArray == null) {
            PathVariableUsageReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        HttpReferenceService service = (HttpReferenceService)ApplicationManager.getApplication().getService(HttpReferenceService.class);
        ResolveResult[] resolveResultArray = service.resolvePathVariableUsage(this.getValue(), this.getElement(), this.mySearcher);
        if (resolveResultArray == null) {
            PathVariableUsageReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        HttpReferenceService service;
        if (element == null) {
            PathVariableUsageReference.$$$reportNull$$$0(5);
        }
        return (service = (HttpReferenceService)ApplicationManager.getApplication().getService(HttpReferenceService.class)).isReferenceToPathVariableDeclaration(element) && super.isReferenceTo(element);
    }

    public boolean canResolveTo(@NotNull Class<? extends PsiElement> elementClass) {
        if (elementClass == null) {
            PathVariableUsageReference.$$$reportNull$$$0(6);
        }
        HttpReferenceService service = (HttpReferenceService)ApplicationManager.getApplication().getService(HttpReferenceService.class);
        return service.canResolveToPathVariableDeclaration(elementClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/url/parameters/PathVariableUsageReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/url/parameters/PathVariableUsageReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canResolveTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

