/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.references.DefaultFrameworkUrlPathSpecification;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.SplitEscaper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/url/references/DefaultFrameworkUrlPathSpecification;", "Lcom/intellij/microservices/url/FrameworkUrlPathSpecification;", "<init>", "()V", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "declaration", "Lcom/intellij/psi/PsiElement;", "parser", "Lcom/intellij/microservices/url/references/UrlPksParser;", "getParser", "()Lcom/intellij/microservices/url/references/UrlPksParser;", "intellij.platform.lang"})
public final class DefaultFrameworkUrlPathSpecification
extends FrameworkUrlPathSpecification {
    @NotNull
    public static final DefaultFrameworkUrlPathSpecification INSTANCE;
    @NotNull
    private static final UrlPksParser parser;

    private DefaultFrameworkUrlPathSpecification() {
    }

    @Override
    @NotNull
    public UrlPathContext getUrlPathContext(@NotNull PsiElement declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UrlPathContext urlPathContext = UrlPathContext.Companion.supportingSchemes$default(UrlPathContext.Companion, UrlConstants.HTTP_METHODS, null, 2, null);
        UrlPksParser urlPksParser = this.getParser();
        String string = ElementManipulators.getValueText((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return urlPathContext.subContext(urlPksParser.parseUrlPath(new PartiallyKnownString(string, declaration, textRange)).getUrlPath());
    }

    @Override
    @NotNull
    public UrlPksParser getParser() {
        return parser;
    }

    static {
        UrlPksParser urlPksParser;
        INSTANCE = new DefaultFrameworkUrlPathSpecification();
        UrlPksParser $this$parser_u24lambda_u240 = urlPksParser = new UrlPksParser(null, null, false, 7, null);
        boolean bl = false;
        $this$parser_u24lambda_u240.setSplitEscaper((Function2<? super CharSequence, ? super String, ? extends SplitEscaper>)((Function2)parser.1.1.INSTANCE));
        $this$parser_u24lambda_u240.setShouldHaveScheme(false);
        $this$parser_u24lambda_u240.setParseQueryParameters(false);
        parser = urlPksParser;
    }
}

