/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightAction
extends AnAction
implements PerformWithDocumentsCommitted {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CodeInsightAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CodeInsightAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null) {
            Editor editor = this.getEditor(e.getDataContext(), project, false);
            this.actionPerformedImpl(project, editor, e.getDataContext());
        }
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project, boolean forUpdate) {
        if (dataContext == null) {
            CodeInsightAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(3);
        }
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    public void actionPerformedImpl(@NotNull Project project, Editor editor) {
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(4);
        }
        this.actionPerformedImpl(project, editor, DataContext.EMPTY_CONTEXT);
    }

    private void actionPerformedImpl(@NotNull Project project, Editor editor, @NotNull DataContext dataContext) {
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            CodeInsightAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            return;
        }
        CodeInsightActionHandler handler = this.getHandler(dataContext);
        PsiElement elementToMakeWritable = handler.getElementToMakeWritable(psiFile);
        if (!(elementToMakeWritable == null || EditorModificationUtil.checkModificationAllowed((Editor)editor) && FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{elementToMakeWritable}))) {
            return;
        }
        if (elementToMakeWritable instanceof PsiCompiledElement) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action = () -> {
                if (!UIUtil.isShowing((Component)editor.getContentComponent())) {
                    return;
                }
                handler.invoke(project, editor, psiFile);
            };
            if (handler.startInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(action);
            } else {
                action.run();
            }
        }, this.getCommandName(), (Object)DocCommandGroupId.noneGroupId((Document)editor.getDocument()), editor.getDocument());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CodeInsightAction.$$$reportNull$$$0(7);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext, project, true);
        if (editor == null) {
            presentation.setVisible(!e.isFromContextMenu());
            presentation.setEnabled(false);
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (psiFile == null) {
            presentation.setEnabled(false);
            return;
        }
        this.update(presentation, project, editor, psiFile, dataContext, e.getPlace());
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (presentation == null) {
            CodeInsightAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            CodeInsightAction.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            CodeInsightAction.$$$reportNull$$$0(11);
        }
        presentation.setEnabled(this.isValidForFile(project, editor, psiFile));
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        if (presentation == null) {
            CodeInsightAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            CodeInsightAction.$$$reportNull$$$0(14);
        }
        if (psiFile == null) {
            CodeInsightAction.$$$reportNull$$$0(15);
        }
        if (dataContext == null) {
            CodeInsightAction.$$$reportNull$$$0(16);
        }
        this.update(presentation, project, editor, psiFile);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            CodeInsightAction.$$$reportNull$$$0(18);
        }
        if (psiFile == null) {
            CodeInsightAction.$$$reportNull$$$0(19);
        }
        return true;
    }

    @ApiStatus.Obsolete
    @NotNull
    protected abstract CodeInsightActionHandler getHandler();

    @NotNull
    protected CodeInsightActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CodeInsightAction.$$$reportNull$$$0(20);
        }
        CodeInsightActionHandler codeInsightActionHandler = this.getHandler();
        if (codeInsightActionHandler == null) {
            CodeInsightAction.$$$reportNull$$$0(21);
        }
        return codeInsightActionHandler;
    }

    @NlsContexts.Command
    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/CodeInsightAction";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/CodeInsightAction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

