/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReference {
    public static final NullableFunction<PathReference, Icon> NULL_ICON = new NullableConstantFunction(null);
    private final String myPath;
    private final NullableLazyValue<Icon> myIcon;

    public PathReference(@NotNull String path, final @NotNull Function<? super PathReference, ? extends Icon> icon) {
        if (path == null) {
            PathReference.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            PathReference.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myIcon = new NullableLazyValue<Icon>(){

            protected Icon compute() {
                return (Icon)icon.fun((Object)PathReference.this);
            }
        };
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            PathReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getTrimmedPath() {
        String string = PathReference.trimPath(this.myPath);
        if (string == null) {
            PathReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    public static String trimPath(String url) {
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return url.substring(0, i);
                }
            }
        }
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PathReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PathReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class ResolveFunction
    implements NullableFunction<PathReference, Icon> {
        public static final ResolveFunction NULL_RESOLVE_FUNCTION = new ResolveFunction(null);
        private final Icon myDefaultIcon;

        public ResolveFunction(@Nullable Icon defaultValue) {
            this.myDefaultIcon = defaultValue;
        }

        public Icon fun(PathReference pathReference) {
            PsiElement element = pathReference.resolve();
            return element == null ? this.myDefaultIcon : element.getIcon(2);
        }
    }
}

