/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.issue;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bJ\u0013\u0010\u0019\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0011J\u0013\u0010\u001a\u001a\u00020\u00182\u000b\u0010\u001b\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006 "}, d2={"Lcom/intellij/build/issue/ConfigurableBuildIssue;", "Lcom/intellij/build/issue/BuildIssue;", "<init>", "()V", "configurator", "Lcom/intellij/build/issue/ConfigurableBuildIssue$BuildIssueConfigurator;", "title", "", "Lcom/intellij/build/events/BuildEventsNls$Title;", "getTitle", "()Ljava/lang/String;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "()Ljava/util/List;", "description", "Lcom/intellij/build/events/BuildEventsNls$Description;", "getDescription", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "setTitle", "", "addDescription", "addQuickFixPrompt", "quickFixPrompt", "addQuickFix", "quickFix", "QuickFix", "BuildIssueConfigurator", "intellij.platform.lang"})
public abstract class ConfigurableBuildIssue
implements BuildIssue {
    @NotNull
    private final BuildIssueConfigurator configurator = new BuildIssueConfigurator();

    @Override
    @NotNull
    public final String getTitle() {
        return this.configurator.getTitle();
    }

    @Override
    @NotNull
    public final List<BuildIssueQuickFix> getQuickFixes() {
        return this.configurator.getQuickFixes();
    }

    @Override
    @NotNull
    public final String getDescription() {
        return this.configurator.createDescription();
    }

    @Override
    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public final void setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.configurator.setTitle(title);
    }

    public final void addDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.configurator.getDescription().add(description);
    }

    public final void addQuickFixPrompt(@NotNull String quickFixPrompt) {
        Intrinsics.checkNotNullParameter((Object)quickFixPrompt, (String)"quickFixPrompt");
        this.configurator.getQuickFixPrompts().add(quickFixPrompt);
    }

    @CheckReturnValue
    @NotNull
    public final String addQuickFix(@NotNull BuildIssueQuickFix quickFix) {
        Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
        int ordinal = this.configurator.getQuickFixes().size();
        String hyperlinkReference = quickFix.getId() + "(" + ordinal + ")";
        QuickFix orderedQuickFix = new QuickFix(hyperlinkReference, quickFix);
        this.configurator.getQuickFixes().add(orderedQuickFix);
        return hyperlinkReference;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000b\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0016R\u001f\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/build/issue/ConfigurableBuildIssue$BuildIssueConfigurator;", "", "<init>", "()V", "title", "", "Lcom/intellij/build/events/BuildEventsNls$Title;", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "description", "", "Lcom/intellij/build/events/BuildEventsNls$Description;", "getDescription", "()Ljava/util/List;", "quickFixPrompts", "getQuickFixPrompts", "quickFixes", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "getQuickFixes", "createDescription", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.lang"})
    private static final class BuildIssueConfigurator {
        public String title;
        @NotNull
        private final List<String> description = new ArrayList();
        @NotNull
        private final List<String> quickFixPrompts = new ArrayList();
        @NotNull
        private final List<BuildIssueQuickFix> quickFixes = new ArrayList();

        @NotNull
        public final String getTitle() {
            String string = this.title;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"title");
            return null;
        }

        public final void setTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.title = string;
        }

        @NotNull
        public final List<String> getDescription() {
            return this.description;
        }

        @NotNull
        public final List<String> getQuickFixPrompts() {
            return this.quickFixPrompts;
        }

        @NotNull
        public final List<BuildIssueQuickFix> getQuickFixes() {
            return this.quickFixes;
        }

        @NotNull
        public final String createDescription() {
            StringBuilder stringBuilder;
            StringBuilder $this$createDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$createDescription_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)this.description, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null)).append("\n");
            if (!((Collection)this.quickFixPrompts).isEmpty()) {
                $this$createDescription_u24lambda_u240.append("\n");
                Object[] objectArray = new Object[]{this.quickFixPrompts.size()};
                $this$createDescription_u24lambda_u240.append(LangBundle.message("build.issue.quick.fix.title", objectArray));
                $this$createDescription_u24lambda_u240.append("\n");
                $this$createDescription_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)this.quickFixPrompts, (CharSequence)"\n", null, null, (int)0, null, BuildIssueConfigurator::createDescription$lambda$0$0, (int)30, null));
                $this$createDescription_u24lambda_u240.append("\n");
            }
            return stringBuilder.toString();
        }

        private static final CharSequence createDescription$lambda$0$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return " - " + it;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/build/issue/ConfigurableBuildIssue$QuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "hyperlinkReference", "", "delegate", "<init>", "(Ljava/lang/String;Lcom/intellij/build/issue/BuildIssueQuickFix;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.lang"})
    private static final class QuickFix
    implements BuildIssueQuickFix {
        @NotNull
        private final BuildIssueQuickFix delegate;
        @NotNull
        private final String id;

        public QuickFix(@NotNull String hyperlinkReference, @NotNull BuildIssueQuickFix delegate) {
            Intrinsics.checkNotNullParameter((Object)hyperlinkReference, (String)"hyperlinkReference");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.id = hyperlinkReference;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return this.delegate.runQuickFix(project, dataContext);
        }
    }
}

