/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.util.EnvVariables;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.execution.util.StringWithNewLinesCellEditor;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004$%&'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\rH\u0014J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002J\u0016\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0002H\u0014J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0015\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!H\u0014\u00a2\u0006\u0002\u0010#R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/intellij/execution/util/EnvVariablesTable;", "Lcom/intellij/execution/util/ListTableWithButtons;", "Lcom/intellij/execution/util/EnvironmentVariable;", "<init>", "()V", "myPanel", "Lcom/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel;", "myPasteEnabled", "", "setPasteActionEnabled", "", "enabled", "createListModel", "Lcom/intellij/util/ui/ListTableModel;", "editVariableName", "environmentVariable", "setValues", "list", "", "environmentVariables", "", "getEnvironmentVariables", "()Ljava/util/List;", "getComponent", "Ljavax/swing/JComponent;", "createElement", "isEmpty", "element", "cloneElement", "envVariable", "canDeleteElement", "selection", "createExtraToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "NameColumnInfo", "ValueColumnInfo", "CopyPasteProviderPanel", "Companion", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nEnvVariablesTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvVariablesTable.kt\ncom/intellij/execution/util/EnvVariablesTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1#2:290\n*E\n"})
public class EnvVariablesTable
extends ListTableWithButtons<EnvironmentVariable> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CopyPasteProviderPanel myPanel;
    private boolean myPasteEnabled;

    public EnvVariablesTable() {
        AnAction pasteAction;
        this.getTableView().getEmptyText().setText(ExecutionBundle.message((String)"empty.text.no.variables", (Object[])new Object[0]));
        AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
        if (copyAction != null) {
            copyAction.registerCustomShortcutSet(copyAction.getShortcutSet(), (JComponent)this.getTableView());
        }
        if ((pasteAction = ActionManager.getInstance().getAction("$Paste")) != null) {
            pasteAction.registerCustomShortcutSet(pasteAction.getShortcutSet(), (JComponent)this.getTableView());
        }
    }

    public final void setPasteActionEnabled(boolean enabled) {
        this.myPasteEnabled = enabled;
    }

    @Override
    @Nullable
    protected ListTableModel<EnvironmentVariable> createListModel() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new NameColumnInfo(), new ValueColumnInfo()};
        return new ListTableModel(columnInfoArray);
    }

    public final void editVariableName(@NotNull EnvironmentVariable environmentVariable) {
        Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
        ApplicationManager.getApplication().invokeLater(() -> EnvVariablesTable.editVariableName$lambda$0(this, environmentVariable));
    }

    @Override
    public void setValues(@NotNull List<? extends EnvironmentVariable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        super.setValues(ContainerUtil.sorted((Collection)list, Comparator.comparing(arg_0 -> EnvVariablesTable.setValues$lambda$1(EnvVariablesTable::setValues$lambda$0, arg_0), NaturalComparator.INSTANCE)));
    }

    @NotNull
    public final List<EnvironmentVariable> getEnvironmentVariables() {
        List<EnvironmentVariable> list = this.getElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getElements(...)");
        return list;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CopyPasteProviderPanel(super.getComponent());
        }
        CopyPasteProviderPanel copyPasteProviderPanel = this.myPanel;
        Intrinsics.checkNotNull((Object)copyPasteProviderPanel);
        return copyPasteProviderPanel;
    }

    @Override
    @NotNull
    protected EnvironmentVariable createElement() {
        return new EnvironmentVariable("", "", false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isEmpty(@NotNull EnvironmentVariable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (((CharSequence)string).length() != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        String string2 = element.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        if (((CharSequence)string2).length() != 0) return false;
        return true;
    }

    @Override
    @Nullable
    protected EnvironmentVariable cloneElement(@NotNull EnvironmentVariable envVariable) {
        Intrinsics.checkNotNullParameter((Object)envVariable, (String)"envVariable");
        return envVariable.clone();
    }

    @Override
    protected boolean canDeleteElement(@NotNull EnvironmentVariable selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return !selection.getIsPredefined();
    }

    @Override
    @NotNull
    protected AnAction[] createExtraToolbarActions() {
        AnAction copyButton = ActionManager.getInstance().getAction("$Copy");
        AnAction pasteButton = ActionManager.getInstance().getAction("$Paste");
        AnAction[] anActionArray = new AnAction[]{copyButton, pasteButton};
        return anActionArray;
    }

    private static final void editVariableName$lambda$0(EnvVariablesTable this$0, EnvironmentVariable $environmentVariable) {
        Object v1;
        block3: {
            List list = this$0.getElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getElements(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                EnvironmentVariable it = (EnvironmentVariable)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$environmentVariable.getName())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        EnvironmentVariable actualEnvVar = v1;
        if (actualEnvVar == null) {
            return;
        }
        this$0.setSelection(actualEnvVar);
        if (actualEnvVar.getNameIsWriteable()) {
            this$0.editSelection(0);
        }
    }

    private static final String setValues$lambda$0(EnvironmentVariable obj) {
        EnvironmentVariable environmentVariable = obj;
        Intrinsics.checkNotNull((Object)environmentVariable);
        return environmentVariable.getName();
    }

    private static final String setValues$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> parseEnvsFromText(@Nullable String content) {
        return Companion.parseEnvsFromText(content);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/util/EnvVariablesTable$Companion;", "", "<init>", "()V", "parseEnvsFromText", "", "", "content", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> parseEnvsFromText(@Nullable String content) {
            return MapsKt.toMutableMap(EnvVariables.Companion.parseFromText(content).getEnvs());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0011\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/ide/PasteProvider;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/execution/util/EnvVariablesTable;Ljavax/swing/JComponent;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "performCopy", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "", "isCopyVisible", "performPaste", "isPastePossible", "isPasteEnabled", "intellij.platform.lang"})
    @SourceDebugExtension(value={"SMAP\nEnvVariablesTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvVariablesTable.kt\ncom/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n774#2:290\n865#2,2:291\n*S KotlinDebug\n*F\n+ 1 EnvVariablesTable.kt\ncom/intellij/execution/util/EnvVariablesTable$CopyPasteProviderPanel\n*L\n238#1:290\n238#1:291,2\n*E\n"})
    private final class CopyPasteProviderPanel
    extends JPanel
    implements UiDataProvider,
    CopyProvider,
    PasteProvider {
        public CopyPasteProviderPanel(JComponent component) {
            super(new GridLayout(1, 1));
            this.add(component);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
            sink.set(dataKey, (Object)this);
            DataKey dataKey2 = PlatformDataKeys.PASTE_PROVIDER;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PASTE_PROVIDER");
            sink.set(dataKey2, (Object)this);
        }

        public void performCopy(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            TableView tableView = EnvVariablesTable.this.getTableView();
            Intrinsics.checkNotNullExpressionValue(tableView, (String)"getTableView(...)");
            TableView view = tableView;
            if (view.isEditing()) {
                int row = view.getEditingRow();
                int column = view.getEditingColumn();
                if (row < 0 || column < 0) {
                    row = view.getSelectedRow();
                    column = view.getSelectedColumn();
                }
                if (row >= 0 && column >= 0) {
                    TableCellEditor tableCellEditor = view.getCellEditor();
                    Intrinsics.checkNotNull((Object)tableCellEditor, (String)"null cannot be cast to non-null type javax.swing.DefaultCellEditor");
                    Component component = ((DefaultCellEditor)tableCellEditor).getComponent();
                    String text = "";
                    Component component2 = component;
                    if (component2 instanceof JTextField) {
                        text = ((JTextField)component).getSelectedText();
                    } else if (component2 instanceof JComboBox) {
                        Component component3 = ((JComboBox)component).getEditor().getEditorComponent();
                        Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type javax.swing.JTextField");
                        text = ((JTextField)component3).getSelectedText();
                    } else {
                        Logger.getInstance(EnvVariablesTable.class).error("Unknown editor type: " + component);
                    }
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
                }
                return;
            }
            EnvVariablesTable.this.stopEditing();
            StringBuilder sb = new StringBuilder();
            List list = EnvVariablesTable.this.getSelection();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSelection(...)");
            List variables = list;
            for (EnvironmentVariable environmentVariable : variables) {
                Intrinsics.checkNotNull((Object)environmentVariable);
                if (EnvVariablesTable.this.isEmpty(environmentVariable)) continue;
                if (!(((CharSequence)sb).length() == 0)) {
                    sb.append(';');
                }
                char[] cArray = new char[]{'=', ';'};
                StringBuilder stringBuilder = sb.append(StringUtil.escapeChars((String)environmentVariable.getName(), (char[])cArray)).append('=');
                cArray = new char[]{'=', ';'};
                stringBuilder.append(StringUtil.escapeChars((String)environmentVariable.getValue(), (char[])cArray));
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return !EnvVariablesTable.this.getSelection().isEmpty();
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return this.isCopyEnabled(dataContext);
        }

        /*
         * WARNING - void declaration
         */
        public void performPaste(@NotNull DataContext dataContext) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            String content = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
            if (StringUtil.isEmpty((String)content)) {
                return;
            }
            Map<String, String> map = Companion.parseEnvsFromText(content);
            TableView tableView = EnvVariablesTable.this.getTableView();
            Intrinsics.checkNotNullExpressionValue(tableView, (String)"getTableView(...)");
            TableView view = tableView;
            if (view.isEditing() || map.isEmpty()) {
                Component component;
                TableCellEditor editor;
                int row = view.getEditingRow();
                int column = view.getEditingColumn();
                if (row < 0 || column < 0) {
                    row = view.getSelectedRow();
                    column = view.getSelectedColumn();
                }
                if (row >= 0 && column >= 0 && (editor = view.getCellEditor()) != null && (component = ((DefaultCellEditor)editor).getComponent()) instanceof JTextField) {
                    ((JTextField)component).paste();
                }
                return;
            }
            EnvVariablesTable.this.stopEditing();
            List parsed = new ArrayList();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                parsed.add(new EnvironmentVariable(entry.getKey(), entry.getValue(), false));
            }
            Iterable $this$filter$iv = CollectionsKt.plus((Collection)EnvVariablesTable.this.getEnvironmentVariables(), (Iterable)parsed);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EnvironmentVariable it = (EnvironmentVariable)element$iv$iv;
                boolean bl = false;
                if (!(!StringUtil.isEmpty((String)it.getName()) || !StringUtil.isEmpty((String)it.getValue()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List variables = (List)destination$iv$iv;
            EnvVariablesTable.this.setValues(variables);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return EnvVariablesTable.this.myPasteEnabled;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return EnvVariablesTable.this.myPasteEnabled;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/util/EnvVariablesTable$NameColumnInfo;", "Lcom/intellij/execution/util/ListTableWithButtons$ElementsColumnInfoBase;", "Lcom/intellij/execution/util/EnvironmentVariable;", "<init>", "(Lcom/intellij/execution/util/EnvVariablesTable;)V", "valueOf", "", "environmentVariable", "isCellEditable", "", "setValue", "", "s", "getDescription", "getEditor", "Ljavax/swing/table/TableCellEditor;", "variable", "intellij.platform.lang"})
    protected class NameColumnInfo
    extends ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> {
        public NameColumnInfo() {
            super(ExecutionBundle.message((String)"env.variable.column.name.title", (Object[])new Object[0]));
        }

        @Nullable
        public String valueOf(@NotNull EnvironmentVariable environmentVariable) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            return environmentVariable.getName();
        }

        public boolean isCellEditable(@NotNull EnvironmentVariable environmentVariable) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            return environmentVariable.getNameIsWriteable();
        }

        public void setValue(@NotNull EnvironmentVariable environmentVariable, @NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (Intrinsics.areEqual((Object)s, (Object)this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setName(s);
            EnvVariablesTable.this.setModified();
        }

        @Override
        @Nullable
        protected String getDescription(@NotNull EnvironmentVariable environmentVariable) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            return environmentVariable.getDescription();
        }

        @NotNull
        public TableCellEditor getEditor(@NotNull EnvironmentVariable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return new DefaultCellEditor(new JTextField());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/util/EnvVariablesTable$ValueColumnInfo;", "Lcom/intellij/execution/util/ListTableWithButtons$ElementsColumnInfoBase;", "Lcom/intellij/execution/util/EnvironmentVariable;", "<init>", "(Lcom/intellij/execution/util/EnvVariablesTable;)V", "valueOf", "", "environmentVariable", "isCellEditable", "", "setValue", "", "s", "getDescription", "getEditor", "Ljavax/swing/table/TableCellEditor;", "variable", "intellij.platform.lang"})
    protected class ValueColumnInfo
    extends ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> {
        public ValueColumnInfo() {
            super(ExecutionBundle.message((String)"env.variable.column.value.title", (Object[])new Object[0]));
        }

        @Nullable
        public String valueOf(@NotNull EnvironmentVariable environmentVariable) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            return environmentVariable.getValue();
        }

        public boolean isCellEditable(@NotNull EnvironmentVariable environmentVariable) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            return !environmentVariable.getIsPredefined();
        }

        public void setValue(@NotNull EnvironmentVariable environmentVariable, @NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (Intrinsics.areEqual((Object)s, (Object)this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setValue(s);
            EnvVariablesTable.this.setModified();
        }

        @Override
        @Nullable
        protected String getDescription(@NotNull EnvironmentVariable environmentVariable) {
            Intrinsics.checkNotNullParameter((Object)environmentVariable, (String)"environmentVariable");
            return environmentVariable.getDescription();
        }

        @NotNull
        public TableCellEditor getEditor(@Nullable EnvironmentVariable variable) {
            return new StringWithNewLinesCellEditor();
        }
    }
}

