/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class AbstractUrl {
    @ApiStatus.Internal
    @NonNls
    public static final String TYPE_DIRECTORY = "directory";
    @ApiStatus.Internal
    @NonNls
    public static final String TYPE_LIBRARY_MODULE_GROUP = "libraryModuleGroup";
    @ApiStatus.Internal
    @NonNls
    public static final String TYPE_MODULE_GROUP = "module_group";
    @ApiStatus.Internal
    @NonNls
    public static final String TYPE_MODULE = "module";
    @ApiStatus.Internal
    @NonNls
    public static final String TYPE_NAMED_LIBRARY = "namedLibrary";
    @ApiStatus.Internal
    @NonNls
    public static final String TYPE_PSI_FILE = "psiFile";
    @NotNull
    protected final String url;
    protected final String moduleName;
    private final String myType;
    private static final List<AbstractUrl> ourAbstractUrlProviders = Collections.synchronizedList(new ArrayList());

    protected AbstractUrl(String url, @Nullable String moduleName, @NotNull @NonNls String type) {
        if (type == null) {
            AbstractUrl.$$$reportNull$$$0(0);
        }
        this.myType = type;
        this.url = StringUtil.notNullize((String)url);
        this.moduleName = moduleName;
        ourAbstractUrlProviders.add(this);
    }

    @NotNull
    public String getURL() {
        String string = this.url;
        if (string == null) {
            AbstractUrl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.myType;
        if (string == null) {
            AbstractUrl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void write(Element element) {
        element.setAttribute("url", this.url);
        if (this.moduleName != null) {
            element.setAttribute(TYPE_MODULE, this.moduleName);
        }
        element.setAttribute("type", this.myType);
    }

    public abstract Object @Nullable [] createPath(Project var1);

    @Nullable(value="return null if cannot recognize the element")
    public @Nullable(value="return null if cannot recognize the element") AbstractUrl createUrl(String type, String moduleName, String url) {
        if (type.equals(this.myType)) {
            return this.createUrl(moduleName, url);
        }
        return null;
    }

    protected abstract AbstractUrl createUrl(String var1, String var2);

    public abstract AbstractUrl createUrlByElement(Object var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUrl that = (AbstractUrl)o;
        if (this.moduleName != null ? !this.moduleName.equals(that.moduleName) : that.moduleName != null) {
            return false;
        }
        return this.myType.equals(that.myType) && this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 29 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 29 * result + this.myType.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": type=" + this.myType + ", module=" + this.moduleName + ", url=" + this.url;
    }

    @ApiStatus.Internal
    public static List<AbstractUrl> getAbstractUrlProviders() {
        ((AbstractUrlLoader)ApplicationManager.getApplication().getService(AbstractUrlLoader.class)).loadUrls();
        return ourAbstractUrlProviders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractUrl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getURL";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface AbstractUrlLoader {
        public void loadUrls();
    }
}

