/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.parameters;

import com.intellij.codeWithMe.ClientId;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.url.parameters.QueryParameterNameTarget;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlSegmentReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PartiallyKnownStringKt;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/microservices/url/parameters/QueryParameterNameReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/microservices/url/references/UrlSegmentReference;", "context", "Lcom/intellij/microservices/url/references/UrlPathContext;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "forceFindUsagesOnNavigate", "", "<init>", "(Lcom/intellij/microservices/url/references/UrlPathContext;Lcom/intellij/psi/PsiLanguageInjectionHost;Lcom/intellij/openapi/util/TextRange;Z)V", "getContext", "()Lcom/intellij/microservices/url/references/UrlPathContext;", "queryParameterPomTarget", "Lcom/intellij/microservices/url/parameters/QueryParameterNameTarget;", "getQueryParameterPomTarget", "()Lcom/intellij/microservices/url/parameters/QueryParameterNameTarget;", "queryParameterPomTarget$delegate", "Lkotlin/Lazy;", "resolve", "getValue", "", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nQueryParameterNameReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryParameterNameReference.kt\ncom/intellij/microservices/url/parameters/QueryParameterNameReference\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,50:1\n42#2,3:51\n42#2,3:54\n*S KotlinDebug\n*F\n+ 1 QueryParameterNameReference.kt\ncom/intellij/microservices/url/parameters/QueryParameterNameReference\n*L\n48#1:51,3\n31#1:54,3\n*E\n"})
public final class QueryParameterNameReference
extends PsiReferenceBase<PsiElement>
implements UrlSegmentReference {
    @NotNull
    private final UrlPathContext context;
    private final boolean forceFindUsagesOnNavigate;
    @NotNull
    private final Lazy queryParameterPomTarget$delegate;

    public QueryParameterNameReference(@NotNull UrlPathContext context, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInElement, boolean forceFindUsagesOnNavigate) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
        super((PsiElement)host, rangeInElement, false);
        this.context = context;
        this.forceFindUsagesOnNavigate = forceFindUsagesOnNavigate;
        this.queryParameterPomTarget$delegate = LazyKt.lazy(() -> QueryParameterNameReference.queryParameterPomTarget_delegate$lambda$0(this));
    }

    public /* synthetic */ QueryParameterNameReference(UrlPathContext urlPathContext, PsiLanguageInjectionHost psiLanguageInjectionHost, TextRange textRange, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            TextRange textRange2 = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)psiLanguageInjectionHost));
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getValueTextRange(...)");
            textRange = textRange2;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(urlPathContext, psiLanguageInjectionHost, textRange, bl);
    }

    @NotNull
    public final UrlPathContext getContext() {
        return this.context;
    }

    private final QueryParameterNameTarget getQueryParameterPomTarget() {
        Lazy lazy = this.queryParameterPomTarget$delegate;
        return (QueryParameterNameTarget)lazy.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        QueryParameterNameTarget queryParameterNameTarget = this.getQueryParameterPomTarget();
        return queryParameterNameTarget != null ? queryParameterNameTarget.toElement(this.forceFindUsagesOnNavigate) : null;
    }

    @NotNull
    public String getValue() {
        try {
            String string = super.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            return string;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            Throwable throwable = e;
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            Attachment[] attachmentArray = PartiallyKnownStringKt.mkAttachments(psiElement);
            throw new RuntimeExceptionWithAttachments(throwable, Arrays.copyOf(attachmentArray, attachmentArray.length));
        }
    }

    @NotNull
    public Object[] getVariants() {
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((HttpReferenceService)object).getQueryParameterNameVariants(this.getQueryParameterPomTarget());
    }

    private static final QueryParameterNameTarget queryParameterPomTarget_delegate$lambda$0(QueryParameterNameReference this$0) {
        if (CollectionsKt.none(this$0.context.getResolveRequests())) {
            return null;
        }
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        UrlPathContext urlPathContext = this$0.context;
        String string = this$0.getValue();
        Project project = this$0.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return httpReferenceService.createQueryParameterNameTarget(urlPathContext, string, project);
    }
}

