/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\r\u001a\u00020\nJ\n\u0010\u000e\u001a\u00020\nH\u0096\u0080\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u0014\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0017\u001a\u00020\u0013H\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/microservices/url/UrlPath;", "", "segments", "", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "<init>", "(Ljava/util/List;)V", "getSegments", "()Ljava/util/List;", "getPresentation", "", "pathVariableRenderer", "Lcom/intellij/microservices/url/UrlPath$PathSegmentRenderer;", "toStringWithStars", "toString", "canBePrefixFor", "", "another", "commonLength", "", "isCompatibleWith", "equals", "other", "hashCode", "PathSegment", "PathSegmentRenderer", "Companion", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n363#2,7:338\n1786#2,3:346\n1#3:345\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath\n*L\n153#1:338,7\n183#1:346,3\n*E\n"})
public final class UrlPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathSegment> segments;
    @NotNull
    private static final UrlPath EMPTY = new UrlPath(CollectionsKt.listOf((Object)new PathSegment.Exact("")));
    @NotNull
    private static final String STAR = "*";
    @NotNull
    private static final String UNKNOWN = "<???>";
    @NotNull
    public static final String UNKNOWN_URL_PATH_SEGMENT_PRESENTATION = "${..}";
    @JvmField
    @NotNull
    public static final PathSegmentRenderer DEFAULT_PATH_VARIABLE_PRESENTATION = new PathSegmentRenderer(){

        public String visitVariable(PathSegment.Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return "*";
        }
    };
    @JvmField
    @NotNull
    public static final PathSegmentRenderer FULL_PATH_VARIABLE_PRESENTATION = new PathSegmentRenderer(){

        public String visitVariable(PathSegment.Variable variable) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            StringBuilder $this$visitVariable_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            CharSequence charSequence = variable.getVariableName();
            if (charSequence == null || charSequence.length() == 0) {
                v0 = $this$visitVariable_u24lambda_u240.append("*");
            } else {
                $this$visitVariable_u24lambda_u240.append("{");
                $this$visitVariable_u24lambda_u240.append(variable.getVariableName());
                v0 = $this$visitVariable_u24lambda_u240.append("}");
            }
            return stringBuilder.toString();
        }
    };

    public UrlPath(@NotNull List<? extends PathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
    }

    @NotNull
    public final List<PathSegment> getSegments() {
        return this.segments;
    }

    @NlsSafe
    @NotNull
    public final String getPresentation() {
        return this.getPresentation(DEFAULT_PATH_VARIABLE_PRESENTATION);
    }

    @NlsSafe
    @NotNull
    public final String getPresentation(@NotNull PathSegmentRenderer pathVariableRenderer) {
        Intrinsics.checkNotNullParameter((Object)pathVariableRenderer, (String)"pathVariableRenderer");
        return CollectionsKt.joinToString$default((Iterable)this.segments, (CharSequence)"/", null, null, (int)0, null, arg_0 -> UrlPath.getPresentation$lambda$0(pathVariableRenderer, arg_0), (int)30, null);
    }

    @NotNull
    public final String toStringWithStars() {
        return CollectionsKt.joinToString$default((Iterable)this.segments, (CharSequence)"/", null, null, (int)0, null, UrlPath::toStringWithStars$lambda$0, (int)30, null);
    }

    @NotNull
    public String toString() {
        return "UrlPath(" + this.toStringWithStars() + ")";
    }

    public final boolean canBePrefixFor(@NotNull UrlPath another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return this.commonLength(another) == this.segments.size();
    }

    public final int commonLength(@NotNull UrlPath another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return UrlPath.commonLength$commonLength(another, this.segments, 0, 0);
    }

    public final boolean isCompatibleWith(@NotNull UrlPath another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return UrlPath.isCompatibleWith$compatible(this.segments, another.segments);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.microservices.url.UrlPath");
        UrlPath cfr_ignored_0 = (UrlPath)object2;
        return Intrinsics.areEqual(this.segments, ((UrlPath)other).segments);
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    private static final CharSequence getPresentation$lambda$0(PathSegmentRenderer $pathVariableRenderer, PathSegment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return $pathVariableRenderer.patternMatch(segment);
    }

    private static final CharSequence toStringWithStars$lambda$0(PathSegment it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PathSegment pathSegment = it;
        if (pathSegment instanceof PathSegment.Exact) {
            charSequence = ((PathSegment.Exact)it).getValue();
        } else if (pathSegment instanceof PathSegment.Variable) {
            charSequence = STAR;
        } else if (pathSegment instanceof PathSegment.Composite) {
            charSequence = STAR;
        } else if (Intrinsics.areEqual((Object)pathSegment, (Object)PathSegment.Undefined.INSTANCE)) {
            charSequence = UNKNOWN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }

    private static final int commonLength$commonLength(UrlPath $another, List<? extends PathSegment> cur, int start, int accum) {
        while (UtilKt.headTailOrNull(cur) != null) {
            PathSegment aHead;
            int n;
            Pair pair;
            PathSegment head = (PathSegment)pair.component1();
            List tail = (List)pair.component2();
            List<PathSegment> remaining = $another.segments.subList(start, $another.segments.size());
            if (head instanceof PathSegment.Exact) {
                int n2;
                int n3;
                block12: {
                    List<PathSegment> $this$indexOfFirst$iv = remaining;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<PathSegment> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        PathSegment item$iv;
                        PathSegment it = item$iv = iterator.next();
                        boolean bl = false;
                        if (it instanceof PathSegment.Exact) {
                            n3 = index$iv;
                            break block12;
                        }
                        ++index$iv;
                    }
                    n3 = -1;
                }
                Integer n4 = n3;
                int it = ((Number)n4).intValue();
                boolean bl = false;
                Integer n5 = it != -1 ? n4 : null;
                if (n5 == null) {
                    return accum;
                }
                int anotherExactIndex = n5;
                PathSegment pathSegment = remaining.get(anotherExactIndex);
                Intrinsics.checkNotNull((Object)pathSegment, (String)"null cannot be cast to non-null type com.intellij.microservices.url.UrlPath.PathSegment.Exact");
                PathSegment.Exact anotherExact = (PathSegment.Exact)pathSegment;
                if (Intrinsics.areEqual((Object)anotherExact, (Object)head)) {
                    n = start + anotherExactIndex + 1;
                    n2 = accum + 1;
                    cur = tail;
                    start = n;
                    accum = n2;
                    continue;
                }
                if (((CharSequence)((PathSegment.Exact)head).getValue()).length() == 0) {
                    n = start;
                    n2 = accum + 1;
                    cur = tail;
                    start = n;
                    accum = n2;
                    continue;
                }
                Object object = CollectionsKt.firstOrNull(remaining);
                PathSegment.Variable variable = object instanceof PathSegment.Variable ? (PathSegment.Variable)object : null;
                boolean bl2 = variable != null ? variable.accepts(((PathSegment.Exact)head).getValue()) : false;
                if (bl2) {
                    n = start + 1;
                    n2 = accum + 1;
                    cur = tail;
                    start = n;
                    accum = n2;
                    continue;
                }
                if (CollectionsKt.firstOrNull(remaining) instanceof PathSegment.Undefined) {
                    n = start + 1;
                    n2 = accum + 1;
                    cur = tail;
                    start = n;
                    accum = n2;
                    continue;
                }
                return accum;
            }
            if ((PathSegment)CollectionsKt.firstOrNull(remaining) == null) {
                return accum;
            }
            if (!(aHead instanceof PathSegment.Exact)) {
                int n6 = start + 1;
                n = accum + 1;
                cur = tail;
                start = n6;
                accum = n;
                continue;
            }
            int n7 = start;
            n = accum + 1;
            cur = tail;
            start = n7;
            accum = n;
        }
        return accum;
    }

    private static final boolean isCompatibleWith$isEmptyExact(PathSegment headA) {
        return headA instanceof PathSegment.Exact && Intrinsics.areEqual((Object)((PathSegment.Exact)headA).getValue(), (Object)"");
    }

    private static final boolean isCompatibleWith$hasValue(List<? extends PathSegment> another) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = another;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PathSegment it = (PathSegment)element$iv;
                    boolean bl2 = false;
                    if (UrlPath.isCompatibleWith$isEmptyExact(it) || it instanceof PathSegment.Undefined) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return !bl;
    }

    private static final boolean isCompatibleWith$compatible(List<? extends PathSegment> cur, List<? extends PathSegment> another) {
        block19: {
            while (true) {
                Pair pair;
                Pair pair2;
                if (cur.isEmpty() && !UrlPath.isCompatibleWith$hasValue(another)) {
                    return true;
                }
                if (another.isEmpty() && !UrlPath.isCompatibleWith$hasValue(cur)) {
                    return true;
                }
                if (cur.isEmpty() && another.isEmpty()) {
                    return true;
                }
                if (UtilKt.headTailOrNull(cur) == null) {
                    return false;
                }
                PathSegment headA = (PathSegment)pair2.component1();
                List tailA = (List)pair2.component2();
                if (UtilKt.headTailOrNull(another) == null) {
                    return false;
                }
                PathSegment headB = (PathSegment)pair.component1();
                List<? extends PathSegment> tailB = (List<? extends PathSegment>)pair.component2();
                if (UrlPath.isCompatibleWith$isEmptyExact(headA)) {
                    List<? extends PathSegment> list = UrlPath.isCompatibleWith$isEmptyExact(headB) ? tailB : another;
                    cur = tailA;
                    another = list;
                    continue;
                }
                if (UrlPath.isCompatibleWith$isEmptyExact(headB)) {
                    cur = UrlPath.isCompatibleWith$isEmptyExact(headA) ? tailA : cur;
                    another = tailB;
                    continue;
                }
                if (headA instanceof PathSegment.Undefined && headB instanceof PathSegment.Undefined) {
                    cur = tailA;
                    another = tailB;
                    continue;
                }
                if (headA instanceof PathSegment.Undefined && UrlPath.isCompatibleWith$hasValue(tailA) || headB instanceof PathSegment.Undefined && UrlPath.isCompatibleWith$hasValue(tailB)) {
                    cur = tailA;
                    another = tailB;
                    continue;
                }
                if (headA instanceof PathSegment.Undefined && !UrlPath.isCompatibleWith$hasValue(tailA)) {
                    return true;
                }
                if (headB instanceof PathSegment.Undefined && !UrlPath.isCompatibleWith$hasValue(tailB)) {
                    return true;
                }
                if (headA instanceof PathSegment.Variable && headB instanceof PathSegment.Variable) {
                    cur = tailA;
                    another = tailB;
                    continue;
                }
                if (headA instanceof PathSegment.Variable && headB instanceof PathSegment.Exact) {
                    if (((PathSegment.Variable)headA).accepts(((PathSegment.Exact)headB).getValue())) {
                        cur = tailA;
                        another = tailB;
                        continue;
                    }
                    return false;
                }
                if (headA instanceof PathSegment.Exact && headB instanceof PathSegment.Variable) {
                    if (((PathSegment.Variable)headB).accepts(((PathSegment.Exact)headA).getValue())) {
                        cur = tailA;
                        another = tailB;
                        continue;
                    }
                    return false;
                }
                if (headA instanceof PathSegment.Exact && headB instanceof PathSegment.Exact) {
                    if (Intrinsics.areEqual((Object)((PathSegment.Exact)headA).getValue(), (Object)((PathSegment.Exact)headB).getValue())) {
                        cur = tailA;
                        another = tailB;
                        continue;
                    }
                    return false;
                }
                if (!(headA instanceof PathSegment.Composite) || !(headB instanceof PathSegment.Composite)) break block19;
                if (!new UrlPath(((PathSegment.Composite)headA).getSegments()).isCompatibleWith(new UrlPath(((PathSegment.Composite)headB).getSegments()))) break;
                cur = tailA;
                another = tailB;
            }
            return false;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final UrlPath fromExactString(@NotNull String string) {
        return Companion.fromExactString(string);
    }

    @JvmStatic
    @NotNull
    public static final Sequence<UrlPath> combinations(@NotNull UrlPath urlPath) {
        return Companion.combinations(urlPath);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/url/UrlPath$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/microservices/url/UrlPath;", "getEMPTY", "()Lcom/intellij/microservices/url/UrlPath;", "STAR", "", "UNKNOWN", "UNKNOWN_URL_PATH_SEGMENT_PRESENTATION", "DEFAULT_PATH_VARIABLE_PRESENTATION", "Lcom/intellij/microservices/url/UrlPath$PathSegmentRenderer;", "FULL_PATH_VARIABLE_PRESENTATION", "fromExactString", "string", "combinations", "Lkotlin/sequences/Sequence;", "urlPath", "intellij.platform.lang"})
    @SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,337:1\n1586#2:338\n1661#2,3:339\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPath$Companion\n*L\n254#1:338\n254#1:339,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UrlPath getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final UrlPath fromExactString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String[] stringArray = new String[]{"/"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PathSegment.Exact((String)it));
            }
            List list = (List)destination$iv$iv;
            return new UrlPath(list);
        }

        @JvmStatic
        @NotNull
        public final Sequence<UrlPath> combinations(@NotNull UrlPath urlPath) {
            Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super UrlPath>, Continuation<? super Unit>, Object>(urlPath, null){
                Object L$1;
                Object L$2;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ UrlPath $urlPath;
                {
                    this.$urlPath = $urlPath;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)this.$urlPath, (Continuation)this);
                            if (v0 == var12_3) {
                                return var12_3;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            v1 = (PathSegment)CollectionsKt.firstOrNull(this.$urlPath.getSegments());
                            v2 = v1 != null ? v1.isEmpty() : false;
                            if (v2) {
                                this.L$0 = $this$sequence;
                                this.label = 2;
                                v3 = $this$sequence.yield((Object)new UrlPath(this.$urlPath.getSegments().subList(1, this.$urlPath.getSegments().size())), (Continuation)this);
                                if (v3 == var12_3) {
                                    return var12_3;
                                }
                            }
                            ** GOTO lbl27
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl27:
                            // 2 sources

                            var5_4 = this.$urlPath.getSegments();
                            $i$f$indexOfFirst = false;
                            index$iv = 0;
                            var8_8 = $this$indexOfFirst$iv.iterator();
                            while (var8_8.hasNext()) {
                                item$iv = var8_8.next();
                                it = (PathSegment)item$iv;
                                $i$a$-indexOfFirst-UrlPath$Companion$combinations$1$undefined$1 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)PathSegment.Undefined.INSTANCE)) ** GOTO lbl39
                                v4 = index$iv;
                                ** GOTO lbl42
lbl39:
                                // 1 sources

                                ++index$iv;
                            }
                            v4 = -1;
lbl42:
                            // 2 sources

                            $this$indexOfFirst$iv = Boxing.boxInt((int)v4);
                            it = ((Number)$this$indexOfFirst$iv).intValue();
                            $i$a$-takeIf-UrlPath$Companion$combinations$1$undefined$2 = false;
                            v5 = it != -1 != false ? $this$indexOfFirst$iv : null;
                            if (v5 == null) {
                                return Unit.INSTANCE;
                            }
                            undefined = v5;
                            starting = this.$urlPath.getSegments().subList(0, undefined);
                            ending = this.$urlPath.getSegments().subList(undefined + 1, this.$urlPath.getSegments().size());
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$sequence);
                            this.L$1 = SpillingKt.nullOutSpilledVariable(starting);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(ending);
                            this.I$0 = undefined;
                            this.label = 3;
                            v6 = $this$sequence.yieldAll(UrlPath.Companion.combinations(new UrlPath(CollectionsKt.plus((Collection)starting, (Iterable)ending))), (Continuation)this);
                            if (v6 == var12_3) {
                                return var12_3;
                            }
                            ** GOTO lbl66
                        }
                        case 3: {
                            undefined = this.I$0;
                            ending = (List)this.L$2;
                            starting = (List)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl66:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super UrlPath> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment;", "", "<init>", "()V", "valueIfExact", "", "getValueIfExact", "()Ljava/lang/String;", "isEmpty", "", "Exact", "Variable", "Composite", "Undefined", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Exact;", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Undefined;", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Variable;", "intellij.platform.lang"})
    public static abstract sealed class PathSegment {
        private PathSegment() {
        }

        @Nullable
        public final String getValueIfExact() {
            Exact exact = this instanceof Exact ? (Exact)this : null;
            return exact != null ? exact.getValue() : null;
        }

        public final boolean isEmpty() {
            String string = this.getValueIfExact();
            return string != null ? ((CharSequence)string).length() == 0 : false;
        }

        public /* synthetic */ PathSegment(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0082\u0004J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "segments", "", "<init>", "(Ljava/util/List;)V", "getSegments", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.lang"})
        public static final class Composite
        extends PathSegment {
            @NotNull
            private final List<PathSegment> segments;

            public Composite(@NotNull List<? extends PathSegment> segments) {
                Intrinsics.checkNotNullParameter(segments, (String)"segments");
                super(null);
                this.segments = segments;
            }

            @NotNull
            public final List<PathSegment> getSegments() {
                return this.segments;
            }

            public boolean equals(@Nullable Object other) {
                Composite composite = other instanceof Composite ? (Composite)other : null;
                return Intrinsics.areEqual(composite != null ? composite.segments : null, this.segments);
            }

            public int hashCode() {
                return ((Object)this.segments).hashCode();
            }

            @NotNull
            public String toString() {
                return "PathSegment.Composite(" + this.segments + ")";
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0082\u0004J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004J\n\u0010\u000e\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Exact;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.lang"})
        public static final class Exact
        extends PathSegment {
            @NotNull
            private final String value;

            public Exact(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public boolean equals(@Nullable Object other) {
                Exact exact = other instanceof Exact ? (Exact)other : null;
                return Intrinsics.areEqual((Object)(exact != null ? exact.value : null), (Object)this.value);
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            @NotNull
            public String toString() {
                return "PathSegment.Exact(" + this.value + ")";
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Undefined;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "<init>", "()V", "intellij.platform.lang"})
        public static final class Undefined
        extends PathSegment {
            @NotNull
            public static final Undefined INSTANCE = new Undefined();

            private Undefined() {
                super(null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0082\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u0096\u0080\u0004J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0003R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegment$Variable;", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "variableName", "", "regex", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getVariableName", "()Ljava/lang/String;", "getRegex", "equals", "", "other", "", "hashCode", "", "toString", "accepts", "value", "intellij.platform.lang"})
        public static final class Variable
        extends PathSegment {
            @Nullable
            private final String variableName;
            @Nullable
            private final String regex;

            public Variable(@Nullable String variableName, @Nullable String regex) {
                super(null);
                this.variableName = variableName;
                this.regex = regex;
            }

            public /* synthetic */ Variable(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                this(string, string2);
            }

            @Nullable
            public final String getVariableName() {
                return this.variableName;
            }

            @Nullable
            public final String getRegex() {
                return this.regex;
            }

            public boolean equals(@Nullable Object other) {
                Variable variable = other instanceof Variable ? (Variable)other : null;
                return Intrinsics.areEqual((Object)(variable != null ? variable.variableName : null), (Object)this.variableName);
            }

            public int hashCode() {
                String string = this.variableName;
                return string != null ? string.hashCode() : 0;
            }

            @NotNull
            public String toString() {
                return "PathSegment.Variable({" + this.variableName + "})";
            }

            public final boolean accepts(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return true;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/microservices/url/UrlPath$PathSegmentRenderer;", "", "visitExact", "", "exact", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Exact;", "visitVariable", "variable", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Variable;", "visitUndefined", "visitComposite", "composite", "Lcom/intellij/microservices/url/UrlPath$PathSegment$Composite;", "patternMatch", "segment", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "intellij.platform.lang"})
    public static interface PathSegmentRenderer {
        @NotNull
        default public String visitExact(@NotNull PathSegment.Exact exact) {
            Intrinsics.checkNotNullParameter((Object)exact, (String)"exact");
            return exact.getValue();
        }

        @NotNull
        default public String visitVariable(@NotNull PathSegment.Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return UrlPath.STAR;
        }

        @NotNull
        default public String visitUndefined() {
            return UrlPath.UNKNOWN_URL_PATH_SEGMENT_PRESENTATION;
        }

        @NotNull
        default public String visitComposite(@NotNull PathSegment.Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
            return CollectionsKt.joinToString$default((Iterable)composite.getSegments(), (CharSequence)"", null, null, (int)0, null, arg_0 -> PathSegmentRenderer.visitComposite$lambda$0(this, arg_0), (int)30, null);
        }

        @NotNull
        default public String patternMatch(@NotNull PathSegment segment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            PathSegment pathSegment = segment;
            if (pathSegment instanceof PathSegment.Exact) {
                string = this.visitExact((PathSegment.Exact)segment);
            } else if (pathSegment instanceof PathSegment.Variable) {
                string = this.visitVariable((PathSegment.Variable)segment);
            } else if (pathSegment instanceof PathSegment.Composite) {
                string = this.visitComposite((PathSegment.Composite)segment);
            } else if (Intrinsics.areEqual((Object)pathSegment, (Object)PathSegment.Undefined.INSTANCE)) {
                string = this.visitUndefined();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private static CharSequence visitComposite$lambda$0(PathSegmentRenderer this$0, PathSegment s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this$0.patternMatch(s);
        }
    }
}

