// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.build.eventBuilders

import com.intellij.build.events.BuildEventsNls.Description
import com.intellij.build.events.BuildEventsNls.Hint
import com.intellij.build.events.FinishBuildEvent
import org.jetbrains.annotations.ApiStatus.NonExtendable
import org.jetbrains.annotations.CheckReturnValue

@NonExtendable
interface FinishBuildEventBuilder {

  @CheckReturnValue
  fun withParentId(parentId: Any?): FinishBuildEventBuilder

  @CheckReturnValue
  fun withTime(time: Long?): FinishBuildEventBuilder

  @CheckReturnValue
  fun withHint(hint: @Hint String?): FinishBuildEventBuilder

  @CheckReturnValue
  fun withDescription(description: @Description String?): FinishBuildEventBuilder

  fun build(): FinishBuildEvent
}
