/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.mime;

import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

@NonNls
public final class MimeTypes {
    public static final Pattern MIME_PATTERN = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String APPLICATION_X_YAML = "application/x-yaml";
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final String APPLICATION_SQL = "application/sql";
    public static final String APPLICATION_PDF = "application/pdf";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_JSON = "text/json";
    public static final String TEXT_CSV = "text/csv";
    public static final String TEXT_CSS = "text/css";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_WEBP = "image/webp";
    public static final String IMAGE_SVG = "image/svg+xml";
    public static final String AUDIO_MPEG = "audio/mpeg";
    public static final String AUDIO_VORBIS = "audio/vorbis";
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final String APPLICATION_STREAM_JSON = "application/stream+json";
    public static final String APPLICATION_X_NDJSON = "application/x-ndjson";
    public static final String[] PREDEFINED_MIME_VARIANTS = new String[]{"application/json", "application/xml", "application/x-yaml", "application/graphql", "application/atom+xml", "application/xhtml+xml", "application/svg+xml", "application/sql", "application/pdf", "application/zip", "application/x-www-form-urlencoded", "multipart/form-data", "application/octet-stream", "text/plain", "text/xml", "text/html", "text/json", "text/csv", "image/png", "image/jpeg", "image/gif", "image/webp", "image/svg+xml", "audio/mpeg", "audio/vorbis", "text/event-stream", "application/stream+json", "application/x-ndjson"};
    public static final Set<String> PREDEFINED_TEXT_MIME_TYPES = Set.of("application/xml", "application/x-yaml", "application/yaml", "application/json", "application/graphql", "application/atom+xml", "application/xhtml+xml", "application/svg+xml", "application/sql", "application/x-www-form-urlencoded", "text/plain", "text/xml", "text/html", "text/json", "text/csv", "image/svg+xml");

    private MimeTypes() {
    }
}

