/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.oas;

import com.intellij.microservices.endpoints.EndpointsElementItem;
import com.intellij.microservices.endpoints.EndpointsListItem;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasExportUtilsKt$getOpenApiSpecification$;
import com.intellij.microservices.oas.OasHttpMethod;
import com.intellij.microservices.oas.OasModelUtils;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0014\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u001aE\u0010\u000b\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\f*\u00020\r\"\b\b\u0001\u0010\u000e*\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u0011\u001a\u0002H\f2\u0006\u0010\u0012\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0013\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"EMPTY_OPENAPI_SPECIFICATION", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "getEMPTY_OPENAPI_SPECIFICATION", "()Lcom/intellij/microservices/oas/OpenApiSpecification;", "getSpecificationByUrls", "urls", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "squashOpenApiSpecifications", "specifications", "", "getOpenApi", "G", "", "E", "provider", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "group", "endpoint", "(Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/microservices/oas/OpenApiSpecification;", "getOpenApiSpecification", "endpointsList", "", "Lcom/intellij/microservices/endpoints/EndpointsListItem;", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nOasExportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OasExportUtils.kt\ncom/intellij/microservices/oas/OasExportUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1586#2:108\n1661#2,3:109\n1391#2:112\n1480#2,5:113\n1512#2:118\n1538#2,3:119\n1541#2,3:129\n1391#2:132\n1480#2,5:133\n1391#2:138\n1480#2,5:139\n1786#2,3:144\n1696#2,8:147\n1915#2,2:155\n812#2,12:158\n1642#2,10:170\n1915#2:180\n1916#2:182\n1652#2:183\n1586#2:184\n1661#2,3:185\n1586#2:188\n1661#2,3:189\n383#3,7:122\n479#4:157\n1#5:181\n*S KotlinDebug\n*F\n+ 1 OasExportUtils.kt\ncom/intellij/microservices/oas/OasExportUtilsKt\n*L\n15#1:108\n15#1:109,3\n47#1:112\n47#1:113,5\n47#1:118\n47#1:119,3\n47#1:129,3\n51#1:132\n51#1:133,5\n63#1:138\n63#1:139,5\n65#1:144,3\n65#1:147,8\n76#1:155,2\n18#1:158,12\n19#1:170,10\n19#1:180\n19#1:182\n19#1:183\n27#1:184\n27#1:185,3\n31#1:188\n31#1:189,3\n47#1:122,7\n100#1:157\n19#1:181\n*E\n"})
public final class OasExportUtilsKt {
    @NotNull
    private static final OpenApiSpecification EMPTY_OPENAPI_SPECIFICATION = new OpenApiSpecification(CollectionsKt.emptyList(), null, null, 6, null);

    @NotNull
    public static final OpenApiSpecification getEMPTY_OPENAPI_SPECIFICATION() {
        return EMPTY_OPENAPI_SPECIFICATION;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final OpenApiSpecification getSpecificationByUrls(@NotNull Iterable<? extends UrlTargetInfo> urls) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable<? extends UrlTargetInfo> $this$map$iv = urls;
        boolean $i$f$map = false;
        Iterable<? extends UrlTargetInfo> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void urlTargetInfo;
            UrlTargetInfo urlTargetInfo2 = (UrlTargetInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OasEndpointPath.Builder(urlTargetInfo.getPath().getPresentation(OasModelUtils.getOPEN_API_PRESENTATION())).build((Function1<? super OasEndpointPath.Builder, Unit>)((Function1)arg_0 -> OasExportUtilsKt.getSpecificationByUrls$lambda$0$0((UrlTargetInfo)urlTargetInfo, arg_0))));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 6;
        List list = null;
        OasComponents oasComponents = null;
        Collection collection = (List)destination$iv$iv;
        return new OpenApiSpecification(collection, oasComponents, list, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final OpenApiSpecification squashOpenApiSpecifications(@NotNull List<OpenApiSpecification> specifications) {
        void $this$flatMapTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Object list$iv$iv;
        boolean bl;
        Object it;
        Iterable $this$flatMapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(specifications, (String)"specifications");
        if (specifications.size() <= 1) {
            OpenApiSpecification openApiSpecification = (OpenApiSpecification)CollectionsKt.firstOrNull(specifications);
            if (openApiSpecification == null) {
                openApiSpecification = EMPTY_OPENAPI_SPECIFICATION;
            }
            return openApiSpecification;
        }
        Iterable $this$flatMap$iv = specifications;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection collection = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (OpenApiSpecification)element$iv$iv;
            bl = false;
            list$iv$iv = ((OpenApiSpecification)it).getPaths();
            CollectionsKt.addAll((Collection)collection, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)collection;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv2 = $this$groupBy$iv;
        Map map = new LinkedHashMap();
        boolean $i$f$groupByTo232 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (OasEndpointPath)element$iv$iv;
            bl = false;
            String key$iv$iv = ((OasEndpointPath)it).getPath();
            Map map2 = map;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map grouped = map;
        List list = new ArrayList();
        Iterable $this$flatMap$iv2 = specifications;
        boolean bl2 = false;
        Iterable $i$f$groupByTo232 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            OpenApiSpecification it2 = (OpenApiSpecification)element$iv$iv;
            boolean bl42 = false;
            List list2 = it2.getTags();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv2 = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        List tags = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        for (Map.Entry entry : grouped.entrySet()) {
            boolean bl3;
            List operations;
            String summary;
            String path;
            boolean bl4;
            block18: {
                Iterator $this$flatMapTo$iv$iv3;
                List items = (List)entry.getValue();
                if (items.size() == 1) {
                    bl4 = list.addAll(items);
                    continue;
                }
                path = (String)entry.getKey();
                summary = ((OasEndpointPath)items.get(0)).getSummary();
                Iterable $this$flatMap$iv3 = items;
                boolean $i$f$flatMap3 = false;
                Iterable bl42 = $this$flatMap$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                Iterator value$iv$iv$iv = $this$flatMapTo$iv$iv3.iterator();
                while (value$iv$iv$iv.hasNext()) {
                    Object element$iv$iv = value$iv$iv$iv.next();
                    OasEndpointPath it3 = (OasEndpointPath)element$iv$iv;
                    boolean bl5 = false;
                    Iterable list$iv$iv3 = it3.getOperations();
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv3);
                }
                operations = (List)destination$iv$iv3;
                Iterable $this$all$iv = items;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    $this$flatMapTo$iv$iv3 = $this$all$iv.iterator();
                    while ($this$flatMapTo$iv$iv3.hasNext()) {
                        Object element$iv = $this$flatMapTo$iv$iv3.next();
                        OasEndpointPath it4 = (OasEndpointPath)element$iv;
                        boolean bl6 = false;
                        if (Intrinsics.areEqual((Object)it4.getSummary(), (Object)summary)) continue;
                        bl3 = false;
                        break block18;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                Iterable $this$distinctBy$iv = operations;
                boolean $i$f$distinctBy = false;
                HashSet<OasHttpMethod> set$iv = new HashSet<OasHttpMethod>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    OasOperation it5 = (OasOperation)e$iv;
                    boolean bl7 = false;
                    OasHttpMethod key$iv = it5.getMethod();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                if (((List)list$iv).size() == operations.size()) {
                    bl4 = list.add(new OasEndpointPath(path, summary, operations));
                    continue;
                }
            }
            bl4 = list.addAll((Collection)entry.getValue());
        }
        Map mergedSchemas = new LinkedHashMap();
        Iterable iterable2 = specifications;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable2) {
            OpenApiSpecification specification = (OpenApiSpecification)element$iv;
            boolean bl5 = false;
            Object object = specification.getComponents();
            if (object == null || (object = ((OasComponents)object).getSchemas()) == null) continue;
            Object specSchemas = object;
            boolean bl8 = false;
            mergedSchemas.putAll(specSchemas);
        }
        OasComponents oasComponents = !mergedSchemas.isEmpty() ? new OasComponents(mergedSchemas) : null;
        return new OpenApiSpecification(list, oasComponents, tags);
    }

    @Nullable
    public static final <G, E> OpenApiSpecification getOpenApi(@NotNull EndpointsProvider<G, E> provider, @NotNull G group, @NotNull E endpoint) {
        OpenApiSpecification openApiSpecification;
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        if (provider instanceof EndpointsUrlTargetProvider && ((EndpointsUrlTargetProvider)provider).shouldShowOpenApiPanel()) {
            OpenApiSpecification openApiFromProvider = ((EndpointsUrlTargetProvider)provider).getOpenApiSpecification(group, endpoint);
            openApiSpecification = openApiFromProvider;
            if (openApiSpecification == null) {
                openApiSpecification = OasExportUtilsKt.getSpecificationByUrls(((EndpointsUrlTargetProvider)provider).getUrlTargetInfo(group, endpoint));
            }
        } else {
            openApiSpecification = null;
        }
        return openApiSpecification;
    }

    @Nullable
    public static final OpenApiSpecification getOpenApiSpecification(@NotNull Collection<? extends EndpointsListItem> endpointsList) {
        Intrinsics.checkNotNullParameter(endpointsList, (String)"endpointsList");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)endpointsList);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getOpenApiSpecification$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List specifications = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence, OasExportUtilsKt::getOpenApiSpecification$lambda$0));
        if (specifications.isEmpty()) {
            return null;
        }
        return OasExportUtilsKt.squashOpenApiSpecifications(specifications);
    }

    private static final Unit getSpecificationByUrls$lambda$0$0$2$0(String $method, UrlTargetInfo $urlTargetInfo, List $pathParams, List $queryParams, OasOperation.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        String string = $method;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        $this$build.setSummary(string2 + " " + $urlTargetInfo.getPath().getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION));
        $this$build.setDeprecated($urlTargetInfo.isDeprecated());
        $this$build.setResponses(CollectionsKt.listOf((Object)new OasResponse("200", "OK", null, null, 12, null)));
        $this$build.setParameters(CollectionsKt.plus((Collection)$pathParams, (Iterable)$queryParams));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getSpecificationByUrls$lambda$0$0(UrlTargetInfo $urlTargetInfo, OasEndpointPath.Builder $this$build) {
        String it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        Iterable $this$filterIsInstance$iv = $urlTargetInfo.getPath().getSegments();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UrlPath.PathSegment.Variable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OasParameter it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UrlPath.PathSegment.Variable it2 = (UrlPath.PathSegment.Variable)element$iv$iv;
            boolean bl2 = false;
            String variableName = it2.getVariableName();
            if ((variableName != null ? OasParameter.Builder.build$default(new OasParameter.Builder(variableName, OasParameterIn.PATH), null, 1, null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pathParams = (List)destination$iv$iv;
        Iterable $this$map$iv = $urlTargetInfo.getQueryParameters();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv$iv = (UrlQueryParameter)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(OasParameter.Builder.build$default(new OasParameter.Builder(it.getName(), OasParameterIn.QUERY), null, 1, null));
        }
        List queryParams = (List)destination$iv$iv2;
        $this$map$iv = $urlTargetInfo.getMethods();
        object = $this$build;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void method;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new OasOperation.Builder((String)method).build((Function1<? super OasOperation.Builder, Unit>)((Function1)arg_0 -> OasExportUtilsKt.getSpecificationByUrls$lambda$0$0$2$0((String)method, $urlTargetInfo, pathParams, queryParams, arg_0))));
        }
        ((OasEndpointPath.Builder)object).setOperations((List)destination$iv$iv2);
        return Unit.INSTANCE;
    }

    private static final <G, E> OpenApiSpecification getOpenApiSpecification$getOpenApi(EndpointsElementItem<G, E> i) {
        return OasExportUtilsKt.getOpenApi(i.getProvider(), i.getGroup(), i.getEndpoint());
    }

    private static final OpenApiSpecification getOpenApiSpecification$lambda$0(EndpointsElementItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return OasExportUtilsKt.getOpenApiSpecification$getOpenApi(it);
    }
}

