/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.ActivityId;
import com.intellij.history.core.Content;
import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeSet {
    private static final int VERSION = 1;
    private final long myId;
    private final long myTimestamp;
    private final List<Change> myChanges;
    private @NlsContexts.Label @Nullable String myName;
    @Nullable
    @NonNls
    private ActivityId myActivityId = null;
    private volatile boolean isLocked = false;

    public ChangeSet(long id, long timestamp) {
        this.myId = id;
        this.myTimestamp = timestamp;
        this.myChanges = new ArrayList<Change>();
    }

    public ChangeSet(DataInput in) throws IOException {
        int version = DataInputOutputUtil.readINT((DataInput)in);
        this.myId = DataInputOutputUtil.readLONG((DataInput)in);
        this.myName = DataStreamUtil.readStringOrNull(in);
        this.myTimestamp = DataInputOutputUtil.readTIME((DataInput)in);
        if (version >= 1) {
            this.myActivityId = ChangeSet.readActivityId(in);
        }
        int count = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<Change> changes = new ArrayList<Change>(count);
        while (count-- > 0) {
            changes.add(DataStreamUtil.readChange(in));
        }
        this.myChanges = Collections.unmodifiableList(changes);
        this.isLocked = true;
    }

    public void write(DataOutput out) throws IOException {
        LocalHistoryLog.LOG.assertTrue(this.isLocked, (Object)"Changeset should be locked");
        if (LocalHistoryLog.LOG.isTraceEnabled()) {
            int maximumChanges = Registry.intValue((String)"lvcs.trace.changes.persistence.limit", (int)100);
            String lastChanges = this.myChanges.reversed().stream().limit(maximumChanges).map(Object::toString).collect(Collectors.joining("\n"));
            LocalHistoryLog.LOG.trace("Writing changeset. Changes count: " + this.myChanges.size() + ". 100 latest changes: \n" + lastChanges);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)1);
        DataInputOutputUtil.writeLONG((DataOutput)out, (long)this.myId);
        DataStreamUtil.writeStringOrNull(out, this.myName);
        DataInputOutputUtil.writeTIME((DataOutput)out, (long)this.myTimestamp);
        ChangeSet.writeActivityId(out, this.myActivityId);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChanges.size());
        for (Change c : this.myChanges) {
            DataStreamUtil.writeChange(out, c);
        }
    }

    public void setName(@NlsContexts.Label @Nullable String name) {
        this.myName = name;
    }

    @NlsContexts.Label
    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setActivityId(@Nullable ActivityId activityId) {
        this.myActivityId = activityId;
    }

    @Nullable
    public ActivityId getActivityId() {
        return this.myActivityId;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void lock() {
        this.isLocked = true;
    }

    @NlsContexts.Label
    @Nullable
    public String getLabel() {
        return this.accessChanges(() -> {
            for (Change each : this.myChanges) {
                if (!(each instanceof PutLabelChange)) continue;
                return ((PutLabelChange)each).getName();
            }
            return null;
        });
    }

    public int getLabelColor() {
        return this.accessChanges(() -> {
            for (Change each : this.myChanges) {
                if (!(each instanceof PutSystemLabelChange)) continue;
                return ((PutSystemLabelChange)each).getColor();
            }
            return -1;
        });
    }

    public void addChange(Change c) {
        LocalHistoryLog.LOG.assertTrue(!this.isLocked, (Object)"Changeset is already locked");
        this.accessChanges(() -> this.myChanges.add(c));
    }

    public List<Change> getChanges() {
        return this.accessChanges(() -> {
            if (this.isLocked) {
                return this.myChanges;
            }
            return Collections.unmodifiableList(new ArrayList<Change>(this.myChanges));
        });
    }

    public boolean isEmpty() {
        return this.accessChanges(() -> this.myChanges.isEmpty());
    }

    public boolean anyChangeMatches(@NotNull Predicate<Change> predicate) {
        if (predicate == null) {
            ChangeSet.$$$reportNull$$$0(0);
        }
        return this.accessChanges(() -> {
            for (Change c : this.myChanges) {
                if (!predicate.test(c)) continue;
                return true;
            }
            return false;
        });
    }

    public List<Content> getContentsToPurge() {
        return this.accessChanges(() -> {
            ArrayList<Content> result = new ArrayList<Content>();
            for (Change c : this.myChanges) {
                result.addAll(c.getContentsToPurge());
            }
            return result;
        });
    }

    public boolean isContentChangeOnly() {
        return this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof ContentChange);
    }

    public boolean isLabelOnly() {
        return this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof PutLabelChange);
    }

    public boolean isSystemLabelOnly() {
        return this.accessChanges(() -> this.myChanges.size() == 1 && this.getFirstChange() instanceof PutSystemLabelChange);
    }

    public Change getFirstChange() {
        return this.accessChanges(() -> this.myChanges.get(0));
    }

    public Change getLastChange() {
        return this.accessChanges(() -> this.myChanges.get(this.myChanges.size() - 1));
    }

    public List<String> getAffectedPaths() {
        return this.accessChanges(() -> {
            SmartList result = new SmartList();
            for (Change each : this.myChanges) {
                if (!(each instanceof StructuralChange)) continue;
                result.add(((StructuralChange)each).getPath());
            }
            return result;
        });
    }

    public String toString() {
        return this.accessChanges(() -> this.myChanges.toString());
    }

    public long getId() {
        return this.myId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSet change = (ChangeSet)o;
        return this.myId == change.myId;
    }

    public int hashCode() {
        return Long.hashCode(this.myId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        if (this.isLocked) {
            this.doAccept(v);
            return;
        }
        List<Change> list = this.myChanges;
        synchronized (list) {
            this.doAccept(v);
        }
    }

    private void doAccept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.begin(this);
        for (Change c : ContainerUtil.iterateBackward(this.myChanges)) {
            c.accept(v);
        }
        v.end(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T accessChanges(@NotNull Supplier<T> func) {
        if (func == null) {
            ChangeSet.$$$reportNull$$$0(1);
        }
        if (this.isLocked) {
            return func.get();
        }
        List<Change> list = this.myChanges;
        synchronized (list) {
            return func.get();
        }
    }

    private void accessChanges(@NotNull Runnable func) {
        if (func == null) {
            ChangeSet.$$$reportNull$$$0(2);
        }
        this.accessChanges(() -> {
            func.run();
            return null;
        });
    }

    @Nullable
    private static ActivityId readActivityId(@NotNull DataInput in) throws IOException {
        if (in == null) {
            ChangeSet.$$$reportNull$$$0(3);
        }
        String kind = DataStreamUtil.readStringOrNull(in);
        String provider = DataStreamUtil.readStringOrNull(in);
        if (kind == null || provider == null) {
            return null;
        }
        return new ActivityId(provider, kind);
    }

    private static void writeActivityId(@NotNull DataOutput out, @Nullable ActivityId activityId) throws IOException {
        if (out == null) {
            ChangeSet.$$$reportNull$$$0(4);
        }
        DataStreamUtil.writeStringOrNull(out, activityId != null ? activityId.getKind() : null);
        DataStreamUtil.writeStringOrNull(out, activityId != null ? activityId.getProviderId() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/core/changes/ChangeSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "anyChangeMatches";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accessChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readActivityId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeActivityId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

