/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.DataManager;
import com.intellij.ide.macro.AffectedModuleNamesMacro;
import com.intellij.ide.macro.ClipboardContentMacro;
import com.intellij.ide.macro.ColumnNumberMacro;
import com.intellij.ide.macro.CompilerContextMakeMacro;
import com.intellij.ide.macro.ContentRootMacro;
import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileDirNameMacro;
import com.intellij.ide.macro.FileDirPathFromParentMacro;
import com.intellij.ide.macro.FileDirRelativeToProjectRootMacro;
import com.intellij.ide.macro.FileDirRelativeToProjectRootMacro2;
import com.intellij.ide.macro.FileDirRelativeToSourcepathMacro;
import com.intellij.ide.macro.FileDirRelativeToSourcepathMacro2;
import com.intellij.ide.macro.FileEncodingMacro;
import com.intellij.ide.macro.FileExtMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutAllExtensions;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.ide.macro.FileParentDirMacro;
import com.intellij.ide.macro.FilePathMacro;
import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro;
import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro2;
import com.intellij.ide.macro.FilePathRelativeToSourcepathMacro;
import com.intellij.ide.macro.FilePathRelativeToSourcepathMacro2;
import com.intellij.ide.macro.FilePromptMacro;
import com.intellij.ide.macro.FileRelativeDirMacro;
import com.intellij.ide.macro.FileRelativeDirMacro2;
import com.intellij.ide.macro.FileRelativePathMacro;
import com.intellij.ide.macro.FileRelativePathMacro2;
import com.intellij.ide.macro.JdkPathMacro;
import com.intellij.ide.macro.LineNumberMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroPathConverter;
import com.intellij.ide.macro.ModuleFileDirMacro;
import com.intellij.ide.macro.ModuleFilePathMacro;
import com.intellij.ide.macro.ModuleNameMacro;
import com.intellij.ide.macro.ModulePathMacro;
import com.intellij.ide.macro.ModuleSdkPathMacro;
import com.intellij.ide.macro.OsNameMacro;
import com.intellij.ide.macro.OsUserMacro;
import com.intellij.ide.macro.PasswordMacro;
import com.intellij.ide.macro.PathListMacro;
import com.intellij.ide.macro.PathMacro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.PromptMacro;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.ide.macro.SecondQueueExpandMacro;
import com.intellij.ide.macro.SelectedTextMacro;
import com.intellij.ide.macro.SelectionEndColumnMacro;
import com.intellij.ide.macro.SelectionEndLineMacro;
import com.intellij.ide.macro.SelectionStartColumnMacro;
import com.intellij.ide.macro.SelectionStartLineMacro;
import com.intellij.ide.macro.SourcepathEntryMacro;
import com.intellij.ide.macro.SourcepathMacro;
import com.intellij.ide.macro.TempDirMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service
public final class MacroManager {
    private final List<Macro> predefinedMacros = new ArrayList<Macro>();
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\$.+\\$");
    public static final DataKey<MacroPathConverter> PATH_CONVERTER_KEY = DataKey.create((String)"MacroPathConverter");
    public static final DataKey<Path> CONTEXT_PATH = DataKey.create((String)"MacroContextPath");

    public static MacroManager getInstance() {
        return (MacroManager)ApplicationManager.getApplication().getService(MacroManager.class);
    }

    private MacroManager() {
        this.registerMacro(new SourcepathMacro());
        this.registerMacro(new FileDirMacro());
        this.registerMacro(new FileDirNameMacro());
        this.registerMacro(new FileParentDirMacro());
        this.registerMacro(new FileDirPathFromParentMacro());
        this.registerMacro(new FileExtMacro());
        this.registerMacro(new FileNameMacro());
        this.registerMacro(new FileNameWithoutExtension());
        this.registerMacro(new FileNameWithoutAllExtensions());
        this.registerMacro(new FilePathMacro());
        this.registerMacro(new UnixSeparatorsMacro());
        this.registerMacro(new FileEncodingMacro());
        this.registerMacro(new FileDirRelativeToProjectRootMacro());
        this.registerMacro(new FilePathRelativeToProjectRootMacro());
        this.registerMacro(new FileDirRelativeToSourcepathMacro());
        this.registerMacro(new FilePathRelativeToSourcepathMacro());
        this.registerMacro(new JdkPathMacro());
        this.registerMacro(new PromptMacro());
        this.registerMacro(new PasswordMacro());
        this.registerMacro(new FilePromptMacro());
        this.registerMacro(new SourcepathEntryMacro());
        this.registerMacro(new ProjectFileDirMacro());
        this.registerMacro(new ProjectNameMacro());
        this.registerMacro(new ProjectPathMacro());
        this.registerMacro(new ContentRootMacro());
        this.registerMacro(new ModuleFilePathMacro());
        this.registerMacro(new ModuleFileDirMacro());
        this.registerMacro(new ModuleNameMacro());
        this.registerMacro(new AffectedModuleNamesMacro());
        this.registerMacro(new CompilerContextMakeMacro());
        this.registerMacro(new ModulePathMacro());
        this.registerMacro(new ModuleSdkPathMacro());
        this.registerMacro(new FileRelativePathMacro());
        this.registerMacro(new FileRelativeDirMacro());
        this.registerMacro(new LineNumberMacro());
        this.registerMacro(new ColumnNumberMacro());
        this.registerMacro(new ClipboardContentMacro());
        this.registerMacro(new SelectedTextMacro());
        this.registerMacro(new SelectionStartLineMacro());
        this.registerMacro(new SelectionStartColumnMacro());
        this.registerMacro(new SelectionEndLineMacro());
        this.registerMacro(new SelectionEndColumnMacro());
        this.registerMacro(new OsNameMacro());
        this.registerMacro(new OsUserMacro());
        this.registerMacro(new TempDirMacro());
        if (File.separatorChar != '/') {
            this.registerMacro(new FileDirRelativeToProjectRootMacro2());
            this.registerMacro(new FilePathRelativeToProjectRootMacro2());
            this.registerMacro(new FileDirRelativeToSourcepathMacro2());
            this.registerMacro(new FilePathRelativeToSourcepathMacro2());
            this.registerMacro(new FileRelativeDirMacro2());
            this.registerMacro(new FileRelativePathMacro2());
        }
    }

    private void registerMacro(@NotNull Macro macro) {
        if (macro == null) {
            MacroManager.$$$reportNull$$$0(0);
        }
        this.predefinedMacros.add(macro);
    }

    @NotNull
    public @Unmodifiable Collection<Macro> getMacros() {
        List list = ContainerUtil.concat(this.predefinedMacros, (List)Macro.EP_NAME.getExtensionList());
        if (list == null) {
            MacroManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Deprecated
    public void cacheMacrosPreview(DataContext dataContext) {
        Logger.getInstance(MacroManager.class).error("This method not needed anymore");
    }

    public static DataContext getCorrectContext(DataContext dataContext) {
        if (PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext) != null) {
            return dataContext;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return dataContext;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            return dataContext;
        }
        VirtualFile[] files = editorManager.getSelectedFiles();
        if (files.length == 0) {
            return dataContext;
        }
        FileEditor fileEditor = editorManager.getSelectedEditor(files[0]);
        return fileEditor == null ? dataContext : DataManager.getInstance().getDataContext((Component)fileEditor.getComponent());
    }

    public static boolean containsMacros(@Nullable String str) {
        if (str == null) {
            return false;
        }
        return MACRO_PATTERN.matcher(str).find();
    }

    @Nullable
    public String expandMacrosInString(@Nullable String str, boolean firstQueueExpand, DataContext dataContext) throws Macro.ExecutionCancelledException {
        return this.expandMacrosInString(str, firstQueueExpand, dataContext, false);
    }

    @Nullable
    public String expandSilentMacros(@Nullable String str, boolean firstQueueExpand, DataContext dataContext) throws Macro.ExecutionCancelledException {
        return this.expandMacrosInString(str, firstQueueExpand, dataContext, true);
    }

    @Nullable
    public String expandMacrosInString(@Nullable String str, boolean firstQueueExpand, DataContext dataContext, boolean onlySilent) throws Macro.ExecutionCancelledException {
        @NotNull List macros = this.getMacros();
        if (onlySilent) {
            macros = ContainerUtil.map(macros, macro -> macro instanceof PromptingMacro ? new Macro.Silent((Macro)macro, "") : macro);
        }
        return MacroManager.expandMacroSet(str, firstQueueExpand, dataContext, macros);
    }

    @Nullable
    private static String expandMacroSet(@Nullable String str, boolean firstQueueExpand, DataContext dataContext, Collection<? extends Macro> macros) throws Macro.ExecutionCancelledException {
        if (str == null) {
            return null;
        }
        MacroPathConverter converter = (MacroPathConverter)dataContext.getData(PATH_CONVERTER_KEY);
        List list = ContainerUtil.filter(macros, macro -> !(macro instanceof SecondQueueExpandMacro) || firstQueueExpand);
        return MacroManager.expandMacros(str, list, (macro, occurence) -> {
            String expanded = macro.expandOccurence(dataContext, occurence);
            return MacroManager.convertPathIfNeeded(converter, macro, StringUtil.notNullize((String)expanded));
        });
    }

    private static String convertPathIfNeeded(@Nullable MacroPathConverter converter, @NotNull Macro macro, @NotNull String expandedValue) {
        if (macro == null) {
            MacroManager.$$$reportNull$$$0(2);
        }
        if (expandedValue == null) {
            MacroManager.$$$reportNull$$$0(3);
        }
        if (converter == null) {
            return expandedValue;
        }
        if (macro instanceof PathMacro) {
            return converter.convertPath(expandedValue);
        }
        if (macro instanceof PathListMacro) {
            return converter.convertPathList(expandedValue);
        }
        return expandedValue;
    }

    @NotNull
    public static String expandMacros(@NotNull String input, @NotNull Collection<Macro> macros, @NotNull MacroExpander expander) throws Macro.ExecutionCancelledException {
        if (input == null) {
            MacroManager.$$$reportNull$$$0(4);
        }
        if (macros == null) {
            MacroManager.$$$reportNull$$$0(5);
        }
        if (expander == null) {
            MacroManager.$$$reportNull$$$0(6);
        }
        StringBuilder builder = new StringBuilder(input);
        for (Macro macro : macros) {
            MacroManager.expandMacro(macro, expander, builder);
        }
        String string = builder.toString();
        if (string == null) {
            MacroManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void expandMacro(Macro macro, @NotNull MacroExpander expander, StringBuilder builder) throws Macro.ExecutionCancelledException {
        TextRange range;
        String value;
        if (expander == null) {
            MacroManager.$$$reportNull$$$0(8);
        }
        for (int offset = 0; offset >= 0 && offset < builder.length() && (range = macro.findOccurence(builder, offset)) != null; offset += value.length()) {
            String occurence = builder.substring(range.getStartOffset(), range.getEndOffset());
            value = StringUtil.notNullize((String)expander.expand(macro, occurence));
            builder.replace(range.getStartOffset(), range.getEndOffset(), value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/MacroManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macros";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expander";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/MacroManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacros";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerMacro";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertPathIfNeeded";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandMacros";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandMacro";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface MacroExpander {
        @Nullable
        public String expand(Macro var1, @NotNull String var2) throws Macro.ExecutionCancelledException;
    }
}

