/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils;

import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/markdown/utils/CodeFenceSyntaxHighlighterGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "<init>", "(Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.platform.markdown.utils"})
@ApiStatus.Internal
public final class CodeFenceSyntaxHighlighterGeneratingProvider
implements GeneratingProvider {
    @NotNull
    private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;

    public CodeFenceSyntaxHighlighterGeneratingProvider(@NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
        Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
        this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        HtmlChunk.Element element;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String languageCodeBlock = null;
        StringBuilder codeFenceRawContent = new StringBuilder();
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            ASTNode child = (ASTNode)iterator.next();
            IElementType iElementType = child.getType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.FENCE_LANG)) {
                languageCodeBlock = ((Object)StringsKt.trim((CharSequence)((Object)HtmlGenerator.Companion.leafText$default((HtmlGenerator.Companion)HtmlGenerator.Companion, (String)text, (ASTNode)child, (boolean)false, (int)4, null)).toString())).toString();
                iterator.next();
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                CharSequence textInNode = ASTUtilKt.getTextInNode((ASTNode)child, (CharSequence)text);
                codeFenceRawContent.append(HtmlGenerator.Companion.trimIndents(textInNode, 0));
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_END)) continue;
        }
        String string = codeFenceRawContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        HtmlChunk coloredContent = this.htmlSyntaxHighlighter.color(languageCodeBlock, string);
        HtmlChunk.Element it = HtmlChunk.tag((String)"code");
        boolean bl = false;
        if (languageCodeBlock == null) {
            element = it;
        } else {
            String[] stringArray = new String[]{" "};
            element = it.setClass("language-" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)languageCodeBlock, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null));
        }
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"let(...)");
        HtmlChunk.Element codeHtmlChunk = element;
        HtmlChunk.Element element2 = new HtmlBuilder().append(coloredContent).wrapWith(codeHtmlChunk).wrapWith(HtmlChunk.tag((String)"pre"));
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"wrapWith(...)");
        HtmlChunk.Element html = element2;
        String string2 = html.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        visitor.consumeHtml((CharSequence)string2);
    }
}

