/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils.doc.impl;

import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.markdown.utils.doc.impl.DocGeneratingProvidersKt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/markdown/utils/doc/impl/DocSanitizingTagGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "<init>", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.platform.markdown.utils"})
public final class DocSanitizingTagGeneratingProvider
implements GeneratingProvider {
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CharSequence nodeText = ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text);
        if (StringsKt.contentEquals((CharSequence)nodeText, (CharSequence)"</p>", (boolean)true)) {
            return;
        }
        Matcher matcher = DocMarkdownToHtmlConverter.INSTANCE.getTAG_PATTERN$intellij_platform_markdown_utils().matcher(nodeText);
        if (matcher.matches()) {
            String tagName = matcher.group(1);
            String replaceWith = (String)DocGeneratingProvidersKt.access$getTAG_REPLACE_MAP$p().get(tagName);
            if (replaceWith != null) {
                visitor.consumeHtml(nodeText.subSequence(0, matcher.start(1)));
                visitor.consumeHtml((CharSequence)replaceWith);
                visitor.consumeHtml(nodeText.subSequence(matcher.end(1), nodeText.length()));
                return;
            }
            if (DocMarkdownToHtmlConverter.INSTANCE.getACCEPTABLE_TAGS$intellij_platform_markdown_utils().contains(tagName)) {
                visitor.consumeHtml(nodeText);
                return;
            }
        }
        String string = StringUtil.escapeXmlEntities((String)((Object)nodeText).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        visitor.consumeHtml((CharSequence)string);
    }
}

