/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FileHistoryPersistence;
import com.intellij.filePrediction.features.history.FilePredictionNGramFeatures;
import com.intellij.internal.ml.ngram.NGramIncrementalModelRunner;
import com.intellij.internal.ml.ngram.NGramModelScorer;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManager;", "", "model", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "<init>", "(Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;)V", "saveFileHistoryAsync", "", "project", "Lcom/intellij/openapi/project/Project;", "onFileOpened", "fileUrl", "", "calcNGramFeatures", "Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "candidates", "", "calcNextFileProbability", "", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class FileHistoryManager {
    @NotNull
    private final NGramIncrementalModelRunner model;

    public FileHistoryManager(@NotNull NGramIncrementalModelRunner model) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.model = model;
    }

    public final void saveFileHistoryAsync(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileHistoryPersistence.INSTANCE.saveNGramsAsync(project, this.model);
    }

    public final void onFileOpened(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        this.model.learnNextToken(fileUrl);
    }

    @NotNull
    public final FilePredictionNGramFeatures calcNGramFeatures(@NotNull List<String> candidates) {
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Map result = new HashMap();
        NGramModelScorer scorer = this.model.createScorer();
        for (String candidate : candidates) {
            result.put(candidate, scorer.score(candidate));
        }
        return new FilePredictionNGramFeatures(result);
    }

    public final double calcNextFileProbability(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        NGramModelScorer scorer = this.model.createScorer();
        return scorer.score(fileUrl);
    }
}

