/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.session;

import com.intellij.platform.ml.feature.FeatureDeclaration;
import com.intellij.platform.ml.feature.FeatureValueType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u001a\u0010\u000e\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010J\u0018\u0010\u000e\u001a\u00020\u00052\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0012R,\u0010\u0004\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u0007*\b\u0012\u0004\u0012\u0002H\u00060\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/ml/session/CodeLikePrinter;", "", "<init>", "()V", "codeLikeType", "", "T", "", "Lcom/intellij/platform/ml/feature/FeatureValueType$Enum;", "getCodeLikeType", "(Lcom/intellij/platform/ml/feature/FeatureValueType$Enum;)Ljava/lang/String;", "makeCodeLikeString", "Lcom/intellij/platform/ml/feature/FeatureValueType;", "name", "printCodeLikeString", "featureDeclaration", "Lcom/intellij/platform/ml/feature/FeatureDeclaration;", "featureDeclarations", "", "intellij.platform.ml"})
final class CodeLikePrinter {
    private final <T extends Enum<?>> String getCodeLikeType(FeatureValueType.Enum<T> $this$codeLikeType) {
        String string = $this$codeLikeType.getEnumClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final <T> String makeCodeLikeString(FeatureValueType<T> $this$makeCodeLikeString, String name) {
        String string;
        FeatureValueType<T> featureValueType = $this$makeCodeLikeString;
        if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Boolean.INSTANCE)) {
            string = "FeatureDeclaration.boolean(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Class.INSTANCE)) {
            string = "FeatureDeclaration.aClass(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Double.INSTANCE)) {
            string = "FeatureDeclaration.double(\"" + name + "\")";
        } else if (featureValueType instanceof FeatureValueType.Enum) {
            string = "FeatureDeclaration.enum<" + this.getCodeLikeType((FeatureValueType.Enum)$this$makeCodeLikeString) + ">(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Float.INSTANCE)) {
            string = "FeatureDeclaration.float(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Int.INSTANCE)) {
            string = "FeatureDeclaration.int(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Long.INSTANCE)) {
            string = "FeatureDeclaration.long(\"" + name + "\")";
        } else if (featureValueType instanceof FeatureValueType.Nullable) {
            string = this.makeCodeLikeString(((FeatureValueType.Nullable)$this$makeCodeLikeString).getBaseType(), name) + ".nullable()";
        } else if (featureValueType instanceof FeatureValueType.Categorical) {
            String possibleValuesSerialized = CollectionsKt.joinToString$default((Iterable)((FeatureValueType.Categorical)$this$makeCodeLikeString).getPossibleValues(), (CharSequence)", ", null, null, (int)0, null, CodeLikePrinter::makeCodeLikeString$lambda$0, (int)30, null);
            string = "FeatureDeclaration.categorical(\"" + name + "\", setOf(" + possibleValuesSerialized + "))";
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return string;
    }

    @NotNull
    public final <T> String printCodeLikeString(@NotNull FeatureDeclaration<T> featureDeclaration) {
        Intrinsics.checkNotNullParameter(featureDeclaration, (String)"featureDeclaration");
        return this.makeCodeLikeString(featureDeclaration.getType(), featureDeclaration.getName());
    }

    @NotNull
    public final String printCodeLikeString(@NotNull Collection<? extends FeatureDeclaration<?>> featureDeclarations) {
        Intrinsics.checkNotNullParameter(featureDeclarations, (String)"featureDeclarations");
        return CollectionsKt.joinToString$default((Iterable)featureDeclarations, (CharSequence)", ", null, null, (int)0, null, arg_0 -> CodeLikePrinter.printCodeLikeString$lambda$0(this, arg_0), (int)30, null);
    }

    private static final CharSequence makeCodeLikeString$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    private static final CharSequence printCodeLikeString$lambda$0(CodeLikePrinter this$0, FeatureDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.printCodeLikeString(it);
    }
}

