/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.serialization.BeanBindingKt;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.BindingProducer;
import com.intellij.serialization.IonObjectSerializerKt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.NonDefaultConstructorInfo;
import com.intellij.serialization.ObjectIdReader;
import com.intellij.serialization.ObjectIdWriter;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.ReadError;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.WriteContext;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00032\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010 H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0013H\u0002J\u001a\u0010&\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010 H\u0016JI\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020#2\b\b\u0002\u0010)\u001a\u00020*2%\b\u0002\u0010+\u001a\u001f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(/\u0012\u0004\u0012\u00020*\u0018\u00010,H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/serialization/BeanBinding;", "Lcom/intellij/serialization/Binding;", "beanClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "constructor", "Ljava/lang/reflect/Constructor;", "bindings", "", "[Lcom/intellij/serialization/Binding;", "nameToBindingIndex", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "", "properties", "", "Lcom/intellij/serialization/MutableAccessor;", "propertyMapping", "Lkotlin/Lazy;", "Lcom/intellij/serialization/NonDefaultConstructorInfo;", "createCacheKey", "aClass", "type", "Ljava/lang/reflect/Type;", "init", "", "originalType", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "resolveConstructor", "serialize", "obj", "", "Lcom/intellij/serialization/WriteContext;", "createUsingCustomConstructor", "Lcom/intellij/serialization/ReadContext;", "hostObject", "getPropertyMappingIfDataClass", "deserialize", "readIntoObject", "instance", "checkId", "", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "fieldName", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nBeanBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeanBinding.kt\ncom/intellij/serialization/BeanBinding\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BeanBinding.kt\ncom/intellij/serialization/BeanBindingKt\n*L\n1#1,331:1\n1617#2,9:332\n1869#2:341\n1870#2:343\n1626#2:344\n1#3:342\n1#3:345\n309#4,9:346\n309#4,9:355\n*S KotlinDebug\n*F\n+ 1 BeanBinding.kt\ncom/intellij/serialization/BeanBinding\n*L\n220#1:332,9\n220#1:341\n220#1:343\n220#1:344\n220#1:342\n269#1:346,9\n151#1:355,9\n*E\n"})
public final class BeanBinding
implements Binding {
    @NotNull
    private final Class<?> beanClass;
    @Nullable
    private volatile Constructor<?> constructor;
    private Binding[] bindings;
    private Object2IntOpenHashMap<String> nameToBindingIndex;
    private List<? extends MutableAccessor> properties;
    @NotNull
    private final Lazy<NonDefaultConstructorInfo> propertyMapping;

    public BeanBinding(@NotNull Class<?> beanClass) {
        Intrinsics.checkNotNullParameter(beanClass, (String)"beanClass");
        this.beanClass = beanClass;
        this.propertyMapping = LazyKt.lazy(() -> BeanBinding.propertyMapping$lambda$0(this));
    }

    @Override
    @NotNull
    public Class<?> createCacheKey(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class<?> clazz = aClass;
        Intrinsics.checkNotNull(clazz);
        return clazz;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull BindingInitializationContext context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list2 = context.getPropertyCollector().collect(this.beanClass);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"collect(...)");
        this.properties = list = list2;
        Object2IntOpenHashMap nameToBindingIndex = new Object2IntOpenHashMap(list.size());
        nameToBindingIndex.defaultReturnValue(-1);
        int n = 0;
        int n2 = list.size();
        Binding[] bindingArray = new Binding[n2];
        BeanBinding beanBinding = this;
        while (n < n2) {
            int n3 = n++;
            MutableAccessor accessor = (MutableAccessor)list.get(n3);
            BindingProducer bindingProducer = context.getBindingProducer();
            Intrinsics.checkNotNull((Object)accessor);
            Binding binding = bindingProducer.getNestedBinding(accessor);
            nameToBindingIndex.put((Object)accessor.getName(), n3);
            bindingArray[n3] = binding;
        }
        beanBinding.bindings = bindingArray;
        this.nameToBindingIndex = nameToBindingIndex;
        if (context.isResolveConstructorOnInit()) {
            try {
                this.resolveConstructor();
            }
            catch (NoSuchMethodException e) {
                this.propertyMapping.getValue();
            }
        }
    }

    private final Constructor<?> resolveConstructor() throws SecurityException, NoSuchMethodException {
        Constructor<?> constructor = this.constructor;
        if (constructor != null) {
            return constructor;
        }
        constructor = this.beanClass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        this.constructor = constructor;
        Constructor<?> constructor2 = constructor;
        Intrinsics.checkNotNull(constructor2);
        return constructor2;
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        List<? extends MutableAccessor> list;
        Binding[] bindings;
        int alreadySerializedReference;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IonWriter writer = context.writer;
        ObjectIdWriter objectIdWriter = context.objectIdWriter;
        if (objectIdWriter != null && (alreadySerializedReference = objectIdWriter.getId(obj2)) != -1) {
            writer.writeInt((long)alreadySerializedReference);
            return;
        }
        writer.stepIn(IonType.STRUCT);
        if (objectIdWriter != null) {
            writer.setFieldName("@id");
            writer.writeInt((long)objectIdWriter.registerObject(obj2));
        }
        Binding[] bindingArray = this.bindings;
        if (this.bindings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
            bindingArray = bindings = null;
        }
        if ((list = this.properties) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
            list = null;
        }
        List<? extends MutableAccessor> properties = list;
        int n = bindings.length;
        for (int i = 0; i < n; ++i) {
            MutableAccessor property = properties.get(i);
            Binding binding = bindings[i];
            try {
                binding.serialize(obj2, property, context);
                continue;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SerializationException("Cannot serialize property (property=" + property + ", binding=" + binding + ", beanClass=" + this.beanClass.getName() + ")", (Throwable)e);
            }
        }
        writer.stepOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object createUsingCustomConstructor(ReadContext context, Object hostObject) {
        Object object;
        Object constructorInfo = this.propertyMapping.getValue();
        if (constructorInfo == null) {
            Object object2 = context.getConfiguration().resolvePropertyMapping;
            if ((object2 == null || (object2 = (NonDefaultConstructorInfo)object2.invoke(this.beanClass)) == null) && (object2 = this.getPropertyMappingIfDataClass()) == null) {
                throw new SerializationException("Please annotate non-default constructor with PropertyMapping (beanClass=" + this.beanClass.getName() + ")");
            }
            constructorInfo = object2;
        }
        List<String> names = constructorInfo.names;
        Object[] initArgs = new Object[names.size()];
        Ref.IntRef id = new Ref.IntRef();
        id.element = -1;
        BufferExposingByteArrayOutputStream out = BeanBinding.createUsingCustomConstructor$doReadAndMakeCopyIfSecondPassIsNeeded(this, names, context, (Function1<? super IonReader, Unit>)((Function1)arg_0 -> BeanBinding.createUsingCustomConstructor$lambda$2(context, id, names, this, initArgs, hostObject, arg_0)));
        Object instance = null;
        try {
            object = constructorInfo.constructor.newInstance(Arrays.copyOf(initArgs, initArgs.length));
        }
        catch (Exception e) {
            throw new SerializationException("Cannot create instance (beanClass=" + this.beanClass.getName() + ", initArgs=" + ArraysKt.joinToString$default((Object[])initArgs, null, null, null, (int)0, null, null, (int)63, null) + ")", (Throwable)e);
        }
        instance = object;
        Function1<Object, Object> function1 = context.getConfiguration().beanConstructed;
        if (function1 != null) {
            Function1<Object, Object> it = function1;
            boolean bl = false;
            Object object3 = instance;
            Intrinsics.checkNotNullExpressionValue(object3, (String)"element");
            instance = it.invoke(object3);
        }
        if (id.element != -1) {
            ObjectIdReader objectIdReader = context.getObjectIdReader();
            Object object4 = instance;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
            objectIdReader.registerObject(object4, id.element);
        }
        if (out != null) {
            object = (Closeable)BeanBindingKt.access$getStructReaderBuilder().build(out.getInternalBuffer(), 0, out.size());
            Throwable throwable = null;
            try {
                IonReader reader = (IonReader)object;
                boolean bl = false;
                reader.next();
                Object object5 = instance;
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"element");
                Intrinsics.checkNotNull((Object)reader);
                this.readIntoObject(object5, context.createSubContext(reader), false, (Function1<? super String, Boolean>)((Function1)arg_0 -> BeanBinding.createUsingCustomConstructor$lambda$4$0(names, arg_0)));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(object, (Throwable)throwable);
            }
        }
        Object object6 = instance;
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"element");
        return object6;
    }

    /*
     * WARNING - void declaration
     */
    private final NonDefaultConstructorInfo getPropertyMappingIfDataClass() {
        try {
            void $this$mapNotNullTo$iv$iv;
            KFunction kFunction;
            KFunction kFunction2 = kFunction = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(this.beanClass));
            if (kFunction2 == null) {
                return null;
            }
            KFunction kFunction3 = kFunction2;
            try {
                KCallablesJvm.setAccessible((KCallable)((KCallable)kFunction3), (boolean)true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Iterable $this$mapNotNull$iv = kFunction3.getParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KParameter it = (KParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List names = (List)destination$iv$iv;
            if (names.isEmpty()) {
                return null;
            }
            Constructor constructor = ReflectJvmMapping.getJavaConstructor((KFunction)kFunction3);
            Intrinsics.checkNotNull((Object)constructor);
            return new NonDefaultConstructorInfo(names, constructor);
        }
        catch (Exception e) {
            ObjectSerializerKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Object object;
        block10: {
            Object instance;
            block9: {
                Object obj2;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                IonReader reader = context.getReader();
                IonType ionType = reader.getType();
                if (ionType == IonType.INT) {
                    return context.getObjectIdReader().getObject(reader.intValue());
                }
                if (ionType != IonType.STRUCT) {
                    String stringValue = "";
                    if (ionType == IonType.SYMBOL || ionType == IonType.STRING) {
                        String string = reader.stringValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
                        stringValue = string;
                    }
                    throw new SerializationException("Expected STRUCT, but got " + ionType + " (stringValue=" + stringValue + ")");
                }
                if (this.propertyMapping.isInitialized()) {
                    return this.createUsingCustomConstructor(context, hostObject);
                }
                try {
                    obj2 = this.resolveConstructor().newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    return this.createUsingCustomConstructor(context, hostObject);
                }
                instance = obj2;
                Intrinsics.checkNotNull(instance);
                BeanBinding.readIntoObject$default(this, instance, context, false, null, 12, null);
                object = context.getConfiguration().beanConstructed;
                if (object == null) break block9;
                Function1<Object, Object> it = object;
                boolean bl = false;
                Object object2 = it.invoke(instance);
                object = object2;
                if (object2 != null) break block10;
            }
            object = instance;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void readIntoObject(Object instance, ReadContext context, boolean checkId, Function1<? super String, Boolean> filter) {
        IonReader reader;
        List<? extends MutableAccessor> list;
        Binding[] bindings;
        Object2IntOpenHashMap<String> object2IntOpenHashMap = this.nameToBindingIndex;
        if (object2IntOpenHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nameToBindingIndex");
            object2IntOpenHashMap = null;
        }
        Object2IntOpenHashMap<String> nameToBindingIndex = object2IntOpenHashMap;
        Binding[] bindingArray = this.bindings;
        if (this.bindings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
            bindingArray = bindings = null;
        }
        if ((list = this.properties) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
            list = null;
        }
        List<? extends MutableAccessor> accessors = list;
        IonReader reader$iv = reader = context.getReader();
        boolean $i$f$readStruct = false;
        reader$iv.stepIn();
        while (reader$iv.next() != null) {
            void type;
            String fieldName$iv;
            IonType type$iv;
            if (reader$iv.getFieldName() == null) {
                throw new IllegalStateException("No valid current value or the current value is not a field of a struct.");
            }
            IonType ionType = type$iv;
            String fieldName = fieldName$iv;
            boolean bl = false;
            if (type == IonType.INT && Intrinsics.areEqual((Object)fieldName, (Object)"@id")) {
                if (!checkId) continue;
                int id = reader.intValue();
                context.getObjectIdReader().registerObject(instance, id);
                continue;
            }
            if (filter != null && !((Boolean)filter.invoke((Object)fieldName)).booleanValue()) continue;
            int bindingIndex = nameToBindingIndex.getInt((Object)fieldName);
            if (bindingIndex == -1) {
                context.getErrors().unknownFields.add(new ReadError("Unknown field (fieldName=" + fieldName + ", beanClass=" + this.beanClass.getName() + ")", null, 2, null));
                continue;
            }
            Binding binding = bindings[bindingIndex];
            try {
                binding.deserialize(instance, accessors.get(bindingIndex), context);
            }
            catch (SerializationException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SerializationException("Cannot deserialize field value (field=" + fieldName + ", binding=" + binding + ", valueType=" + reader.getType() + ", beanClass=" + this.beanClass.getName() + ")", (Throwable)e);
            }
        }
        reader$iv.stepOut();
    }

    static /* synthetic */ void readIntoObject$default(BeanBinding beanBinding, Object object, ReadContext readContext, boolean bl, Function1 function1, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        beanBinding.readIntoObject(object, readContext, bl, (Function1<? super String, Boolean>)function1);
    }

    private static final NonDefaultConstructorInfo propertyMapping$lambda$0(BeanBinding this$0) {
        return BeanBindingKt.access$computeNonDefaultConstructorInfo(this$0.beanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BufferExposingByteArrayOutputStream createUsingCustomConstructor$doReadAndMakeCopyIfSecondPassIsNeeded(BeanBinding this$0, List<String> names, ReadContext $context, Function1<? super IonReader, Unit> body) {
        Binding[] bindingArray = this$0.bindings;
        if (this$0.bindings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
            bindingArray = null;
        }
        if (bindingArray.length > names.size()) {
            BufferExposingByteArrayOutputStream out = $context.allocateByteArrayOutputStream();
            Closeable closeable = (Closeable)IonObjectSerializerKt.getBinaryWriterBuilder().newWriter((OutputStream)out);
            Throwable throwable = null;
            try {
                IonWriter it = (IonWriter)closeable;
                boolean bl = false;
                it.writeValue($context.getReader());
                it = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = (Closeable)BeanBindingKt.access$getStructReaderBuilder().build(out.getInternalBuffer(), 0, out.size());
            throwable = null;
            try {
                IonReader reader = (IonReader)closeable;
                boolean bl = false;
                reader.next();
                Intrinsics.checkNotNull((Object)reader);
                body.invoke((Object)reader);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return out;
        }
        body.invoke((Object)$context.getReader());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createUsingCustomConstructor$lambda$2(ReadContext $context, Ref.IntRef $id, List $names, BeanBinding this$0, Object[] $initArgs, Object $hostObject, IonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        ReadContext subReadContext = $context.createSubContext(reader);
        IonReader reader$iv = reader;
        boolean $i$f$readStruct = false;
        reader$iv.stepIn();
        while (reader$iv.next() != null) {
            int bindingIndex;
            void type;
            String fieldName$iv;
            IonType type$iv;
            if (reader$iv.getFieldName() == null) {
                throw new IllegalStateException("No valid current value or the current value is not a field of a struct.");
            }
            IonType ionType = type$iv;
            String fieldName = fieldName$iv;
            boolean bl = false;
            if (type == IonType.NULL) continue;
            if (type == IonType.INT && Intrinsics.areEqual((Object)fieldName, (Object)"@id")) {
                $id.element = reader.intValue();
                continue;
            }
            int argIndex = $names.indexOf(fieldName);
            if (argIndex == -1) continue;
            Object2IntOpenHashMap<String> object2IntOpenHashMap = this$0.nameToBindingIndex;
            if (object2IntOpenHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nameToBindingIndex");
                object2IntOpenHashMap = null;
            }
            if ((bindingIndex = object2IntOpenHashMap.getInt((Object)fieldName)) == -1) {
                ObjectSerializerKt.getLOG().error("Cannot find binding (fieldName=" + fieldName + ", valueType=" + reader.getType() + ", beanClass=" + this$0.beanClass.getName());
                continue;
            }
            Binding[] bindingArray = this$0.bindings;
            if (this$0.bindings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bindings");
                bindingArray = null;
            }
            Binding binding = bindingArray[bindingIndex];
            try {
                $initArgs[argIndex] = binding.deserialize(subReadContext, $hostObject);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SerializationException("Cannot deserialize parameter value (fieldName=" + fieldName + ", binding=" + binding + ", valueType=" + reader.getType() + ", beanClass=" + this$0.beanClass.getName() + ")", (Throwable)e);
            }
        }
        reader$iv.stepOut();
        return Unit.INSTANCE;
    }

    private static final boolean createUsingCustomConstructor$lambda$4$0(List $names, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$names.contains(it);
    }
}

