/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.serialization.Binding;
import com.intellij.serialization.IonBindingProducer;
import com.intellij.serialization.IonObjectSerializerKt;
import com.intellij.serialization.ObjectIdReader;
import com.intellij.serialization.ObjectIdWriter;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.PropertyCollector;
import com.intellij.serialization.ReadConfiguration;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.ReadContextImpl;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.SerializationFilter;
import com.intellij.serialization.WriteConfiguration;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ParameterizedTypeImpl;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018JQ\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020!2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\"J,\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0006\u0010$\u001a\u00020\u000fJ*\u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J?\u0010(\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010\u0015\u001a\u00020!2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010,J3\u0010-\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010.\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00100J4\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001a02\"\u0004\b\u0000\u0010\u001a2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010\u0015\u001a\u00020!J\u001c\u00104\u001a\u00020/2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010\u0015\u001a\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00065"}, d2={"Lcom/intellij/serialization/IonObjectSerializer;", "", "<init>", "()V", "readerBuilder", "Lcom/amazon/ion/system/IonReaderBuilder;", "getReaderBuilder", "()Lcom/amazon/ion/system/IonReaderBuilder;", "propertyCollector", "Lcom/intellij/serialization/PropertyCollector;", "bindingProducer", "Lcom/intellij/serialization/IonBindingProducer;", "getBindingProducer$intellij_platform_objectSerializer", "()Lcom/intellij/serialization/IonBindingProducer;", "writeVersioned", "", "obj", "out", "Ljava/io/OutputStream;", "expectedVersion", "", "configuration", "Lcom/intellij/serialization/WriteConfiguration;", "originalType", "Ljava/lang/reflect/Type;", "readVersioned", "T", "objectClass", "Ljava/lang/Class;", "input", "Ljava/io/InputStream;", "inputName", "Ljava/nio/file/Path;", "Lcom/intellij/serialization/ReadConfiguration;", "(Ljava/lang/Class;Ljava/io/InputStream;Ljava/nio/file/Path;ILcom/intellij/serialization/ReadConfiguration;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "write", "clearBindingCache", "doWrite", "writer", "Lcom/amazon/ion/IonWriter;", "read", "reader", "Lcom/amazon/ion/IonReader;", "Lcom/intellij/serialization/ValueReader;", "(Ljava/lang/Class;Lcom/amazon/ion/IonReader;Lcom/intellij/serialization/ReadConfiguration;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "doRead", "context", "Lcom/intellij/serialization/ReadContext;", "(Ljava/lang/Class;Ljava/lang/reflect/Type;Lcom/intellij/serialization/ReadContext;)Ljava/lang/Object;", "readList", "", "itemClass", "createReadContext", "intellij.platform.objectSerializer"})
public final class IonObjectSerializer {
    @NotNull
    private final IonReaderBuilder readerBuilder;
    @NotNull
    private final PropertyCollector propertyCollector;
    @NotNull
    private final IonBindingProducer bindingProducer;

    public IonObjectSerializer() {
        IonReaderBuilder ionReaderBuilder = IonReaderBuilder.standard().immutable();
        Intrinsics.checkNotNullExpressionValue((Object)ionReaderBuilder, (String)"immutable(...)");
        this.readerBuilder = ionReaderBuilder;
        this.propertyCollector = new PropertyCollector((byte)(2 | 4));
        this.bindingProducer = new IonBindingProducer(this.propertyCollector);
    }

    @NotNull
    public final IonReaderBuilder getReaderBuilder() {
        return this.readerBuilder;
    }

    @NotNull
    public final IonBindingProducer getBindingProducer$intellij_platform_objectSerializer() {
        return this.bindingProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeVersioned(@NotNull Object obj2, @NotNull OutputStream out, int expectedVersion, @NotNull WriteConfiguration configuration, @Nullable Type originalType) throws IOException {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Closeable closeable = (Closeable)IonObjectSerializerKt.access$createIonWriterBuilder(configuration.binary, out);
        Throwable throwable = null;
        try {
            IonWriter writer = (IonWriter)closeable;
            boolean bl = false;
            writer.stepIn(IonType.STRUCT);
            writer.setFieldName("version");
            writer.writeInt((long)expectedVersion);
            writer.setFieldName("formatVersion");
            writer.writeInt(3L);
            writer.setFieldName("data");
            this.doWrite(obj2, writer, configuration, originalType);
            writer.stepOut();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeVersioned$default(IonObjectSerializer ionObjectSerializer, Object object, OutputStream outputStream, int n, WriteConfiguration writeConfiguration, Type type, int n2, Object object2) throws IOException {
        if ((n2 & 8) != 0) {
            writeConfiguration = ObjectSerializerKt.getDefaultWriteConfiguration();
        }
        if ((n2 & 0x10) != 0) {
            type = null;
        }
        ionObjectSerializer.writeVersioned(object, outputStream, n, writeConfiguration, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T readVersioned(@NotNull Class<T> objectClass, @NotNull InputStream input, @NotNull Path inputName, int expectedVersion, @NotNull ReadConfiguration configuration, @Nullable Type originalType) throws IOException {
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Closeable closeable = (Closeable)this.readerBuilder.build(input);
        Throwable throwable = null;
        try {
            IonReader reader = (IonReader)closeable;
            boolean bl = false;
            int isVersionChecked = 0;
            try {
                reader.next();
            }
            catch (IonException e) {
                ObjectSerializerKt.getLOG().debug((Throwable)e);
                T t = null;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return t;
            }
            reader.stepIn();
            block25: while (reader.next() != null) {
                String fieldName;
                block32: {
                    fieldName = reader.getFieldName();
                    if (fieldName == null) break block32;
                    int n = -1;
                    switch (fieldName.hashCode()) {
                        case 3076010: {
                            if (fieldName.equals("data")) {
                                n = 1;
                            }
                            break;
                        }
                        case 351608024: {
                            if (fieldName.equals("version")) {
                                n = 2;
                            }
                            break;
                        }
                        case 1736190177: {
                            if (fieldName.equals("formatVersion")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            int currentVersion = reader.intValue();
                            if (currentVersion != expectedVersion) {
                                IonObjectSerializer.readVersioned$lambda$0$logVersionMismatch(inputName, expectedVersion, objectClass, "App", currentVersion);
                                T t = null;
                                return t;
                            }
                            ++isVersionChecked;
                            continue block25;
                        }
                        case 3: {
                            int currentVersion = reader.intValue();
                            if (currentVersion != 3) {
                                IonObjectSerializer.readVersioned$lambda$0$logVersionMismatch(inputName, expectedVersion, objectClass, "Format", currentVersion);
                                T t = null;
                                return t;
                            }
                            ++isVersionChecked;
                            continue block25;
                        }
                        case 1: {
                            if (isVersionChecked != 2) {
                                T t = null;
                                return t;
                            }
                            Intrinsics.checkNotNull((Object)reader);
                            ReadContext context = this.createReadContext(reader, configuration);
                            T t = this.doRead(objectClass, originalType, context);
                            T t2 = t;
                            return t2;
                            finally {
                                context.getErrors().report(ObjectSerializerKt.getLOG());
                            }
                        }
                    }
                }
                ObjectSerializerKt.getLOG().warn("Unknown field: " + fieldName + " (file=" + inputName + ", expectedVersion=" + expectedVersion + ", objectClass=" + objectClass + ")");
            }
            reader.stepOut();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        T t = null;
        return t;
    }

    public static /* synthetic */ Object readVersioned$default(IonObjectSerializer ionObjectSerializer, Class clazz, InputStream inputStream, Path path, int n, ReadConfiguration readConfiguration, Type type, int n2, Object object) throws IOException {
        if ((n2 & 0x20) != 0) {
            type = null;
        }
        return ionObjectSerializer.readVersioned(clazz, inputStream, path, n, readConfiguration, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull Object obj2, @NotNull OutputStream out, @NotNull WriteConfiguration configuration, @Nullable Type originalType) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Closeable closeable = (Closeable)IonObjectSerializerKt.access$createIonWriterBuilder(configuration.binary, out);
        Throwable throwable = null;
        try {
            IonWriter writer = (IonWriter)closeable;
            boolean bl = false;
            this.doWrite(obj2, writer, configuration, originalType);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void write$default(IonObjectSerializer ionObjectSerializer, Object object, OutputStream outputStream, WriteConfiguration writeConfiguration, Type type, int n, Object object2) {
        if ((n & 4) != 0) {
            writeConfiguration = ObjectSerializerKt.getDefaultWriteConfiguration();
        }
        if ((n & 8) != 0) {
            type = null;
        }
        ionObjectSerializer.write(object, outputStream, writeConfiguration, type);
    }

    public final void clearBindingCache() {
        this.bindingProducer.clearBindingCache();
    }

    private final void doWrite(Object obj2, IonWriter writer, WriteConfiguration configuration, Type originalType) {
        Class<?> aClass = obj2.getClass();
        SerializationFilter serializationFilter = configuration.filter;
        if (serializationFilter == null) {
            serializationFilter = IonObjectSerializerKt.access$getDEFAULT_FILTER$p();
        }
        WriteContext writeContext = new WriteContext(writer, serializationFilter, new ObjectIdWriter(), configuration, this.bindingProducer);
        Type type = originalType;
        if (type == null) {
            type = aClass;
        }
        this.bindingProducer.getRootBinding(aClass, type).serialize(obj2, writeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T read(@NotNull Class<T> objectClass, @NotNull IonReader reader, @NotNull ReadConfiguration configuration, @Nullable Type originalType) {
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Closeable closeable = (Closeable)reader;
        Throwable throwable = null;
        try {
            T t;
            IonReader it = (IonReader)closeable;
            boolean bl = false;
            reader.next();
            ReadContext context = this.createReadContext(reader, configuration);
            try {
                T t2 = this.doRead(objectClass, originalType, context);
                context.getErrors().report(ObjectSerializerKt.getLOG());
                t = t2;
            }
            catch (Throwable throwable2) {
                try {
                    context.getErrors().report(ObjectSerializerKt.getLOG());
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            return t;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Object read$default(IonObjectSerializer ionObjectSerializer, Class clazz, IonReader ionReader, ReadConfiguration readConfiguration, Type type, int n, Object object) {
        if ((n & 8) != 0) {
            type = null;
        }
        return ionObjectSerializer.read(clazz, ionReader, readConfiguration, type);
    }

    private final <T> T doRead(Class<T> objectClass, Type originalType, ReadContext context) {
        IonType ionType = context.getReader().getType();
        switch (ionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ionType.ordinal()]) {
            case 1: {
                throw new SerializationException("root value is null");
            }
            case -1: {
                throw new SerializationException("empty input");
            }
        }
        Type type = originalType;
        if (type == null) {
            type = objectClass;
        }
        Binding binding = this.bindingProducer.getRootBinding(objectClass, type);
        return (T)binding.deserialize(context, null);
    }

    @NotNull
    public final <T> List<T> readList(@NotNull Class<T> itemClass, @NotNull IonReader reader, @NotNull ReadConfiguration configuration) {
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Type[] typeArray = new Type[]{itemClass};
        List list = this.read(List.class, reader, configuration, (Type)new ParameterizedTypeImpl((Type)((Object)List.class), typeArray));
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.serialization.IonObjectSerializer.readList>");
        return list;
    }

    private final ReadContext createReadContext(IonReader reader, ReadConfiguration configuration) {
        return new ReadContextImpl(reader, new ObjectIdReader(), this.bindingProducer, configuration);
    }

    private static final <T> void readVersioned$lambda$0$logVersionMismatch(Path $inputName, int $expectedVersion, Class<T> $objectClass, String prefix, int currentVersion) {
        ObjectSerializerKt.getLOG().info(prefix + " version mismatch (file=" + $inputName + ", currentVersion: " + currentVersion + ", expectedVersion=" + $expectedVersion + ", objectClass=" + $objectClass + ")");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IonType.values().length];
            try {
                nArray[IonType.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

