/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.WriteContext;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\b\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u0016\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/intellij/serialization/InterfacePropertyBinding;", "Lcom/intellij/serialization/Binding;", "allowedTypes", "", "Ljava/lang/Class;", "<init>", "([Ljava/lang/Class;)V", "[Ljava/lang/Class;", "serialize", "", "obj", "", "context", "Lcom/intellij/serialization/WriteContext;", "deserialize", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "component1", "()[Ljava/lang/Class;", "copy", "([Ljava/lang/Class;)Lcom/intellij/serialization/InterfacePropertyBinding;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nInterfacePropertyBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfacePropertyBinding.kt\ncom/intellij/serialization/InterfacePropertyBinding\n+ 2 Binding.kt\ncom/intellij/serialization/BindingKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,37:1\n39#2,14:38\n55#2,5:52\n61#2:59\n1401#3,2:57\n*S KotlinDebug\n*F\n+ 1 InterfacePropertyBinding.kt\ncom/intellij/serialization/InterfacePropertyBinding\n*L\n11#1:38,14\n23#1:52,5\n23#1:59\n28#1:57,2\n*E\n"})
public final class InterfacePropertyBinding
implements Binding {
    @NotNull
    private final Class<?>[] allowedTypes;

    public InterfacePropertyBinding(@NotNull Class<?>[] allowedTypes) {
        Intrinsics.checkNotNullParameter(allowedTypes, (String)"allowedTypes");
        this.allowedTypes = allowedTypes;
    }

    @NotNull
    public Void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new IllegalStateException("InterfacePropertyBinding cannot be used as root binding");
    }

    @Override
    @NotNull
    public Void deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new IllegalStateException("InterfacePropertyBinding cannot be used as root binding");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull WriteContext context) {
        void hostObject$iv;
        void accessor$iv;
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = hostObject;
        MutableAccessor mutableAccessor = property;
        WriteContext context$iv = context;
        boolean $i$f$write = false;
        Object value$iv = accessor$iv.readUnsafe((Object)hostObject$iv);
        if (!context$iv.filter.isSkipped(value$iv)) {
            IonWriter writer$iv = context$iv.writer;
            writer$iv.setFieldName(accessor$iv.getName());
            if (value$iv == null) {
                writer$iv.writeNull();
            } else {
                void value;
                Object object2 = value$iv;
                IonWriter $this$serialize_u24lambda_u240 = writer$iv;
                boolean bl = false;
                Class<?> valueClass = value.getClass();
                if (!ArraysKt.contains((Object[])this.allowedTypes, valueClass)) {
                    throw new SerializationException("Type " + valueClass + " is not allowed for field " + property.getName());
                }
                $this$serialize_u24lambda_u240.addTypeAnnotation(valueClass.getSimpleName());
                context.bindingProducer.getRootBinding(valueClass).serialize(value, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = hostObject;
        MutableAccessor mutableAccessor = property;
        ReadContext context$iv = context;
        boolean $i$f$read = false;
        if (context$iv.getReader().getType() == IonType.NULL) {
            property$iv.set((Object)hostObject$iv, null);
        } else {
            Class<?> clazz;
            void $this$deserialize_u24lambda_u240;
            IonReader ionReader = context$iv.getReader();
            void var21_9 = hostObject$iv;
            void var20_10 = property$iv;
            boolean bl = false;
            Class<?> beanClass = null;
            Iterator typeAnnotationIterator = $this$deserialize_u24lambda_u240.iterateTypeAnnotations();
            if (typeAnnotationIterator.hasNext()) {
                String simpleName;
                block6: {
                    simpleName = (String)typeAnnotationIterator.next();
                    Class<?>[] $this$firstOrNull$iv = this.allowedTypes;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> element$iv;
                        Class<?> it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)simpleName)) continue;
                        clazz = element$iv;
                        break block6;
                    }
                    clazz = null;
                }
                if (clazz == null) {
                    throw new SerializationException("Unknown class simple name: " + simpleName + " (allowedClasses=" + this.allowedTypes + ")");
                }
            } else {
                throw new SerializationException("Class simple name is not specified (allowedClasses=" + this.allowedTypes + ")");
            }
            beanClass = clazz;
            Object object2 = context.getBindingProducer().getRootBinding(beanClass).deserialize(context, hostObject);
            var20_10.set((Object)var21_9, object2);
        }
    }

    private final Class<?>[] component1() {
        return this.allowedTypes;
    }

    @NotNull
    public final InterfacePropertyBinding copy(@NotNull Class<?>[] allowedTypes) {
        Intrinsics.checkNotNullParameter(allowedTypes, (String)"allowedTypes");
        return new InterfacePropertyBinding(allowedTypes);
    }

    public static /* synthetic */ InterfacePropertyBinding copy$default(InterfacePropertyBinding interfacePropertyBinding, Class[] classArray, int n, Object object) {
        if ((n & 1) != 0) {
            classArray = interfacePropertyBinding.allowedTypes;
        }
        return interfacePropertyBinding.copy(classArray);
    }

    @NotNull
    public String toString() {
        return "InterfacePropertyBinding(allowedTypes=" + Arrays.toString(this.allowedTypes) + ")";
    }

    public int hashCode() {
        return Arrays.hashCode(this.allowedTypes);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InterfacePropertyBinding)) {
            return false;
        }
        InterfacePropertyBinding interfacePropertyBinding = (InterfacePropertyBinding)other;
        return Intrinsics.areEqual(this.allowedTypes, interfacePropertyBinding.allowedTypes);
    }
}

