/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.ArrayBinding;
import com.intellij.serialization.BeanBinding;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.BindingProducer;
import com.intellij.serialization.ByteArrayBinding;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.CollectionBinding;
import com.intellij.serialization.DateBinding;
import com.intellij.serialization.EnumBinding;
import com.intellij.serialization.FileBinding;
import com.intellij.serialization.Int2IntMapBinding;
import com.intellij.serialization.IntNumberAsObjectBinding;
import com.intellij.serialization.InterfacePropertyBinding;
import com.intellij.serialization.LongNumberAsObjectBinding;
import com.intellij.serialization.MapBinding;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PathBinding;
import com.intellij.serialization.PolymorphicBinding;
import com.intellij.serialization.PrimitiveBindingsKt;
import com.intellij.serialization.Property;
import com.intellij.serialization.PropertyAnnotationUtil;
import com.intellij.serialization.PropertyCollector;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.ShortNumberAsObjectBinding;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/serialization/IonBindingProducer;", "Lcom/intellij/serialization/BindingProducer;", "propertyCollector", "Lcom/intellij/serialization/PropertyCollector;", "<init>", "(Lcom/intellij/serialization/PropertyCollector;)V", "getPropertyCollector", "()Lcom/intellij/serialization/PropertyCollector;", "createRootBinding", "Lcom/intellij/serialization/Binding;", "aClass", "Ljava/lang/Class;", "type", "Ljava/lang/reflect/Type;", "getNestedBinding", "accessor", "Lcom/intellij/serialization/MutableAccessor;", "Companion", "intellij.platform.objectSerializer"})
public final class IonBindingProducer
extends BindingProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyCollector propertyCollector;
    @NotNull
    private static final IdentityHashMap<Class<?>, Function1<MutableAccessor, Binding>> classToNestedBindingFactory = new IdentityHashMap(32);
    @NotNull
    private static final IdentityHashMap<Class<?>, Function0<Binding>> classToRootBindingFactory = new IdentityHashMap(32);

    public IonBindingProducer(@NotNull PropertyCollector propertyCollector) {
        Intrinsics.checkNotNullParameter((Object)propertyCollector, (String)"propertyCollector");
        this.propertyCollector = propertyCollector;
    }

    @Override
    @NotNull
    public PropertyCollector getPropertyCollector() {
        return this.propertyCollector;
    }

    @Override
    @NotNull
    protected Binding createRootBinding(@Nullable Class<?> aClass, @NotNull Type type) {
        Binding binding;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Function0<Binding> customFactory = classToRootBindingFactory.get(aClass);
        if (customFactory != null) {
            return (Binding)customFactory.invoke();
        }
        if (aClass == null) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type type2 = genericArrayType.getGenericComponentType();
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.reflect.TypeVariable<*>");
            TypeVariable typeVariable = (TypeVariable)type2;
            Type type3 = typeVariable.getBounds()[0];
            Intrinsics.checkNotNull((Object)type3, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            return new ArrayBinding((Class)type3, (BindingInitializationContext)this);
        }
        if (Collection.class.isAssignableFrom(aClass) && type instanceof ParameterizedType) {
            binding = new CollectionBinding((ParameterizedType)type, (BindingInitializationContext)this);
        } else if (Map.class.isAssignableFrom(aClass)) {
            if (Int2IntMap.class.isAssignableFrom(aClass)) {
                binding = new Int2IntMapBinding();
            } else {
                Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                Type type4 = typeArguments[0];
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"get(...)");
                Type type5 = typeArguments[1];
                Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"get(...)");
                binding = new MapBinding(type4, type5, this);
            }
        } else if (aClass.isArray()) {
            Class<?> clazz = aClass.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getComponentType(...)");
            binding = new ArrayBinding(clazz, (BindingInitializationContext)this);
        } else if (aClass.isEnum()) {
            binding = new EnumBinding(aClass);
        } else if (aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers()) || Intrinsics.areEqual(aClass, Object.class)) {
            binding = new PolymorphicBinding(aClass);
        } else if (Number.class.isAssignableFrom(aClass)) {
            binding = new IntNumberAsObjectBinding();
        } else {
            if (Intrinsics.areEqual(aClass, Class.class) || Proxy.class.isAssignableFrom(aClass)) {
                throw new SerializationException(aClass + " class is not supported");
            }
            binding = new BeanBinding(aClass);
        }
        return binding;
    }

    @Override
    @NotNull
    public Binding getNestedBinding(@NotNull MutableAccessor accessor) {
        Binding binding;
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Type type = accessor.getGenericType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getGenericType(...)");
        Type type2 = type;
        boolean isGenericArray = type2 instanceof GenericArrayType;
        if (isGenericArray) {
            return this.getRootBinding(null, type2);
        }
        Class clazz = ClassUtil.typeToClass((Type)type2);
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"typeToClass(...)");
        Class aClass = clazz;
        Function1<MutableAccessor, Binding> function1 = classToNestedBindingFactory.get(aClass);
        if (function1 != null) {
            Function1<MutableAccessor, Binding> it = function1;
            boolean bl = false;
            return (Binding)it.invoke((Object)accessor);
        }
        if (aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers()) || Intrinsics.areEqual((Object)aClass, Object.class)) {
            Property annotation = (Property)accessor.getAnnotation(Property.class);
            if (annotation == null) {
                return this.getRootBinding(aClass, type2);
            }
            Class<?>[] classArray = PropertyAnnotationUtil.getAllowedClass(annotation);
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getAllowedClass(...)");
            Class<?>[] allowedTypes = classArray;
            if (allowedTypes.length == 0) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"accessor", (Object)accessor)};
                throw new SerializationException("Allowed types list is empty", (Map)MapsKt.linkedMapOf((Pair[])pairArray));
            }
            binding = new InterfacePropertyBinding(allowedTypes);
        } else {
            binding = this.getRootBinding(aClass, type2);
        }
        return binding;
    }

    private static final Binding _init_$lambda$0() {
        return new FileBinding();
    }

    private static final Binding _init_$lambda$1() {
        return new PathBinding();
    }

    private static final Binding _init_$lambda$2() {
        return new DateBinding();
    }

    private static final Binding _init_$lambda$3() {
        return new ByteArrayBinding();
    }

    private static final Binding _init_$lambda$4() {
        return new ShortNumberAsObjectBinding();
    }

    private static final Binding _init_$lambda$5() {
        return new IntNumberAsObjectBinding();
    }

    private static final Binding _init_$lambda$6() {
        return new LongNumberAsObjectBinding();
    }

    private static final Binding _init_$lambda$7(Function0 $factory, MutableAccessor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Binding)$factory.invoke();
    }

    static {
        classToRootBindingFactory.put(File.class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$0));
        classToRootBindingFactory.put(Path.class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$1));
        classToRootBindingFactory.put(Date.class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$2));
        classToRootBindingFactory.put(byte[].class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$3));
        classToRootBindingFactory.put(Short.class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$4));
        classToRootBindingFactory.put(Integer.class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$5));
        classToRootBindingFactory.put(Long.class, (Function0<Binding>)((Function0)IonBindingProducer::_init_$lambda$6));
        PrimitiveBindingsKt.registerPrimitiveBindings((Map)classToRootBindingFactory, (Map)classToNestedBindingFactory);
        for (Map.Entry entry : ((Map)classToRootBindingFactory).entrySet()) {
            Class key = (Class)entry.getKey();
            Function0 factory = (Function0)entry.getValue();
            classToNestedBindingFactory.put(key, (Function1<MutableAccessor, Binding>)((Function1)arg_0 -> IonBindingProducer._init_$lambda$7(factory, arg_0)));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R=\u0010\u0004\u001a1\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012#\u0012!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000fj\u0002`\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/serialization/IonBindingProducer$Companion;", "", "<init>", "()V", "classToNestedBindingFactory", "Ljava/util/IdentityHashMap;", "Ljava/lang/Class;", "Lkotlin/Function1;", "Lcom/intellij/serialization/MutableAccessor;", "Lkotlin/ParameterName;", "name", "accessor", "Lcom/intellij/serialization/Binding;", "Lcom/intellij/serialization/NestedBindingFactory;", "classToRootBindingFactory", "Lkotlin/Function0;", "Lcom/intellij/serialization/RootBindingFactory;", "intellij.platform.objectSerializer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

