/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.IonBindingProducerKt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.StringBinding;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0016H\u0016J\u001a\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0016J2\u0010\u0017\u001a\u00020\u000e2\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00192\u0006\u0010\u0005\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J,\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/serialization/MapBinding;", "Lcom/intellij/serialization/Binding;", "keyType", "Ljava/lang/reflect/Type;", "valueType", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "<init>", "(Ljava/lang/reflect/Type;Ljava/lang/reflect/Type;Lcom/intellij/serialization/BindingInitializationContext;)V", "keyBinding", "valueBinding", "isKeyComparable", "", "serialize", "", "obj", "", "Lcom/intellij/serialization/WriteContext;", "deserialize", "hostObject", "property", "Lcom/intellij/serialization/MutableAccessor;", "Lcom/intellij/serialization/ReadContext;", "readInto", "result", "", "read", "type", "Lcom/amazon/ion/IonType;", "binding", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nMapBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapBinding.kt\ncom/intellij/serialization/MapBinding\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,132:1\n221#2,2:133\n*S KotlinDebug\n*F\n+ 1 MapBinding.kt\ncom/intellij/serialization/MapBinding\n*L\n69#1:133,2\n*E\n"})
public final class MapBinding
implements Binding {
    @NotNull
    private final Binding keyBinding;
    @NotNull
    private final Binding valueBinding;
    private final boolean isKeyComparable;

    public MapBinding(@NotNull Type keyType, @NotNull Type valueType, @NotNull BindingInitializationContext context) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.keyBinding = IonBindingProducerKt.createElementBindingByType(keyType, context);
        this.valueBinding = IonBindingProducerKt.createElementBindingByType(valueType, context);
        this.isKeyComparable = Comparable.class.isAssignableFrom(ClassUtil.typeToClass((Type)keyType));
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map map = (Map)obj2;
        IonWriter writer = context.writer;
        if (context.filter.getSkipEmptyMap() && map.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        boolean isStringKey = this.keyBinding instanceof StringBinding;
        writer.stepIn(isStringKey ? IonType.STRUCT : IonType.LIST);
        if (context.configuration.orderMapEntriesByKeys && this.isKeyComparable && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)map.keySet());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toObjectArray(...)");
            Object[] keys = objectArray;
            Arrays.sort(keys, MapBinding::serialize$lambda$0);
            for (Object key : keys) {
                MapBinding.serialize$writeEntry(writer, this, context, key, map.get(key), isStringKey);
            }
        } else {
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                MapBinding.serialize$writeEntry(writer, this, context, key, value, isStringKey);
            }
        }
        writer.stepOut();
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getReader().getType() == IonType.NULL) {
            property.set(hostObject, null);
            return;
        }
        context.checkCancelled();
        Map result = (Map)property.readUnsafe(hostObject);
        if (result != null && ClassUtil.isMutableMap((Map)result)) {
            TypeIntrinsics.asMutableMap((Object)result).clear();
        } else {
            result = new HashMap();
            property.set(hostObject, (Object)result);
        }
        this.readInto(TypeIntrinsics.asMutableMap((Object)result), context, hostObject);
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HashMap result = new HashMap();
        this.readInto(result, context, hostObject);
        return result;
    }

    private final void readInto(Map<Object, Object> result, ReadContext context, Object hostObject) {
        IonReader reader = context.getReader();
        if (reader.getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(context.getReader().intValue() == 0);
            return;
        }
        boolean isStringKeys = reader.getType() == IonType.STRUCT;
        reader.stepIn();
        while (true) {
            Object object;
            if (isStringKeys) {
                IonType type;
                if (reader.next() == null) break;
                String key = reader.getFieldName();
                Object value = this.read(type, this.valueBinding, context, hostObject);
                object = result.put(key, value);
                continue;
            }
            IonType ionType = reader.next();
            if (ionType == null) break;
            Object key = this.read(ionType, this.keyBinding, context, hostObject);
            IonType ionType2 = reader.next();
            if (ionType2 == null) break;
            Object value = this.read(ionType2, this.valueBinding, context, hostObject);
            object = result.put(key, value);
        }
        reader.stepOut();
    }

    private final Object read(IonType type, Binding binding, ReadContext context, Object hostObject) {
        return WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1 ? null : binding.deserialize(context, hostObject);
    }

    private static final void serialize$writeEntry(IonWriter writer, MapBinding this$0, WriteContext $context, Object key, Object value, boolean isStringKey) {
        if (isStringKey) {
            if (key == null) {
                throw new SerializationException("null string keys not supported");
            }
            writer.setFieldName((String)key);
        } else if (key == null) {
            writer.writeNull();
        } else {
            this$0.keyBinding.serialize(key, $context);
        }
        if (value == null) {
            writer.writeNull();
        } else {
            this$0.valueBinding.serialize(value, $context);
        }
    }

    private static final int serialize$lambda$0(Object a, Object b) {
        return a == null ? -1 : (b == null ? 1 : ((Comparable)a).compareTo((Comparable)b));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IonType.values().length];
            try {
                nArray[IonType.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

