/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0012\u0010\u0017\u001a\u00020\u00072\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\u001c\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0006J\u001e\u0010\u001b\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0006H$J\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/serialization/BindingProducer;", "Lcom/intellij/serialization/BindingInitializationContext;", "<init>", "()V", "cache", "", "Ljava/lang/reflect/Type;", "Lcom/intellij/serialization/Binding;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "bindingCount", "", "getBindingCount$intellij_platform_objectSerializer", "()I", "bindingProducer", "getBindingProducer", "()Lcom/intellij/serialization/BindingProducer;", "isResolveConstructorOnInit", "", "()Z", "getNestedBinding", "accessor", "Lcom/intellij/serialization/MutableAccessor;", "getRootBinding", "aClass", "Ljava/lang/Class;", "type", "createRootBinding", "clearBindingCache", "", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nBindingProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BindingProducer.kt\ncom/intellij/serialization/BindingProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public abstract class BindingProducer
implements BindingInitializationContext {
    @NotNull
    private final Map<Type, Binding> cache;
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    private final boolean isResolveConstructorOnInit;

    public BindingProducer() {
        Map map = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)((HashingStrategy)new HashingStrategy<Type>(){

            public boolean equals(Type o1, Type o2) {
                if (o1 instanceof ParameterizedType && o2 instanceof ParameterizedType) {
                    return o1 == o2 || Arrays.equals(((ParameterizedType)o1).getActualTypeArguments(), ((ParameterizedType)o2).getActualTypeArguments()) && Intrinsics.areEqual((Object)((ParameterizedType)o1).getRawType(), (Object)((ParameterizedType)o2).getRawType());
                }
                return Intrinsics.areEqual((Object)o1, (Object)o2);
            }

            public int hashCode(Type o) {
                Type type = o;
                return type instanceof ParameterizedType ? 31 * ((ParameterizedType)o).getRawType().hashCode() + Arrays.hashCode(((ParameterizedType)o).getActualTypeArguments()) : (type == null ? 0 : o.hashCode());
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createCustomHashingStrategyMap(...)");
        this.cache = map;
        this.cacheLock = new ReentrantReadWriteLock();
        this.isResolveConstructorOnInit = Boolean.getBoolean("idea.serializer.resolve.ctor.on.init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final int getBindingCount$intellij_platform_objectSerializer() {
        int n;
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.cache.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    @Override
    @NotNull
    public BindingProducer getBindingProducer() {
        return this;
    }

    @Override
    public boolean isResolveConstructorOnInit() {
        return this.isResolveConstructorOnInit;
    }

    @NotNull
    public abstract Binding getNestedBinding(@NotNull MutableAccessor var1);

    @NotNull
    public final Binding getRootBinding(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        return this.getRootBinding(aClass, aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Binding getRootBinding(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Binding binding = BindingProducer.getRootBinding$getByTypeOrByClass(this, type, aClass);
            if (binding != null) {
                Binding it = binding;
                boolean bl2 = false;
                Binding binding2 = it;
                return binding2;
            }
            Object var5_5 = null;
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Binding binding = BindingProducer.getRootBinding$getByTypeOrByClass(this, type, aClass);
            if (binding != null) {
                Binding it = binding;
                boolean bl3 = false;
                Binding binding3 = it;
                return binding3;
            }
            Binding binding4 = this.createRootBinding(aClass, type);
            this.cache.put(binding4.createCacheKey(aClass, type), binding4);
            try {
                binding4.init(type, this);
            }
            catch (Throwable e) {
                this.cache.remove(type);
                throw e;
            }
            Binding binding5 = binding4;
            return binding5;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @NotNull
    protected abstract Binding createRootBinding(@Nullable Class<?> var1, @NotNull Type var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBindingCache() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.cache.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private static final Binding getRootBinding$getByTypeOrByClass(BindingProducer this$0, Type $type, Class<?> $aClass) {
        Binding result = this$0.cache.get($type);
        if (result == null && $aClass != $type && $aClass != null) {
            result = this$0.cache.get($aClass);
        }
        return result;
    }
}

