/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.serialization.BindingProducer;
import com.intellij.serialization.ObjectIdReader;
import com.intellij.serialization.ReadConfiguration;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.ReadErrors;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0014\u0010 \u001a\u00020\u00002\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\r\u0010!\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J5\u0010%\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0014\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0083\u0004J\n\u0010*\u001a\u00020+H\u00d6\u0081\u0004J\n\u0010,\u001a\u00020-H\u00d6\u0081\u0004R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lcom/intellij/serialization/ReadContextImpl;", "Lcom/intellij/serialization/ReadContext;", "reader", "Lcom/amazon/ion/IonReader;", "Lcom/intellij/serialization/ValueReader;", "objectIdReader", "Lcom/intellij/serialization/ObjectIdReader;", "bindingProducer", "Lcom/intellij/serialization/BindingProducer;", "configuration", "Lcom/intellij/serialization/ReadConfiguration;", "<init>", "(Lcom/amazon/ion/IonReader;Lcom/intellij/serialization/ObjectIdReader;Lcom/intellij/serialization/BindingProducer;Lcom/intellij/serialization/ReadConfiguration;)V", "getReader", "()Lcom/amazon/ion/IonReader;", "getObjectIdReader", "()Lcom/intellij/serialization/ObjectIdReader;", "getBindingProducer", "()Lcom/intellij/serialization/BindingProducer;", "getConfiguration", "()Lcom/intellij/serialization/ReadConfiguration;", "byteArrayOutputStream", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "job", "Lkotlinx/coroutines/Job;", "checkCancelled", "", "errors", "Lcom/intellij/serialization/ReadErrors;", "getErrors", "()Lcom/intellij/serialization/ReadErrors;", "allocateByteArrayOutputStream", "createSubContext", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.objectSerializer"})
final class ReadContextImpl
implements ReadContext {
    @NotNull
    private final IonReader reader;
    @NotNull
    private final ObjectIdReader objectIdReader;
    @NotNull
    private final BindingProducer bindingProducer;
    @NotNull
    private final ReadConfiguration configuration;
    @Nullable
    private BufferExposingByteArrayOutputStream byteArrayOutputStream;
    @Nullable
    private final Job job;
    @NotNull
    private final ReadErrors errors;

    public ReadContextImpl(@NotNull IonReader reader, @NotNull ObjectIdReader objectIdReader, @NotNull BindingProducer bindingProducer, @NotNull ReadConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)objectIdReader, (String)"objectIdReader");
        Intrinsics.checkNotNullParameter((Object)bindingProducer, (String)"bindingProducer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.reader = reader;
        this.objectIdReader = objectIdReader;
        this.bindingProducer = bindingProducer;
        this.configuration = configuration;
        this.job = (Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key);
        this.errors = new ReadErrors(null, null, 3, null);
    }

    @Override
    @NotNull
    public IonReader getReader() {
        return this.reader;
    }

    @Override
    @NotNull
    public ObjectIdReader getObjectIdReader() {
        return this.objectIdReader;
    }

    @Override
    @NotNull
    public BindingProducer getBindingProducer() {
        return this.bindingProducer;
    }

    @Override
    @NotNull
    public ReadConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void checkCancelled() {
        block0: {
            Job job = this.job;
            if (job == null) break block0;
            JobKt.ensureActive((Job)job);
        }
    }

    @Override
    @NotNull
    public ReadErrors getErrors() {
        return this.errors;
    }

    @Override
    @NotNull
    public BufferExposingByteArrayOutputStream allocateByteArrayOutputStream() {
        BufferExposingByteArrayOutputStream result = this.byteArrayOutputStream;
        if (result == null) {
            this.byteArrayOutputStream = result = new BufferExposingByteArrayOutputStream(8192);
        } else {
            result.reset();
        }
        return result;
    }

    @Override
    @NotNull
    public ReadContextImpl createSubContext(@NotNull IonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return new ReadContextImpl(reader, this.getObjectIdReader(), this.getBindingProducer(), this.getConfiguration());
    }

    @NotNull
    public final IonReader component1() {
        return this.reader;
    }

    @NotNull
    public final ObjectIdReader component2() {
        return this.objectIdReader;
    }

    @NotNull
    public final BindingProducer component3() {
        return this.bindingProducer;
    }

    @NotNull
    public final ReadConfiguration component4() {
        return this.configuration;
    }

    @NotNull
    public final ReadContextImpl copy(@NotNull IonReader reader, @NotNull ObjectIdReader objectIdReader, @NotNull BindingProducer bindingProducer, @NotNull ReadConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)objectIdReader, (String)"objectIdReader");
        Intrinsics.checkNotNullParameter((Object)bindingProducer, (String)"bindingProducer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return new ReadContextImpl(reader, objectIdReader, bindingProducer, configuration);
    }

    public static /* synthetic */ ReadContextImpl copy$default(ReadContextImpl readContextImpl, IonReader ionReader, ObjectIdReader objectIdReader, BindingProducer bindingProducer, ReadConfiguration readConfiguration, int n, Object object) {
        if ((n & 1) != 0) {
            ionReader = readContextImpl.reader;
        }
        if ((n & 2) != 0) {
            objectIdReader = readContextImpl.objectIdReader;
        }
        if ((n & 4) != 0) {
            bindingProducer = readContextImpl.bindingProducer;
        }
        if ((n & 8) != 0) {
            readConfiguration = readContextImpl.configuration;
        }
        return readContextImpl.copy(ionReader, objectIdReader, bindingProducer, readConfiguration);
    }

    @NotNull
    public String toString() {
        return "ReadContextImpl(reader=" + this.reader + ", objectIdReader=" + this.objectIdReader + ", bindingProducer=" + this.bindingProducer + ", configuration=" + this.configuration + ")";
    }

    public int hashCode() {
        int result = this.reader.hashCode();
        result = result * 31 + this.objectIdReader.hashCode();
        result = result * 31 + this.bindingProducer.hashCode();
        result = result * 31 + this.configuration.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReadContextImpl)) {
            return false;
        }
        ReadContextImpl readContextImpl = (ReadContextImpl)other;
        if (!Intrinsics.areEqual((Object)this.reader, (Object)readContextImpl.reader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.objectIdReader, (Object)readContextImpl.objectIdReader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bindingProducer, (Object)readContextImpl.bindingProducer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.configuration, (Object)readContextImpl.configuration);
    }
}

