// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.plugins.parser.impl

object PluginXmlConst {
  // todo root element is not checked (<idea-plugin>)
  const val PLUGIN_PACKAGE_ATTR: String = "package"
  const val PLUGIN_IMPLEMENTATION_DETAIL_ATTR: String = "implementation-detail"
  const val PLUGIN_URL_ATTR: String = "url"
  const val PLUGIN_USE_IDEA_CLASSLOADER_ATTR: String = "use-idea-classloader"
  const val PLUGIN_REQUIRE_RESTART_ATTR: String = "require-restart"
  const val PLUGIN_ALLOW_BUNDLED_UPDATE_ATTR: String = "allow-bundled-update"
  const val PLUGIN_DEPENDENT_ON_CORE_ATTR: String = "dependent-on-core"
  const val PLUGIN_IS_SEPARATE_JAR_ATTR: String = "separate-jar"
  const val PLUGIN_VERSION_ATTR: String = "version"
  const val CONTENT_MODULE_VISIBILITY_ATTR: String = "visibility"
  const val CONTENT_MODULE_VISIBILITY_PRIVATE_VALUE: String = "private"
  const val CONTENT_MODULE_VISIBILITY_INTERNAL_VALUE: String = "internal"
  const val CONTENT_MODULE_VISIBILITY_PUBLIC_VALUE: String = "public"

  const val ID_ELEM: String = "id"
  const val NAME_ELEM: String = "name"
  const val VERSION_ELEM: String = "version"

  const val PRODUCT_DESCRIPTOR_ELEM: String = "product-descriptor"
  const val PRODUCT_DESCRIPTOR_CODE_ATTR: String = "code"
  const val PRODUCT_DESCRIPTOR_RELEASE_DATE_ATTR: String = "release-date"
  const val PRODUCT_DESCRIPTOR_RELEASE_DATE_PLACEHOLDER_VALUE: String = "__DATE__"
  const val PRODUCT_DESCRIPTOR_RELEASE_VERSION_ATTR: String = "release-version"
  const val PRODUCT_DESCRIPTOR_OPTIONAL_ATTR: String = "optional"

  const val IDEA_VERSION_ELEM: String = "idea-version"
  const val IDEA_VERSION_SINCE_ATTR: String = "since-build"
  const val IDEA_VERSION_UNTIL_ATTR: String = "until-build"
  const val IDEA_VERSION_STRICT_UNTIL_ATTR: String = "strict-until-build"

  const val VENDOR_ELEM: String = "vendor"
  const val VENDOR_URL_ATTR: String = "url"
  const val VENDOR_EMAIL_ATTR: String = "email"

  const val CATEGORY_ELEM: String = "category"
  const val DESCRIPTION_ELEM: String = "description"
  const val CHANGE_NOTES_ELEM: String = "change-notes"

  const val RESOURCE_BUNDLE_ELEM: String = "resource-bundle"
  const val HELPSET_ELEM: String = "helpset"
  const val LOCALE_ELEM: String = "locale"

  const val MODULE_ELEM: String = "module"
  const val MODULE_VALUE_ATTR: String = "value"

  const val CONTENT_ELEM: String = "content"
  const val CONTENT_NAMESPACE_ATTR: String = "namespace"

  const val CONTENT_MODULE_ELEM: String = "module"
  const val CONTENT_MODULE_NAME_ATTR: String = "name"
  const val CONTENT_MODULE_LOADING_ATTR: String = "loading"
  const val CONTENT_MODULE_LOADING_OPTIONAL_VALUE: String = "optional"
  const val CONTENT_MODULE_LOADING_REQUIRED_VALUE: String = "required"
  const val CONTENT_MODULE_LOADING_EMBEDDED_VALUE: String = "embedded"
  const val CONTENT_MODULE_LOADING_ON_DEMAND_VALUE: String = "on-demand"
  const val CONTENT_MODULE_REQUIRED_IF_AVAILABLE_ATTR: String = "required-if-available"

  const val DEPENDS_ELEM: String = "depends"
  const val DEPENDS_OPTIONAL_ATTR: String = "optional"
  const val DEPENDS_CONFIG_FILE_ATTR: String = "config-file"

  const val DEPENDENCIES_ELEM: String = "dependencies"
  const val DEPENDENCIES_MODULE_ELEM: String = "module"
  const val DEPENDENCIES_MODULE_NAME_ATTR: String = "name"
  const val DEPENDENCIES_MODULE_NAMESPACE_ATTR: String = "namespace"
  const val DEPENDENCIES_PLUGIN_ELEM: String = "plugin"
  const val DEPENDENCIES_PLUGIN_ID_ATTR: String = "id"

  const val INCOMPATIBLE_WITH_ELEM: String = "incompatible-with"

  const val ACTIONS_ELEM: String = "actions"
  const val ACTIONS_RESOURCE_BUNDLE_ATTR: String = "resource-bundle"

  const val APPLICATION_LISTENERS_ELEM: String = "applicationListeners"
  const val PROJECT_LISTENERS_ELEM: String = "projectListeners"

  const val LISTENER_ELEM: String = "listener"
  const val LISTENER_OS_ATTR: String = "os"
  const val LISTENER_CLASS_ATTR: String = "class"
  const val LISTENER_TOPIC_ATTR: String = "topic"
  const val LISTENER_ACTIVE_IN_TEST_MODE_ATTR: String = "activeInTestMode"
  const val LISTENER_ACTIVE_IN_HEADLESS_MODE_ATTR: String = "activeInHeadlessMode"

  const val EXTENSIONS_ELEM: String = "extensions"
  const val EXTENSIONS_DEFAULT_EXTENSION_NS_ATTR: String = "defaultExtensionNs"

  const val EXTENSION_IMPLEMENTATION_ATTR: String = "implementation"
  const val EXTENSION_IMPLEMENTATION_CLASS_ATTR: String = "implementationClass"
  const val EXTENSION_OS_ATTR: String = "os"
  const val EXTENSION_ORDER_ID_ATTR: String = "id"
  const val EXTENSION_ORDER_ATTR: String = "order"
  const val EXTENSION_POINT_ATTR: String = "point"

  const val EXTENSION_POINTS_ELEM: String = "extensionPoints"
  const val EXTENSION_POINTS_XINCLUDE_VALUE: String = "xpointer(/idea-plugin/extensionPoints/*)"

  const val EXTENSION_POINT_ELEM: String = "extensionPoint"
  const val EXTENSION_POINT_AREA_ATTR: String = "area"
  const val EXTENSION_POINT_NAME_ATTR: String = "name"
  const val EXTENSION_POINT_QUALIFIED_NAME_ATTR: String = "qualifiedName"
  const val EXTENSION_POINT_BEAN_CLASS_ATTR: String = "beanClass"
  const val EXTENSION_POINT_INTERFACE_ATTR: String = "interface"
  const val EXTENSION_POINT_DYNAMIC_ATTR: String = "dynamic"
  const val EXTENSION_POINT_HAS_ATTRIBUTES_ATTR: String = "hasAttributes"
  const val EXTENSION_POINT_AREA_IDEA_PROJECT_VALUE: String = "IDEA_PROJECT"
  const val EXTENSION_POINT_AREA_IDEA_MODULE_VALUE: String = "IDEA_MODULE"

  const val SERVICE_EP_SERVICE_INTERFACE_ATTR: String = "serviceInterface"
  const val SERVICE_EP_SERVICE_IMPLEMENTATION_ATTR: String = "serviceImplementation"
  const val SERVICE_EP_TEST_SERVICE_IMPLEMENTATION_ATTR: String = "testServiceImplementation"
  const val SERVICE_EP_HEADLESS_IMPLEMENTATION_ATTR: String = "headlessImplementation"
  const val SERVICE_EP_CONFIGURATION_SCHEMA_KEY_ATTR: String = "configurationSchemaKey"
  const val SERVICE_EP_OVERRIDES_ATTR: String = "overrides"
  const val SERVICE_EP_OPEN_ATTR: String = "open"
  const val SERVICE_EP_PRELOAD_ATTR: String = "preload"
  const val SERVICE_EP_PRELOAD_TRUE_VALUE: String = "true"
  const val SERVICE_EP_PRELOAD_FALSE_VALUE: String = "false"
  const val SERVICE_EP_PRELOAD_AWAIT_VALUE: String = "await"
  const val SERVICE_EP_PRELOAD_NOT_HEADLESS_VALUE: String = "notHeadless"
  const val SERVICE_EP_PRELOAD_NOT_LIGHT_EDIT_VALUE: String = "notLightEdit"
  const val SERVICE_EP_CLIENT_ATTR: String = "client"
  const val SERVICE_EP_CLIENT_LOCAL_VALUE: String = "local"
  const val SERVICE_EP_CLIENT_GUEST_VALUE: String = "guest"
  const val SERVICE_EP_CLIENT_CONTROLLER_VALUE: String = "controller"
  const val SERVICE_EP_CLIENT_OWNER_VALUE: String = "owner"
  const val SERVICE_EP_CLIENT_REMOTE_VALUE: String = "remote"
  const val SERVICE_EP_CLIENT_FRONTEND_VALUE: String = "frontend"
  const val SERVICE_EP_CLIENT_ALL_VALUE: String = "all"

  const val APPLICATION_COMPONENTS_ELEM: String = "application-components"
  const val PROJECT_COMPONENTS_ELEM: String = "project-components"
  const val MODULE_COMPONENTS_ELEM: String = "module-components"

  const val COMPONENT_ELEM: String = "component"
  const val COMPONENT_SKIP_FOR_DEFAULT_PROJECT_ELEM: String = "skipForDefaultProject"
  const val COMPONENT_LOAD_FOR_DEFAULT_PROJECT_ELEM: String = "loadForDefaultProject"
  const val COMPONENT_INTERFACE_CLASS_ELEM: String = "interface-class"
  const val COMPONENT_IMPLEMENTATION_CLASS_ELEM: String = "implementation-class"
  const val COMPONENT_HEADLESS_IMPLEMENTATION_CLASS_ELEM: String = "headless-implementation-class"
  const val COMPONENT_OPTION_ELEM: String = "option"
  const val COMPONENT_OPTION_NAME_ATTR: String = "name"
  const val COMPONENT_OPTION_NAME_OS_VALUE: String = "os"
  const val COMPONENT_OPTION_NAME_OVERRIDES_VALUE: String = "overrides"
  const val COMPONENT_OPTION_VALUE_ATTR: String = "value"

  const val INCLUDE_ELEM: String = "include"
  const val INCLUDE_HREF_ATTR: String = "href"
  const val INCLUDE_XPOINTER_ATTR: String = "xpointer"
  const val INCLUDE_INCLUDE_IF_ATTR: String = "includeIf"
  const val INCLUDE_INCLUDE_UNLESS_ATTR: String = "includeUnless"
  const val INCLUDE_FALLBACK_ELEM: String = "fallback"

  const val DEFAULT_XPOINTER_VALUE: String = "xpointer(/idea-plugin/*)"
  const val XINCLUDE_NAMESPACE_URI: String = "http://www.w3.org/2001/XInclude"

  const val FQN_APPLICATION_SERVICE: String = "com.intellij.applicationService"
  const val FQN_PROJECT_SERVICE: String = "com.intellij.projectService"
  const val FQN_MODULE_SERVICE: String = "com.intellij.moduleService"
  const val FQN_POST_STARTUP_ACTIVITY: String = "com.intellij.postStartupActivity"

  const val OS_MAC_VALUE: String = "mac"
  const val OS_LINUX_VALUE: String = "linux"
  const val OS_WINDOWS_VALUE: String = "windows"
  const val OS_UNIX_VALUE: String = "unix"
  const val OS_FREEBSD_VALUE: String = "freebsd"
}