/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.webTypes.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.polySymbols.webTypes.WebTypesLoadUtilKt;
import com.intellij.polySymbols.webTypes.json.WebTypes;
import com.intellij.util.text.SemVer;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0014J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/polySymbols/webTypes/impl/WebTypesDefinitionsEP;", "Lcom/intellij/openapi/extensions/CustomLoadingExtensionPointBean;", "Lcom/intellij/polySymbols/webTypes/json/WebTypes;", "<init>", "()V", "source", "", "enableByDefault", "", "Ljava/lang/Boolean;", "getImplementationClassName", "createInstance", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Companion", "intellij.platform.polySymbols"})
public class WebTypesDefinitionsEP
extends CustomLoadingExtensionPointBean<WebTypes> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Attribute(value="source")
    @JvmField
    @Nullable
    public String source;
    @Attribute(value="enableByDefault")
    @JvmField
    @Nullable
    public Boolean enableByDefault;
    @NotNull
    private static final ExtensionPointName<WebTypesDefinitionsEP> EP_NAME = new ExtensionPointName("com.intellij.polySymbols.webTypes");

    @Nullable
    protected String getImplementationClassName() {
        return null;
    }

    @NotNull
    public WebTypes createInstance(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        PluginId pluginId = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId pluginId2 = pluginId;
        try {
            InputStream inputStream = pluginDescriptor.getClassLoader().getResourceAsStream(this.source);
            if (inputStream == null) {
                throw new PluginException("Cannot find web-types definitions located at '" + this.source + "'", pluginId2);
            }
            InputStream inputStream2 = inputStream;
            WebTypes webTypes = WebTypesLoadUtilKt.readWebTypes(inputStream2);
            if (webTypes.getName() == null) {
                throw new PluginException("Missing package-name in web-types definitions from '" + this.source + "'", pluginId2);
            }
            if (SemVer.parseFromText((String)webTypes.getVersion()) == null) {
                throw new PluginException("Cannot parse version '" + webTypes.getVersion() + "' in web-types definitions from '" + this.source + "'", pluginId2);
            }
            return webTypes;
        }
        catch (IOException e) {
            throw new PluginException("Cannot load web-types definitions from '" + this.source + "': " + e.getMessage(), (Throwable)e, pluginId2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/polySymbols/webTypes/impl/WebTypesDefinitionsEP$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/polySymbols/webTypes/impl/WebTypesDefinitionsEP;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.polySymbols"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<WebTypesDefinitionsEP> getEP_NAME() {
            return EP_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

