/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.pratt;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class MutableMarker {
    private final PsiBuilder.Marker myStartMarker;
    private IElementType myResultType;
    private final int myInitialPathLength;
    private final LinkedList<IElementType> myPath;
    private Mode myMode = Mode.READY;

    @ApiStatus.Internal
    MutableMarker(LinkedList<IElementType> path, PsiBuilder.Marker startMarker, int initialPathLength) {
        this.myPath = path;
        this.myStartMarker = startMarker;
        this.myInitialPathLength = initialPathLength;
    }

    public boolean isCommitted() {
        return this.myMode == Mode.COMMITTED;
    }

    public boolean isDropped() {
        return this.myMode == Mode.DROPPED;
    }

    public boolean isError() {
        return this.myMode == Mode.ERROR;
    }

    public boolean isReady() {
        return this.myMode == Mode.READY;
    }

    public MutableMarker setResultType(IElementType resultType) {
        this.myResultType = resultType;
        return this;
    }

    public IElementType getResultType() {
        return this.myResultType;
    }

    public void finish() {
        if (this.myMode == Mode.READY) {
            if (this.myResultType == null) {
                this.myMode = Mode.DROPPED;
                this.myStartMarker.drop();
            } else {
                this.myMode = Mode.COMMITTED;
                this.myStartMarker.done(this.myResultType);
                this.restorePath();
                this.myPath.addLast(this.myResultType);
            }
        }
    }

    private void restorePath() {
        while (this.myPath.size() > this.myInitialPathLength) {
            this.myPath.removeLast();
        }
    }

    public MutableMarker precede() {
        return new MutableMarker(this.myPath, this.myStartMarker.precede(), this.myInitialPathLength);
    }

    public void finish(IElementType type) {
        this.setResultType(type);
        this.finish();
    }

    public void drop() {
        assert (this.myMode == Mode.READY) : this.myMode;
        this.myMode = Mode.DROPPED;
        this.myStartMarker.drop();
    }

    public void rollback() {
        assert (this.myMode == Mode.READY) : this.myMode;
        this.myMode = Mode.DROPPED;
        this.restorePath();
        this.myStartMarker.rollbackTo();
    }

    public void error(@NlsContexts.ParsingError @NotNull String message) {
        if (message == null) {
            MutableMarker.$$$reportNull$$$0(0);
        }
        assert (this.myMode == Mode.READY) : this.myMode;
        this.myMode = Mode.ERROR;
        this.myStartMarker.error(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/platform/pratt/MutableMarker", "error"));
    }

    static enum Mode {
        READY,
        DROPPED,
        COMMITTED,
        ERROR;

    }
}

