/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentStorageUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/components/impl/stores/ComponentStorageUtil;", "", "<init>", "()V", "COMPONENT", "", "NAME", "DEFAULT_EXT", "loadComponents", "", "Lorg/jdom/Element;", "rootElement", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "getComponentNameIfValid", "element", "loadTextContent", "file", "Ljava/nio/file/Path;", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nComponentStorageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentStorageUtil.kt\ncom/intellij/openapi/components/impl/stores/ComponentStorageUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,95:1\n13#2:96\n*S KotlinDebug\n*F\n+ 1 ComponentStorageUtil.kt\ncom/intellij/openapi/components/impl/stores/ComponentStorageUtil\n*L\n79#1:96\n*E\n"})
public final class ComponentStorageUtil {
    @NotNull
    public static final ComponentStorageUtil INSTANCE = new ComponentStorageUtil();
    @NotNull
    public static final String COMPONENT = "component";
    @NotNull
    public static final String NAME = "name";
    @NotNull
    public static final String DEFAULT_EXT = ".xml";

    private ComponentStorageUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Element> loadComponents(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        PathMacroSubstitutor pathMacroSubstitutor2 = pathMacroSubstitutor;
        if (pathMacroSubstitutor2 != null) {
            pathMacroSubstitutor2.expandPaths(rootElement);
        }
        List children = rootElement.getChildren(COMPONENT);
        if (children.isEmpty() && Intrinsics.areEqual((Object)rootElement.getName(), (Object)COMPONENT) && rootElement.getAttributeValue(NAME) != null) {
            children = (List)new SmartList((Object)rootElement);
        }
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        CompositePathMacroFilter filter = null;
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Intrinsics.checkNotNull((Object)element);
            String name = ComponentStorageUtil.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getContent().isEmpty()) continue;
            iterator.remove();
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor && !ComponentStorageUtilKt.access$isKotlinSerializable(element)) {
                if (filter == null) {
                    filter = new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList());
                }
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.Companion.getMacroNames$default(PathMacrosCollector.Companion, element, filter, null, 4, null));
            }
            element.removeAttribute(NAME);
            map.put(name, element);
        }
        return map;
    }

    @JvmStatic
    @Nullable
    public static final String getComponentNameIfValid(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name = element.getAttributeValue(NAME);
        CharSequence charSequence = name;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return name;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentStorageUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element));
        return null;
    }

    @JvmStatic
    @NotNull
    public static final String loadTextContent(@NotNull Path file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] data = Files.readAllBytes(file);
        int offset = CharsetToolkit.getBOMLength((byte[])data, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNull((Object)data);
        byte[] byArray = data;
        int n = data.length - offset;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, offset, n, charset2);
    }
}

