/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkBridge;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.storage.InternalEnvironmentName;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkBridgeImpl;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkImpl
extends UserDataHolderBase
implements SdkBridge,
SdkModificator,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectJdkImpl.class);
    private final SdkBridge delegate;
    private SdkModificator modificator;

    @ApiStatus.Internal
    public ProjectJdkImpl(SdkBridge delegate) {
        this.delegate = delegate;
        Disposer.register((Disposable)((Disposable)VirtualFilePointerManager.getInstance()), (Disposable)this);
    }

    private ProjectJdkImpl(SdkBridge delegate, SdkModificator modificator) {
        this(delegate);
        this.modificator = modificator;
    }

    public ProjectJdkImpl(@NotNull String name, @NotNull SdkTypeId sdkType) {
        if (name == null) {
            ProjectJdkImpl.$$$reportNull$$$0(0);
        }
        if (sdkType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(1);
        }
        this(name, sdkType, "", null);
    }

    public ProjectJdkImpl(@NotNull String name, @NotNull SdkTypeId sdkType, String homePath, String version) {
        if (name == null) {
            ProjectJdkImpl.$$$reportNull$$$0(2);
        }
        if (sdkType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(3);
        }
        this(name, sdkType, homePath, version, (InternalEnvironmentName)InternalEnvironmentName.Local.INSTANCE);
    }

    @ApiStatus.Internal
    public ProjectJdkImpl(@NotNull String name, @NotNull SdkTypeId sdkType, String homePath, String version, @NotNull InternalEnvironmentName environmentName) {
        if (name == null) {
            ProjectJdkImpl.$$$reportNull$$$0(4);
        }
        if (sdkType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(5);
        }
        if (environmentName == null) {
            ProjectJdkImpl.$$$reportNull$$$0(6);
        }
        SdkEntity.Builder sdkEntity = SdkBridgeImpl.Companion.createEmptySdkEntity(name, sdkType.getName(), homePath, version, environmentName);
        this.delegate = new SdkBridgeImpl(sdkEntity, environmentName);
        Disposer.register((Disposable)((Disposable)VirtualFilePointerManager.getInstance()), (Disposable)this);
    }

    public void dispose() {
        SdkBridge sdkBridge = this.delegate;
        if (sdkBridge instanceof Disposable) {
            Disposable disposable = (Disposable)sdkBridge;
            Disposer.dispose((Disposable)disposable);
        }
    }

    @NotNull
    public SdkTypeId getSdkType() {
        SdkTypeId sdkTypeId = this.delegate.getSdkType();
        if (sdkTypeId == null) {
            ProjectJdkImpl.$$$reportNull$$$0(7);
        }
        return sdkTypeId;
    }

    @NotNull
    public String getName() {
        if (this.modificator != null) {
            String string = this.modificator.getName();
            if (string == null) {
                ProjectJdkImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = this.delegate.getName();
        if (string == null) {
            ProjectJdkImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            ProjectJdkImpl.$$$reportNull$$$0(10);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        } else {
            this.modificator.setName(name);
        }
    }

    public final void setVersionString(@Nullable String versionString) {
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        } else {
            this.modificator.setVersionString(versionString);
        }
    }

    public String getVersionString() {
        if (this.modificator != null) {
            return this.modificator.getVersionString();
        }
        return this.delegate.getVersionString();
    }

    public String getHomePath() {
        if (this.modificator != null) {
            return this.modificator.getHomePath();
        }
        return this.delegate.getHomePath();
    }

    public void setHomePath(String path) {
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        } else {
            this.modificator.setHomePath(path);
        }
    }

    public VirtualFile getHomeDirectory() {
        return this.delegate.getHomeDirectory();
    }

    @Override
    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(11);
        }
        this.delegate.readExternal(element);
    }

    @Override
    public void readExternal(@NotNull Element element, @NotNull Function<String, SdkTypeId> sdkTypeByNameFunction) throws InvalidDataException {
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(12);
        }
        if (sdkTypeByNameFunction == null) {
            ProjectJdkImpl.$$$reportNull$$$0(13);
        }
        this.delegate.readExternal(element, sdkTypeByNameFunction);
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(14);
        }
        this.delegate.writeExternal(element);
    }

    @Override
    @NotNull
    public ProjectJdkImpl clone() {
        return new ProjectJdkImpl(this.delegate.clone());
    }

    @NotNull
    public RootProvider getRootProvider() {
        RootProvider rootProvider = this.delegate.getRootProvider();
        if (rootProvider == null) {
            ProjectJdkImpl.$$$reportNull$$$0(15);
        }
        return rootProvider;
    }

    @Override
    @ApiStatus.Internal
    public void changeType(@NotNull SdkTypeId newType, @Nullable Element additionalDataElement) {
        if (newType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(16);
        }
        this.delegate.changeType(newType, additionalDataElement);
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        if (this.modificator != null) {
            LOG.error("Forbidden to call `getSdkModificator` on already modifiable version of SDK");
        }
        SdkBridgeImpl sdkBridge = (SdkBridgeImpl)this.delegate;
        return new ProjectJdkImpl(this.delegate, sdkBridge.getSdkModificator(this));
    }

    public void commitChanges() {
        if (this.modificator == null) {
            LOG.error("Forbidden to call `commitChanges` outside of `SdkModificator`");
        }
        ThreadingAssertions.assertWriteAccess();
        this.modificator.commitChanges();
        SdkAdditionalData sdkAdditionalData = this.modificator.getSdkAdditionalData();
        if (sdkAdditionalData != null) {
            sdkAdditionalData.markAsCommited();
        }
        this.modificator = null;
    }

    public void applyChangesWithoutWriteAction() {
        this.modificator.applyChangesWithoutWriteAction();
        this.modificator = null;
    }

    public SdkAdditionalData getSdkAdditionalData() {
        if (this.modificator != null) {
            return this.modificator.getSdkAdditionalData();
        }
        SdkAdditionalData sdkAdditionalData = this.delegate.getSdkAdditionalData();
        if (sdkAdditionalData != null) {
            sdkAdditionalData.markAsCommited();
        }
        return sdkAdditionalData;
    }

    public void setSdkAdditionalData(SdkAdditionalData data) {
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        } else {
            this.modificator.setSdkAdditionalData(data);
        }
    }

    @ApiStatus.Internal
    public SdkBridge getDelegate() {
        return this.delegate;
    }

    public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(17);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to call `getRoots` outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        VirtualFile[] virtualFileArray = this.modificator.getRoots(rootType);
        if (virtualFileArray == null) {
            ProjectJdkImpl.$$$reportNull$$$0(18);
        }
        return virtualFileArray;
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(19);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to call `getUrls` outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        String[] stringArray = this.modificator.getUrls(rootType);
        if (stringArray == null) {
            ProjectJdkImpl.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            ProjectJdkImpl.$$$reportNull$$$0(21);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(22);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        this.modificator.addRoot(root, rootType);
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            ProjectJdkImpl.$$$reportNull$$$0(23);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(24);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        this.modificator.addRoot(url, rootType);
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            ProjectJdkImpl.$$$reportNull$$$0(25);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(26);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        this.modificator.removeRoot(root, rootType);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            ProjectJdkImpl.$$$reportNull$$$0(27);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(28);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        this.modificator.removeRoot(url, rootType);
    }

    public void removeRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(29);
        }
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        this.modificator.removeRoots(rootType);
    }

    public void removeAllRoots() {
        if (this.modificator == null) {
            LOG.error("Forbidden to mutate SDK outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        this.modificator.removeAllRoots();
    }

    public boolean isWritable() {
        if (this.modificator == null) {
            LOG.error("Forbidden to call `isWritable` outside of the `SdkModificator`. Please, use `com.intellij.openapi.projectRoots.Sdk.getSdkModificator`");
        }
        return this.modificator.isWritable();
    }

    public String toString() {
        if (this.modificator != null) {
            return this.modificator.toString();
        }
        return this.delegate.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 15, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeByNameFunction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "changeType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 15, 18, 20 -> new IllegalStateException(string);
        };
    }
}

