/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

abstract class OrderRootComputer<RootEntry> {
    private static final Logger LOG = Logger.getInstance(OrderRootComputer.class);
    @NotNull
    private final OrderEnumeratorBase myOrderEnumerator;
    @NotNull
    private final Function<OrderEntry, OrderRootType> myOrderEntryToRootType;
    @Nullable
    private final NotNullFunction<? super JdkOrderEntry, VirtualFile[]> myCustomSdkRootProvider;
    private final boolean myWithoutSelfModuleOutput;

    OrderRootComputer(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull Function<OrderEntry, OrderRootType> orderEntryToRootType, @Nullable NotNullFunction<? super JdkOrderEntry, VirtualFile[]> customSdkRootProvider, boolean withoutSelfModuleOutput) {
        if (orderEnumerator == null) {
            OrderRootComputer.$$$reportNull$$$0(0);
        }
        if (orderEntryToRootType == null) {
            OrderRootComputer.$$$reportNull$$$0(1);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myOrderEntryToRootType = orderEntryToRootType;
        this.myCustomSdkRootProvider = customSdkRootProvider;
        this.myWithoutSelfModuleOutput = withoutSelfModuleOutput;
    }

    @NotNull
    Collection<RootEntry> computeRoots() {
        LinkedHashSet result = new LinkedHashSet();
        this.myOrderEnumerator.forEach((PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            OrderRootType type = this.myOrderEntryToRootType.apply((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                ModuleRootModel rootModel = ((ModuleSourceOrderEntry)orderEntry).getRootModel();
                boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && (OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || this.myOrderEnumerator.isRootModuleModel(rootModel));
                this.collectModuleRoots(type, rootModel, result, true, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers, (OrderEntry)orderEntry);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module = moduleOrderEntry.getModule();
                if (module != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module);
                    boolean productionOnTests = ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRoots(type, rootModel, result, !productionOnTests, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers, (OrderEntry)orderEntry);
                }
            } else if (orderEntry instanceof LibraryOrSdkOrderEntry) {
                if (this.myCustomSdkRootProvider != null && orderEntry instanceof JdkOrderEntry) {
                    this.addAll((Collection<? super RootEntry>)result, (VirtualFile[])this.myCustomSdkRootProvider.fun((Object)((JdkOrderEntry)orderEntry)), (OrderEntry)orderEntry);
                    return true;
                }
                if (this.addCustomRootsForLibraryOrSdk((LibraryOrSdkOrderEntry)orderEntry, type, result, (List<? extends OrderEnumerationHandler>)customHandlers)) {
                    return true;
                }
                this.addAll((Collection<? super RootEntry>)result, ((LibraryOrSdkOrderEntry)orderEntry).getRootFiles(type), (OrderEntry)orderEntry);
            } else {
                LOG.error("Unexpected implementation of OrderEntry: " + orderEntry.getClass().getName());
            }
            return true;
        }));
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            OrderRootComputer.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private void collectModuleRoots(@NotNull OrderRootType type, ModuleRootModel rootModel, @NotNull Collection<? super RootEntry> result, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers, @NotNull OrderEntry orderEntry) {
        CompilerModuleExtension extension;
        if (type == null) {
            OrderRootComputer.$$$reportNull$$$0(3);
        }
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(4);
        }
        if (customHandlers == null) {
            OrderRootComputer.$$$reportNull$$$0(5);
        }
        if (orderEntry == null) {
            OrderRootComputer.$$$reportNull$$$0(6);
        }
        if (type.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                this.addAll(result, rootModel.getSourceRoots(includeTests), orderEntry);
            } else {
                this.addAll(result, rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS), orderEntry);
            }
        } else if (type.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    this.addAll(result, extension.getOutputRoots(false), orderEntry);
                }
            } else if (includeProduction) {
                this.addAll(result, extension.getOutputRoots(includeTests), orderEntry);
            } else {
                this.addIfNotNull(result, extension.getCompilerOutputPathForTests(), orderEntry);
            }
        }
        this.addCustomRootsForModule(type, rootModel, orderEntry, result, includeProduction, includeTests, customHandlers);
    }

    private boolean addCustomRootsForLibraryOrSdk(@NotNull LibraryOrSdkOrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<? super RootEntry> result, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderRootComputer.$$$reportNull$$$0(7);
        }
        if (type == null) {
            OrderRootComputer.$$$reportNull$$$0(8);
        }
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(9);
        }
        if (customHandlers == null) {
            OrderRootComputer.$$$reportNull$$$0(10);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomRootsForLibraryOrSdk(forOrderEntry, type, urls);
            for (String url : urls) {
                this.addIfNotNull(result, VirtualFileManager.getInstance().findFileByUrl(url), (OrderEntry)forOrderEntry);
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    private void addCustomRootsForModule(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull OrderEntry entry, @NotNull Collection<? super RootEntry> result, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (type == null) {
            OrderRootComputer.$$$reportNull$$$0(11);
        }
        if (rootModel == null) {
            OrderRootComputer.$$$reportNull$$$0(12);
        }
        if (entry == null) {
            OrderRootComputer.$$$reportNull$$$0(13);
        }
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(14);
        }
        if (customHandlers == null) {
            OrderRootComputer.$$$reportNull$$$0(15);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomModuleRoots(type, rootModel, urls, includeProduction, includeTests);
            for (String url : urls) {
                this.addIfNotNull(result, VirtualFileManager.getInstance().findFileByUrl(url), entry);
            }
            if (!added) continue;
            return;
        }
    }

    private void addAll(@NotNull Collection<? super RootEntry> result, VirtualFile @NotNull [] roots, @NotNull OrderEntry orderEntry) {
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(16);
        }
        if (orderEntry == null) {
            OrderRootComputer.$$$reportNull$$$0(17);
        }
        if (roots == null) {
            OrderRootComputer.$$$reportNull$$$0(18);
        }
        for (VirtualFile root : roots) {
            this.addEntry(result, root, orderEntry);
        }
    }

    private void addAll(@NotNull Collection<? super RootEntry> result, @NotNull Iterable<VirtualFile> roots, @NotNull OrderEntry orderEntry) {
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(19);
        }
        if (roots == null) {
            OrderRootComputer.$$$reportNull$$$0(20);
        }
        if (orderEntry == null) {
            OrderRootComputer.$$$reportNull$$$0(21);
        }
        for (VirtualFile root : roots) {
            this.addEntry(result, root, orderEntry);
        }
    }

    private void addIfNotNull(@NotNull Collection<? super RootEntry> result, @Nullable VirtualFile root, @NotNull OrderEntry orderEntry) {
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(22);
        }
        if (orderEntry == null) {
            OrderRootComputer.$$$reportNull$$$0(23);
        }
        if (root != null) {
            this.addEntry(result, root, orderEntry);
        }
    }

    private void addEntry(@NotNull Collection<? super RootEntry> result, @NotNull VirtualFile root, @NotNull OrderEntry orderEntry) {
        if (result == null) {
            OrderRootComputer.$$$reportNull$$$0(24);
        }
        if (root == null) {
            OrderRootComputer.$$$reportNull$$$0(25);
        }
        if (orderEntry == null) {
            OrderRootComputer.$$$reportNull$$$0(26);
        }
        RootEntry entry = this.produceEntry(root, orderEntry);
        result.add(entry);
    }

    @NotNull
    protected abstract RootEntry produceEntry(@NotNull VirtualFile var1, @NotNull OrderEntry var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEnumerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntryToRootType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderRootComputer";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 6: 
            case 17: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOrderEntry";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderRootComputer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForLibraryOrSdk";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForModule";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

