/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.CustomLibraryTableDescription;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.workspace.jps.entities.InheritedSdkDependency;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityAndExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.LibraryLevelsTracker;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.MultiSet;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryModifiableModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableRootModelBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyListener;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0004ABCDB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'J:\u0010(\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020!0/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J:\u00103\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020!0/2\f\u00105\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\b\u00106\u001a\u00020\u0019H\u0016J\u001a\u00107\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\b\u00108\u001a\u0004\u0018\u000109H\u0002J\u0016\u0010:\u001a\u00020\u00192\f\u0010;\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\u0018\u0010<\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010=\u001a\u000209H\u0002J\u0016\u0010>\u001a\u00020\u00192\f\u0010?\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\b\u0010@\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006E"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyIndex;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleDependencyListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "libraryTablesListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener;", "jdkChangeListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener;", "rootSetChangeListener", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$ReferencedRootSetChangeListener;", "eelMachine", "Lcom/intellij/platform/eel/EelMachine;", "getEelMachine", "()Lcom/intellij/platform/eel/EelMachine;", "addListener", "", "listener", "removeListener", "setupTrackedLibrariesAndJdks", "hasProjectSdkDependency", "", "hasDependencyOn", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "workspaceModelChanged", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "collectAddedLibrariesAndAddSdks", "dependencies", "", "Lcom/intellij/platform/workspace/jps/entities/ModuleDependencyItem;", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "libraryIdsCollector", "", "libraryLevelsCollector", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/MultiSet;", "", "collectRemovedLibrariesAndRemoveSdks", "removeLibrariesCollector", "removeLibraryLevelsCollector", "dispose", "addTrackedLibrary", "storageBefore", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "trackLibraryLevel", "newLibraryLevels", "unTrackLibrary", "currentStorage", "untrackLibraryLevel", "removedLibraryLevels", "reset", "Companion", "ReferencedRootSetChangeListener", "LibraryTablesListener", "JdkChangeListener", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 5 Timing.kt\nkotlin/system/TimingKt\n+ 6 LibraryLevelsTracker.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/MultiSet\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,490:1\n60#2,5:491\n60#2,5:502\n60#2,5:507\n60#2,5:512\n13#2:535\n1869#3,2:496\n1869#3,2:517\n1869#3,2:519\n1869#3,2:523\n1869#3,2:525\n44#4,2:498\n46#4:522\n29#5,2:500\n31#5:521\n100#6:527\n101#6:530\n100#6:531\n101#6:534\n216#7,2:528\n216#7,2:532\n*S KotlinDebug\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl\n*L\n105#1:491,5\n145#1:502,5\n149#1:507,5\n155#1:512,5\n48#1:535\n112#1:496,2\n162#1:517,2\n163#1:519,2\n172#1:523,2\n189#1:525,2\n132#1:498,2\n132#1:522\n132#1:500,2\n132#1:521\n240#1:527\n240#1:530\n259#1:531\n259#1:534\n240#1:528,2\n259#1:532,2\n*E\n"})
public class ModuleDependencyIndexImpl
implements ModuleDependencyIndex,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EventDispatcher<ModuleDependencyListener> eventDispatcher;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final LibraryTablesListener libraryTablesListener;
    @NotNull
    private final JdkChangeListener jdkChangeListener;
    @NotNull
    private final ReferencedRootSetChangeListener rootSetChangeListener;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AtomicLong changedListenerTimeMs;

    public ModuleDependencyIndexImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        EventDispatcher eventDispatcher = EventDispatcher.create(ModuleDependencyListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.project);
        this.libraryTablesListener = new LibraryTablesListener();
        this.jdkChangeListener = new JdkChangeListener();
        this.rootSetChangeListener = new ReferencedRootSetChangeListener();
        if (!this.project.isDefault()) {
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
            Topic topic = ProjectJdkTable.JDK_TABLE_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"JDK_TABLE_TOPIC");
            messageBusConnection.subscribe(topic, (Object)this.jdkChangeListener);
        }
        CustomLibraryTableDescription.CUSTOM_TABLES_EP.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CustomLibraryTableDescription>(){

            public void extensionRemoved(CustomLibraryTableDescription extension, PluginDescriptor pluginDescriptor) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(extension.getTableLevel(), project);
                    if (libraryTable == null) break block0;
                    LibraryTable libraryTable2 = libraryTable;
                    ModuleDependencyIndexImpl moduleDependencyIndexImpl = this;
                    LibraryTable table = libraryTable2;
                    boolean bl = false;
                    moduleDependencyIndexImpl.libraryTablesListener.unsubscribeFromCustomTableOnDispose(table);
                }
            }
        }, true, (Disposable)this.project);
    }

    private final EelMachine getEelMachine() {
        return EelProviderUtil.getEelDescriptor((Project)this.project).getMachine();
    }

    @Override
    public void addListener(@NotNull ModuleDependencyListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeListener(@NotNull ModuleDependencyListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public void setupTrackedLibrariesAndJdks() {
        ThreadingAssertions.assertWriteAccess();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Add tracked global libraries and SDK for all modules", e$iv);
        }
        ImmutableEntityStorage currentStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        Set addedLibsCollector = new LinkedHashSet();
        MultiSet<String> addedLibraryLevelsCollector = new MultiSet<String>();
        for (ModuleEntity moduleEntity : currentStorage.entities(ModuleEntity.class)) {
            this.collectAddedLibrariesAndAddSdks(moduleEntity.getDependencies(), moduleEntity, addedLibsCollector, addedLibraryLevelsCollector);
        }
        Iterable $this$forEach$iv = addedLibsCollector;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryId it = (LibraryId)element$iv;
            boolean bl = false;
            this.addTrackedLibrary(it, null);
        }
        this.trackLibraryLevel(addedLibraryLevelsCollector);
    }

    @Override
    public boolean hasProjectSdkDependency() {
        return this.jdkChangeListener.hasProjectSdkDependency();
    }

    @Override
    public boolean hasDependencyOn(@NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId || this.libraryTablesListener.hasDependencyOn(libraryId);
    }

    @Override
    public boolean hasDependencyOn(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return this.jdkChangeListener.hasDependencyOn(sdk);
    }

    @Override
    public boolean hasDependencyOn(@NotNull SdkId sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return this.jdkChangeListener.hasDependencyOn(sdk);
    }

    public final void workspaceModelChanged(@NotNull VersionedStorageChange event) {
        LibraryId it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AtomicLong atomicLong = changedListenerTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.project.isDisposed()) {
            return;
        }
        Set newLibrariesCollector = new LinkedHashSet();
        MultiSet<String> newLibraryLevels = new MultiSet<String>();
        Set removedLibrariesCollector = new LinkedHashSet();
        MultiSet<String> removeLibraryLevels = new MultiSet<String>();
        List moduleChanges = event.getChanges(ModuleEntity.class);
        for (EntityChange change : moduleChanges) {
            Logger logger;
            Throwable e$iv;
            Logger $this$debug_u24default$iv;
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                $this$debug_u24default$iv = LOG;
                e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl4 = false;
                    logger.debug("Add tracked global libraries and SDK from " + ((ModuleEntity)((EntityChange.Added)change).getNewEntity()).getName(), e$iv);
                }
                this.collectAddedLibrariesAndAddSdks(((ModuleEntity)((EntityChange.Added)change).getNewEntity()).getDependencies(), (ModuleEntity)((EntityChange.Added)change).getNewEntity(), newLibrariesCollector, newLibraryLevels);
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                $this$debug_u24default$iv = LOG;
                e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl5 = false;
                    logger.debug("Removed tracked global libraries and SDK from " + ((ModuleEntity)((EntityChange.Removed)change).getOldEntity()).getName(), e$iv);
                }
                this.collectRemovedLibrariesAndRemoveSdks(((ModuleEntity)((EntityChange.Removed)change).getOldEntity()).getDependencies(), (ModuleEntity)((EntityChange.Removed)change).getOldEntity(), removedLibrariesCollector, removeLibraryLevels);
                continue;
            }
            if (entityChange instanceof EntityChange.Replaced) {
                List removedDependencies = CollectionsKt.minus((Iterable)((ModuleEntity)((EntityChange.Replaced)change).getOldEntity()).getDependencies(), (Iterable)CollectionsKt.toSet((Iterable)((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()).getDependencies()));
                List addedDependencies = CollectionsKt.minus((Iterable)((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()).getDependencies(), (Iterable)CollectionsKt.toSet((Iterable)((ModuleEntity)((EntityChange.Replaced)change).getOldEntity()).getDependencies()));
                Logger $this$debug_u24default$iv2 = LOG;
                Throwable e$iv2 = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl6 = false;
                    logger.debug("Update tracked global libraries and SDK for " + ((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()).getName() + ": " + removedDependencies.size() + " removed, " + addedDependencies.size() + " added", e$iv2);
                }
                this.collectRemovedLibrariesAndRemoveSdks(removedDependencies, (ModuleEntity)((EntityChange.Replaced)change).getOldEntity(), removedLibrariesCollector, removeLibraryLevels);
                this.collectAddedLibrariesAndAddSdks(addedDependencies, (ModuleEntity)((EntityChange.Replaced)change).getNewEntity(), newLibrariesCollector, newLibraryLevels);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$forEach$iv = removedLibrariesCollector;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LibraryId)element$iv;
            boolean bl7 = false;
            this.unTrackLibrary(it, event.getStorageAfter());
        }
        $this$forEach$iv = newLibrariesCollector;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LibraryId)element$iv;
            boolean bl8 = false;
            this.addTrackedLibrary(it, event.getStorageBefore());
        }
        this.untrackLibraryLevel(removeLibraryLevels);
        this.trackLibraryLevel(newLibraryLevels);
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final void collectAddedLibrariesAndAddSdks(List<? extends ModuleDependencyItem> dependencies, ModuleEntity moduleEntity, Set<LibraryId> libraryIdsCollector, MultiSet<String> libraryLevelsCollector) {
        Iterable $this$forEach$iv = dependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (it instanceof LibraryDependency && !(((LibraryDependency)it).getLibrary().getTableId() instanceof LibraryTableId.ModuleLibraryTableId)) {
                libraryIdsCollector.add(((LibraryDependency)it).getLibrary());
                libraryLevelsCollector.add(((LibraryDependency)it).getLibrary().getTableId().getLevel());
                continue;
            }
            if (!(it instanceof SdkDependency) && !(it instanceof InheritedSdkDependency)) continue;
            this.jdkChangeListener.addTrackedJdk(it, moduleEntity);
        }
    }

    private final void collectRemovedLibrariesAndRemoveSdks(List<? extends ModuleDependencyItem> dependencies, ModuleEntity moduleEntity, Set<LibraryId> removeLibrariesCollector, MultiSet<String> removeLibraryLevelsCollector) {
        Iterable $this$forEach$iv = dependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem it = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            if (it instanceof LibraryDependency && !(((LibraryDependency)it).getLibrary().getTableId() instanceof LibraryTableId.ModuleLibraryTableId)) {
                removeLibrariesCollector.add(((LibraryDependency)it).getLibrary());
                removeLibraryLevelsCollector.add(((LibraryDependency)it).getLibrary().getTableId().getLevel());
                continue;
            }
            if (!(it instanceof SdkDependency) && !(it instanceof InheritedSdkDependency)) continue;
            this.jdkChangeListener.removeTrackedJdk(it, moduleEntity);
        }
    }

    public void dispose() {
        if (this.project.isDefault()) {
            return;
        }
        this.libraryTablesListener.unsubscribe(false);
        this.jdkChangeListener.unsubscribe(false);
    }

    private final void addTrackedLibrary(LibraryId libraryId, ImmutableEntityStorage storageBefore) {
        block1: {
            Library library;
            Library library2;
            LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
            String libraryLevel = libraryId.getTableId().getLevel();
            LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.project);
            if (libraryTable == null) {
                return;
            }
            LibraryTable libraryTable2 = libraryTable;
            if (storageBefore != null && !SequencesKt.none((Sequence)storageBefore.referrers((SymbolicEntityId)libraryId, ModuleEntity.class)) || (library2 = (library = libraryTable2.getLibraryByName(libraryId.getName()))) == null || (library2 = library2.getRootProvider()) == null) break block1;
            library2.addRootSetChangedListener((RootProvider.RootSetChangedListener)this.rootSetChangeListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void trackLibraryLevel(MultiSet<String> newLibraryLevels) {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        MultiSet<String> this_$iv = newLibraryLevels;
        boolean $i$f$forEachWithOccurrences = false;
        Map $this$forEach$iv$iv = (Map)MultiSet.access$getStorage$p(this_$iv);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void occ;
            LibraryTable libraryTable;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Object key$iv = entry.getKey();
            Integer occ$iv = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)occ$iv);
            int n = ((Number)occ$iv).intValue();
            String libraryLevel = (String)key$iv;
            boolean bl2 = false;
            if (libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.project) == null) continue;
            if (LibraryLevelsTracker.Companion.getInstance(this.project).isNotUsed(libraryLevel)) {
                libraryTable.addListener((LibraryTable.Listener)this.libraryTablesListener);
            }
            LibraryLevelsTracker libraryLevelsTracker = LibraryLevelsTracker.Companion.getInstance(this.project);
            String string = libraryTable.getTableLevel();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTableLevel(...)");
            libraryLevelsTracker.dependencyWithLibraryLevelAdded(string, (int)occ);
        }
    }

    private final void unTrackLibrary(LibraryId libraryId, ImmutableEntityStorage currentStorage) {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        String libraryLevel = libraryId.getTableId().getLevel();
        LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.project);
        if (libraryTable == null) {
            return;
        }
        LibraryTable libraryTable2 = libraryTable;
        Library library = libraryTable2.getLibraryByName(libraryId.getName());
        if (SequencesKt.none((Sequence)currentStorage.referrers((SymbolicEntityId)libraryId, ModuleEntity.class)) && library != null) {
            library.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.rootSetChangeListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void untrackLibraryLevel(MultiSet<String> removedLibraryLevels) {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        MultiSet<String> this_$iv = removedLibraryLevels;
        boolean $i$f$forEachWithOccurrences = false;
        Map $this$forEach$iv$iv = (Map)MultiSet.access$getStorage$p(this_$iv);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            LibraryTable libraryTable;
            void occ;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Object key$iv = entry.getKey();
            Integer occ$iv = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)occ$iv);
            int n = ((Number)occ$iv).intValue();
            String libraryLevel = (String)key$iv;
            boolean bl2 = false;
            if (libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, this.project) == null) continue;
            LibraryLevelsTracker.Companion.getInstance(this.project).dependencyWithLibraryLevelRemoved(libraryLevel, (int)occ);
            if (!LibraryLevelsTracker.Companion.getInstance(this.project).isNotUsed(libraryLevel)) continue;
            libraryTable.removeListener((LibraryTable.Listener)this.libraryTablesListener);
        }
    }

    @Override
    public void reset() {
        this.libraryTablesListener.unsubscribe(true);
        this.jdkChangeListener.unsubscribe(true);
        this.setupTrackedLibrariesAndJdks();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ModuleDependencyIndexImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        changedListenerTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        Meter meter = JpsMetricsKt.getJpsMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        ModuleDependencyIndexImpl.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "changedListenerTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement changedListenerTimeCounter = meter.counterBuilder("jps.module.dependency.index.workspace.model.listener.on.changed.ms").buildObserver();
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(changedListenerTimeCounter), (ObservableMeasurement)changedListenerTimeCounter, new ObservableMeasurement[0]);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $changedListenerTimeCounter) {
            $changedListenerTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)changedListenerTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0006\u0010 \u001a\u00020\u0011J\u0012\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020)J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017H\u0002J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0011R/\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010!\u001a\n \b*\u0004\u0018\u00010\"0\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$\u00a8\u00060"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "Lcom/intellij/openapi/roots/ex/ProjectRootManagerEx$ProjectJdkListener;", "<init>", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;)V", "sdkDependencies", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/platform/workspace/jps/entities/ModuleDependencyItem;", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "Lorg/jetbrains/annotations/NotNull;", "watchedSdks", "Ljava/util/HashSet;", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lkotlin/collections/HashSet;", "watchedProjectSdk", "projectJdkListenerAdded", "", "jdkAdded", "", "jdk", "jdkNameChanged", "previousName", "", "jdkRemoved", "addTrackedJdk", "sdkDependency", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "sdk", "removeTrackedJdk", "projectJdkChanged", "hasProjectSdkDependency", "projectRootManager", "Lcom/intellij/openapi/roots/ProjectRootManager;", "getProjectRootManager", "()Lcom/intellij/openapi/roots/ProjectRootManager;", "projectRootManager$delegate", "Lkotlin/Lazy;", "findSdk", "hasDependencyOn", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "isProjectSdk", "sdkId", "sdkName", "sdkType", "unsubscribe", "fireEvents", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,490:1\n1#2:491\n1869#3,2:492\n1563#3:494\n1634#3,3:495\n*S KotlinDebug\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$JdkChangeListener\n*L\n478#1:492,2\n377#1:494\n377#1:495,3\n*E\n"})
    private final class JdkChangeListener
    implements ProjectJdkTable.Listener,
    ProjectRootManagerEx.ProjectJdkListener {
        @NotNull
        private final MultiMap<ModuleDependencyItem, ModuleId> sdkDependencies;
        @NotNull
        private final HashSet<Sdk> watchedSdks;
        @Nullable
        private Sdk watchedProjectSdk;
        private boolean projectJdkListenerAdded;
        @NotNull
        private final Lazy projectRootManager$delegate;

        public JdkChangeListener() {
            MultiMap multiMap = MultiMap.createSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet(...)");
            this.sdkDependencies = multiMap;
            this.watchedSdks = new HashSet();
            this.projectRootManager$delegate = LazyKt.lazy(() -> JdkChangeListener.projectRootManager_delegate$lambda$0(ModuleDependencyIndexImpl.this));
        }

        public void jdkAdded(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            if (this.hasDependencyOn(jdk)) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedSdkAdded(jdk);
                if (this.hasProjectSdkDependency() && this.isProjectSdk(jdk)) {
                    this.watchedProjectSdk = jdk;
                }
                if (this.watchedSdks.add(jdk)) {
                    jdk.getRootProvider().addRootSetChangedListener((RootProvider.RootSetChangedListener)ModuleDependencyIndexImpl.this.rootSetChangeListener);
                }
            }
        }

        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
            String string = jdk.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            SdkDependency sdkDependency = new SdkDependency(new SdkId(previousName, string));
            Collection collection = this.sdkDependencies.get((Object)sdkDependency);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            Collection affectedModules = collection;
            if (!affectedModules.isEmpty()) {
                WorkspaceModel.Companion.getInstance(ModuleDependencyIndexImpl.this.project).updateProjectModel("Module dependency index: jdk name changed", arg_0 -> JdkChangeListener.jdkNameChanged$lambda$0(affectedModules, jdk, arg_0));
            }
        }

        public void jdkRemoved(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            if (this.hasProjectSdkDependency() && this.isProjectSdk(jdk)) {
                this.watchedProjectSdk = null;
            }
            if (this.watchedSdks.remove(jdk)) {
                jdk.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
            if (this.hasDependencyOn(jdk)) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedSdkRemoved(jdk);
            }
        }

        public final void addTrackedJdk(@NotNull ModuleDependencyItem sdkDependency, @NotNull ModuleEntity moduleEntity) {
            Sdk sdk;
            Intrinsics.checkNotNullParameter((Object)sdkDependency, (String)"sdkDependency");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            if (Intrinsics.areEqual((Object)sdkDependency, (Object)InheritedSdkDependency.INSTANCE) && !this.projectJdkListenerAdded) {
                ProjectRootManager projectRootManager = this.getProjectRootManager();
                Intrinsics.checkNotNull((Object)projectRootManager, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.ex.ProjectRootManagerEx");
                ((ProjectRootManagerEx)projectRootManager).addProjectJdkListener((ProjectRootManagerEx.ProjectJdkListener)this);
                this.projectJdkListenerAdded = true;
            }
            if ((sdk = this.findSdk(sdkDependency)) != null) {
                if (Intrinsics.areEqual((Object)sdkDependency, (Object)InheritedSdkDependency.INSTANCE)) {
                    this.watchedProjectSdk = sdk;
                }
                this.addTrackedJdk(sdk);
            }
            this.sdkDependencies.putValue((Object)sdkDependency, (Object)moduleEntity.getSymbolicId());
        }

        private final void addTrackedJdk(Sdk sdk) {
            if (this.watchedSdks.add(sdk)) {
                sdk.getRootProvider().addRootSetChangedListener((RootProvider.RootSetChangedListener)ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
        }

        public final void removeTrackedJdk(@NotNull ModuleDependencyItem sdkDependency, @NotNull ModuleEntity moduleEntity) {
            Intrinsics.checkNotNullParameter((Object)sdkDependency, (String)"sdkDependency");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            this.sdkDependencies.remove((Object)sdkDependency, (Object)moduleEntity.getSymbolicId());
            Sdk sdk = this.findSdk(sdkDependency);
            if (Intrinsics.areEqual((Object)sdkDependency, (Object)InheritedSdkDependency.INSTANCE) && !this.hasProjectSdkDependency()) {
                this.watchedProjectSdk = null;
            }
            if (sdk != null) {
                this.removeTrackedJdk(sdk);
            }
        }

        private final void removeTrackedJdk(Sdk sdk) {
            if (!this.hasDependencyOn(sdk) && this.watchedSdks.remove(sdk)) {
                sdk.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
        }

        public void projectJdkChanged() {
            block2: {
                Sdk it;
                if (!this.hasProjectSdkDependency()) break block2;
                Sdk sdk = this.watchedProjectSdk;
                if (sdk != null) {
                    it = sdk;
                    boolean bl = false;
                    this.removeTrackedJdk(it);
                }
                Sdk sdk2 = this.watchedProjectSdk = this.getProjectRootManager().getProjectSdk();
                if (sdk2 != null) {
                    it = sdk2;
                    boolean bl = false;
                    this.addTrackedJdk(it);
                }
            }
        }

        public final boolean hasProjectSdkDependency() {
            Collection collection = this.sdkDependencies.get((Object)InheritedSdkDependency.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            return !collection.isEmpty();
        }

        private final ProjectRootManager getProjectRootManager() {
            Lazy lazy = this.projectRootManager$delegate;
            return (ProjectRootManager)lazy.getValue();
        }

        private final Sdk findSdk(ModuleDependencyItem sdkDependency) {
            ModuleDependencyItem moduleDependencyItem = sdkDependency;
            return moduleDependencyItem instanceof InheritedSdkDependency ? this.getProjectRootManager().getProjectSdk() : (moduleDependencyItem instanceof SdkDependency ? ModifiableRootModelBridge.Companion.findSdk(ModuleDependencyIndexImpl.this.project, ((SdkDependency)sdkDependency).getSdk().getName(), ((SdkDependency)sdkDependency).getSdk().getType()) : null);
        }

        public final boolean hasDependencyOn(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            String string = jdk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = jdk.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return this.hasDependencyOn(new SdkId(string, string2));
        }

        public final boolean hasDependencyOn(@NotNull SdkId sdk) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            Collection collection = this.sdkDependencies.get((Object)new SdkDependency(sdk));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            return !collection.isEmpty() || this.isProjectSdk(sdk) && (this.hasProjectSdkDependency() || this.watchedSdks.isEmpty());
        }

        private final boolean isProjectSdk(Sdk jdk) {
            String string = jdk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = jdk.getSdkType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return this.isProjectSdk(string, string2);
        }

        private final boolean isProjectSdk(SdkId sdkId) {
            return this.isProjectSdk(sdkId.getName(), sdkId.getType());
        }

        private final boolean isProjectSdk(String sdkName, String sdkType) {
            return Intrinsics.areEqual((Object)sdkName, (Object)this.getProjectRootManager().getProjectSdkName()) && Intrinsics.areEqual((Object)sdkType, (Object)this.getProjectRootManager().getProjectSdkTypeName());
        }

        /*
         * WARNING - void declaration
         */
        public final void unsubscribe(boolean fireEvents) {
            void $this$forEach$iv;
            Iterable iterable = this.watchedSdks;
            ModuleDependencyIndexImpl moduleDependencyIndexImpl = ModuleDependencyIndexImpl.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Sdk sdk = (Sdk)element$iv;
                boolean bl = false;
                sdk.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)moduleDependencyIndexImpl.rootSetChangeListener);
            }
            this.watchedSdks.clear();
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit jdkNameChanged$lambda$0(Collection $affectedModules, Sdk $jdk, MutableEntityStorage builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            for (ModuleId moduleId : $affectedModules) {
                void $this$mapTo$iv$iv;
                ModuleEntity module;
                if ((ModuleEntity)moduleId.resolve((EntityStorage)builder) == null) continue;
                Iterable $this$map$iv = module.getDependencies();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ModuleDependencyItem moduleDependencyItem;
                    void it;
                    ModuleDependencyItem moduleDependencyItem2 = (ModuleDependencyItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (it instanceof SdkDependency) {
                        String string = $jdk.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = $jdk.getSdkType().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        moduleDependencyItem = (ModuleDependencyItem)new SdkDependency(new SdkId(string, string2));
                    } else {
                        moduleDependencyItem = it;
                    }
                    collection.add(moduleDependencyItem);
                }
                List updated = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
                ModuleEntityAndExtensions.modifyModuleEntity((MutableEntityStorage)builder, (ModuleEntity)module, arg_0 -> JdkChangeListener.jdkNameChanged$lambda$0$1(updated, arg_0));
            }
            return Unit.INSTANCE;
        }

        private static final Unit jdkNameChanged$lambda$0$1(List $updated, ModuleEntity.Builder $this$modifyModuleEntity) {
            Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
            $this$modifyModuleEntity.setDependencies($updated);
            return Unit.INSTANCE;
        }

        private static final ProjectRootManager projectRootManager_delegate$lambda$0(ModuleDependencyIndexImpl this$0) {
            return ProjectRootManager.getInstance((Project)this$0.project);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "<init>", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;)V", "afterLibraryAdded", "", "newLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "afterLibraryRemoved", "library", "hasDependencyOn", "", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "afterLibraryRenamed", "oldName", "", "unsubscribe", "fireEvents", "unsubscribeFromCustomTableOnDispose", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,490:1\n1869#2:491\n1870#2:494\n1869#2:495\n1870#2:498\n1563#2:500\n1634#2,3:501\n32#3,2:492\n32#3,2:496\n1321#4:499\n1322#4:504\n*S KotlinDebug\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$LibraryTablesListener\n*L\n331#1:491\n331#1:494\n342#1:495\n342#1:498\n309#1:500\n309#1:501,3\n333#1:492,2\n344#1:496,2\n308#1:499\n308#1:504\n*E\n"})
    private final class LibraryTablesListener
    implements LibraryTable.Listener {
        public void afterLibraryAdded(@NotNull Library newLibrary) {
            Intrinsics.checkNotNullParameter((Object)newLibrary, (String)"newLibrary");
            if (this.hasDependencyOn(newLibrary)) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedLibraryAdded(newLibrary);
                newLibrary.getRootProvider().addRootSetChangedListener((RootProvider.RootSetChangedListener)ModuleDependencyIndexImpl.this.rootSetChangeListener);
            }
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (this.hasDependencyOn(library)) {
                library.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)ModuleDependencyIndexImpl.this.rootSetChangeListener);
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedLibraryRemoved(library);
            }
        }

        public final boolean hasDependencyOn(@NotNull Library library) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            ProgressManager.checkCanceled();
            Library library2 = library;
            if (library2 instanceof LibraryBridge) {
                bl = this.hasDependencyOn(((LibraryBridge)library).getLibraryId());
            } else if (library2 instanceof LibraryModifiableModelBridge) {
                bl = this.hasDependencyOn(((LibraryModifiableModelBridge)library).getLibraryId());
            } else {
                throw new IllegalStateException(("Unexpected type of library " + library.getClass() + ": " + library).toString());
            }
            return bl;
        }

        public final boolean hasDependencyOn(@NotNull LibraryId libraryId) {
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            return SequencesKt.any((Sequence)ModuleDependencyIndexImpl.this.workspaceModel.getCurrentSnapshot().referrers((SymbolicEntityId)libraryId, ModuleEntity.class));
        }

        public void afterLibraryRenamed(@NotNull Library library, @Nullable String oldName) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            ThreadingAssertions.assertWriteAccess();
            LibraryTable libraryTable = library.getTable();
            String newName = library.getName();
            if (libraryTable != null && oldName != null && newName != null) {
                String string = libraryTable.getTableLevel();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTableLevel(...)");
                LibraryTableId libraryTableId = LibraryNameGenerator.INSTANCE.getLibraryTableId(string);
                LibraryId libraryId = new LibraryId(oldName, libraryTableId);
                Sequence affectedModules = ModuleDependencyIndexImpl.this.workspaceModel.getCurrentSnapshot().referrers((SymbolicEntityId)libraryId, ModuleEntity.class);
                if (SequencesKt.any((Sequence)affectedModules)) {
                    WorkspaceModel.Companion.getInstance(ModuleDependencyIndexImpl.this.project).updateProjectModel("Module dependency index: after library renamed", arg_0 -> LibraryTablesListener.afterLibraryRenamed$lambda$0(affectedModules, libraryTableId, oldName, newName, arg_0));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void unsubscribe(boolean fireEvents) {
            block4: {
                LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
                LibraryLevelsTracker libraryTracker = LibraryLevelsTracker.Companion.getInstanceIfInitialized(ModuleDependencyIndexImpl.this.project);
                Object object = libraryTracker;
                if (object != null && (object = ((LibraryLevelsTracker)object).getLibraryLevels()) != null) {
                    void $this$forEach$iv;
                    Iterable iterable = (Iterable)object;
                    ModuleDependencyIndexImpl moduleDependencyIndexImpl = ModuleDependencyIndexImpl.this;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String libraryLevel = (String)element$iv;
                        boolean bl = false;
                        LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTableByLevel(libraryLevel, moduleDependencyIndexImpl.project);
                        Object object2 = libraryTable;
                        if (object2 != null && (object2 = object2.getLibraryIterator()) != null) {
                            Object $this$forEach$iv2 = object2;
                            boolean $i$f$forEach2 = false;
                            Object object3 = $this$forEach$iv2;
                            while (object3.hasNext()) {
                                Object element$iv2 = object3.next();
                                Library it = (Library)element$iv2;
                                boolean bl2 = false;
                                it.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)moduleDependencyIndexImpl.rootSetChangeListener);
                            }
                        }
                        LibraryTable libraryTable2 = libraryTable;
                        if (libraryTable2 == null) continue;
                        libraryTable2.removeListener((LibraryTable.Listener)moduleDependencyIndexImpl.libraryTablesListener);
                    }
                }
                LibraryLevelsTracker libraryLevelsTracker = libraryTracker;
                if (libraryLevelsTracker == null) break block4;
                libraryLevelsTracker.clear();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void unsubscribeFromCustomTableOnDispose(@NotNull LibraryTable libraryTable) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
            Iterable iterable = LibraryLevelsTracker.Companion.getInstance(ModuleDependencyIndexImpl.this.project).getLibraryLevels();
            ModuleDependencyIndexImpl moduleDependencyIndexImpl = ModuleDependencyIndexImpl.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Iterator $this$forEach$iv2;
                String libraryLevel = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)libraryTable.getTableLevel(), (Object)libraryLevel)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable.getLibraryIterator(), (String)"getLibraryIterator(...)");
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2;
                while (iterator.hasNext()) {
                    Object element$iv2 = iterator.next();
                    Library it = (Library)element$iv2;
                    boolean bl2 = false;
                    it.getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)moduleDependencyIndexImpl.rootSetChangeListener);
                }
                libraryTable.removeListener((LibraryTable.Listener)moduleDependencyIndexImpl.libraryTablesListener);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit afterLibraryRenamed$lambda$0(Sequence $affectedModules, LibraryTableId $libraryTableId, String $oldName, String $newName, MutableEntityStorage builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Sequence $this$forEach$iv = $affectedModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                ModuleEntity module = (ModuleEntity)element$iv;
                boolean bl = false;
                Iterable $this$map$iv = module.getDependencies();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ModuleDependencyItem moduleDependencyItem = (ModuleDependencyItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it instanceof LibraryDependency && Intrinsics.areEqual((Object)((LibraryDependency)it).getLibrary().getTableId(), (Object)$libraryTableId) && Intrinsics.areEqual((Object)((LibraryDependency)it).getLibrary().getName(), (Object)$oldName) ? (ModuleDependencyItem)LibraryDependency.copy$default((LibraryDependency)((LibraryDependency)it), (LibraryId)new LibraryId($newName, $libraryTableId), (boolean)false, null, (int)6, null) : it);
                }
                List updated = TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
                ModuleEntityAndExtensions.modifyModuleEntity((MutableEntityStorage)builder, (ModuleEntity)module, arg_0 -> LibraryTablesListener.afterLibraryRenamed$lambda$0$0$1(updated, arg_0));
            }
            return Unit.INSTANCE;
        }

        private static final Unit afterLibraryRenamed$lambda$0$0$1(List $updated, ModuleEntity.Builder $this$modifyModuleEntity) {
            Intrinsics.checkNotNullParameter((Object)$this$modifyModuleEntity, (String)"$this$modifyModuleEntity");
            $this$modifyModuleEntity.setDependencies($updated);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$ReferencedRootSetChangeListener;", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "<init>", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl;)V", "rootSetChanged", "", "wrapper", "Lcom/intellij/openapi/roots/RootProvider;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleDependencyIndexImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDependencyIndexImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleDependencyIndexImpl$ReferencedRootSetChangeListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1#2:491\n*E\n"})
    private final class ReferencedRootSetChangeListener
    implements RootProvider.RootSetChangedListener {
        public void rootSetChanged(@NotNull RootProvider wrapper) {
            Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
            if (wrapper instanceof Library) {
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedLibraryChanged((Library)wrapper);
            } else {
                RootProvider value;
                if (wrapper instanceof Sdk) {
                    v0 = wrapper;
                } else {
                    if (!(wrapper instanceof Supplier)) {
                        boolean bl = false;
                        String string = "Unexpected root provider " + wrapper + " does not implement Supplier<Sdk>";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Object t = ((Supplier)wrapper).get();
                    Intrinsics.checkNotNull(t);
                    v0 = value = t;
                }
                if (!(value instanceof Sdk)) {
                    boolean bl = false;
                    String string = "Unexpected root provider " + wrapper + " does not implement Supplier<Sdk>";
                    throw new IllegalArgumentException(string.toString());
                }
                ((ModuleDependencyListener)ModuleDependencyIndexImpl.this.eventDispatcher.getMulticaster()).referencedSdkChanged((Sdk)value);
            }
        }
    }
}

