/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Query;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectoryIndexImpl
extends DirectoryIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final WorkspaceFileIndexEx myWorkspaceFileIndex;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;

    public DirectoryIndexImpl(@NotNull Project project, @NotNull RootIndex rootIndex, @NotNull WorkspaceFileIndexEx workspaceFileIndex) {
        if (project == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(0);
        }
        if (rootIndex == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(1);
        }
        if (workspaceFileIndex == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(2);
        }
        this.myWorkspaceFileIndex = workspaceFileIndex;
        this.myProject = project;
        this.myRootIndex = rootIndex;
    }

    public DirectoryIndexImpl(@NotNull Project project) {
        if (project == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(3);
        }
        this.myWorkspaceFileIndex = (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(project);
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                RootIndex rootIndex;
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((rootIndex = DirectoryIndexImpl.this.myRootIndex) != null && DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    for (VFileEvent vFileEvent : events) {
                        if (!DirectoryIndexImpl.isIgnoredFileCreated(vFileEvent)) continue;
                        DirectoryIndexImpl.this.reset();
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$1", "after"));
            }
        });
    }

    public void dispose() {
        this.myDisposed = true;
        this.myRootIndex = null;
    }

    public static boolean shouldResetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(4);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (!(vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)vFileEvent).isDirectory() : (file = vFileEvent.getFile()) == null || file.isDirectory())) continue;
            return true;
        }
        return false;
    }

    public static boolean isIgnoredFileCreated(@NotNull VFileEvent event) {
        if (event == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(5);
        }
        return event instanceof VFileMoveEvent && FileTypeRegistry.getInstance().isFileIgnored(((VFileMoveEvent)event).getNewParent()) || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name") && FileTypeRegistry.getInstance().isFileIgnored(((VFilePropertyChangeEvent)event).getFile());
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(6);
        }
        Query<VirtualFile> query = this.myWorkspaceFileIndex.getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(7);
        }
        return query;
    }

    @NotNull
    @ApiStatus.Internal
    public RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject);
        }
        RootIndex rootIndex2 = rootIndex;
        if (rootIndex2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(8);
        }
        return rootIndex2;
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(9);
        }
        this.checkAvailability();
        if (this.myProject.isDefault()) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        WorkspaceFileInternalInfo fileInfo = this.myWorkspaceFileIndex.getFileInfo(fileOrDir, true, true, true, true, true, false);
        WorkspaceFileSetWithCustomData<?> fileSet = fileInfo.findFileSet(data -> true);
        if (fileSet == null) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<OrderEntry> list = this.getRootIndex().getOrderEntries(fileSet.getRoot());
        if (list == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(13);
        }
        this.checkAvailability();
        Set<String> set = this.getRootIndex().getDependentUnloadedModules(module);
        if (set == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    private void checkAvailability() {
        ThreadingAssertions.assertReadAccess();
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + String.valueOf(this.myProject));
        }
    }

    @ApiStatus.Internal
    public void reset() {
        this.myRootIndex = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFileIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetOnEvents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFileCreated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 11, 12, 14 -> new IllegalStateException(string);
        };
    }
}

