/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import com.intellij.openapi.roots.impl.ProjectRootManagerImplKt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ProjectSettingsEntity;
import com.intellij.platform.workspace.jps.entities.ProjectSettingsEntityBuilder;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.WsmProjectSettingsEntityUtils;
import com.intellij.workspaceModel.ide.WsmSingletonEntityUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="ProjectRootManager")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 c2\u00020\u0001:\u0002cdB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0007J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0017\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020&0%H\u0017\u00a2\u0006\u0002\u0010'J\"\u0010)\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010,0+H\u0017J\b\u0010-\u001a\u00020.H\u0017J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f00H\u0017J\u0013\u00101\u001a\b\u0012\u0004\u0012\u00020&0%H\u0017\u00a2\u0006\u0002\u0010'J\n\u00102\u001a\u0004\u0018\u000103H\u0007J\n\u00104\u001a\u0004\u0018\u00010#H\u0017J\n\u00105\u001a\u0004\u0018\u00010#H\u0017J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000103H\u0017J\u0006\u00109\u001a\u000207J\b\u0010:\u001a\u000207H\u0002J\u0018\u0010?\u001a\u0002072\u0006\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020#H\u0017J\u001c\u0010B\u001a\u0002072\b\u0010@\u001a\u0004\u0018\u00010#2\b\u0010A\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010C\u001a\u0002072\u0006\u0010D\u001a\u00020\nH\u0016J\u0010\u0010E\u001a\u0002072\u0006\u0010D\u001a\u00020\nH\u0016J\u0010\u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020<H\u0017J\b\u0010H\u001a\u000207H\u0015J\b\u0010I\u001a\u000207H\u0017J \u0010J\u001a\u0002072\u0006\u0010G\u001a\u00020<2\u0006\u0010K\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020\u001aH\u0017J\u0018\u0010J\u001a\u0002072\u0006\u0010G\u001a\u00020<2\u0006\u0010M\u001a\u00020\u0015H\u0016J\u0014\u0010N\u001a\u00060Oj\u0002`P2\u0006\u0010M\u001a\u00020\u0015H\u0016J\u0010\u0010Q\u001a\u00020\u00102\u0006\u0010R\u001a\u00020\u000fH\u0016J\u0010\u0010X\u001a\u0002072\u0006\u0010K\u001a\u00020\u001aH\u0002J\u0010\u0010Y\u001a\u0002072\u0006\u0010K\u001a\u00020\u001aH\u0015J\u001e\u0010Z\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020\u001a2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00150\"H\u0002J\u001e\u0010\\\u001a\u0002072\u0006\u0010K\u001a\u00020\u001a2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00150\"H\u0015J\u0010\u0010]\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0015J\u000e\u0010b\u001a\b\u0012\u0004\u0012\u00020&0\"H\u0017R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00160\u0014R\u00020\u00008\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0014R\u00020\u00008\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00020\u001c8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010;\u001a\u00020<8UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R&\u0010T\u001a\u00020\u001a2\u0006\u0010S\u001a\u00020\u001a8\u0006@DX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0014\u0010^\u001a\u00020_8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010a\u00a8\u0006e"}, d2={"Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl;", "Lcom/intellij/openapi/roots/ex/ProjectRootManagerEx;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "projectJdkEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/roots/ex/ProjectRootManagerEx$ProjectJdkListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "moduleRootManagerInstances", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/roots/ModuleRootManager;", "rootCache", "Lcom/intellij/openapi/roots/impl/OrderRootsCache;", "rootsChanged", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl$BatchSession;", "Lcom/intellij/openapi/project/RootsChangeRescanningInfo;", "", "getRootsChanged", "()Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl$BatchSession;", "fileTypesChanged", "", "rootsValidityChangedListener", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "getRootsValidityChangedListener", "()Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "getFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "getContentRootUrls", "", "", "getContentRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getContentSourceRoots", "getModuleSourceRoots", "rootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "orderEntries", "Lcom/intellij/openapi/roots/OrderEnumerator;", "modules", "", "getContentRootsFromAllModules", "getProjectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getProjectSdkName", "getProjectSdkTypeName", "setProjectSdk", "", "sdk", "projectJdkChanged", "fireJdkChanged", "actionToRunWhenProjectJdkChanges", "Ljava/lang/Runnable;", "getActionToRunWhenProjectJdkChanges", "()Ljava/lang/Runnable;", "setProjectSdkName", "name", "sdkTypeName", "setOrClearProjectSdkName", "addProjectJdkListener", "listener", "removeProjectJdkListener", "mergeRootsChangesDuring", "runnable", "clearScopesCaches", "clearScopesCachesForModules", "makeRootsChange", "fileTypes", "fireEvents", "changes", "withRootsChange", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "getModuleRootManager", "module", "value", "isFiringEvent", "()Z", "setFiringEvent", "(Z)V", "fireBeforeRootsChanged", "fireBeforeRootsChangeEvent", "fireRootsChanged", "indexingInfos", "fireRootsChangedEvent", "getOrderRootsCache", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "getModuleManager", "()Lcom/intellij/openapi/module/ModuleManager;", "markRootsForRefresh", "Companion", "BatchSession", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
public class ProjectRootManagerImpl
extends ProjectRootManagerEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Project project;
    @JvmField
    @NotNull
    protected final CoroutineScope coroutineScope;
    @NotNull
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> projectJdkEventDispatcher;
    @NotNull
    private final ConcurrentHashMap<Module, ModuleRootManager> moduleRootManagerInstances;
    @NotNull
    private final OrderRootsCache rootCache;
    @NotNull
    private final BatchSession<RootsChangeRescanningInfo, List<RootsChangeRescanningInfo>> rootsChanged;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public final BatchSession<Boolean, Boolean> fileTypesChanged;
    @ApiStatus.Internal
    @NotNull
    private final VirtualFilePointerListener rootsValidityChangedListener;
    @ApiStatus.Internal
    private boolean isFiringEvent;

    public ProjectRootManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        EventDispatcher eventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.projectJdkEventDispatcher = eventDispatcher;
        this.moduleRootManagerInstances = new ConcurrentHashMap();
        this.rootCache = this.getOrderRootsCache(this.project);
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().simpleConnect();
        Topic topic = ProjectJdkTable.JDK_TABLE_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"JDK_TABLE_TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ProjectJdkTable.Listener(){

            public void jdkNameChanged(Sdk jdk, String previousName) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
                String currentName = this.getProjectSdkName();
                if (Intrinsics.areEqual((Object)previousName, (Object)currentName)) {
                    WorkspaceModelKt.getWorkspaceModel((Project)project).updateProjectModel("jdkNameChanged", arg_0 -> 1.jdkNameChanged$lambda$0(this, jdk, arg_0));
                }
            }

            private static final Unit jdkNameChanged$lambda$0(ProjectRootManagerImpl this$0, Sdk $jdk, MutableEntityStorage mutableStorage) {
                Intrinsics.checkNotNullParameter((Object)mutableStorage, (String)"mutableStorage");
                WsmProjectSettingsEntityUtils.INSTANCE.addOrModifyProjectSettingsEntity(this$0.project, mutableStorage, (Function1<? super ProjectSettingsEntityBuilder, Unit>)((Function1)arg_0 -> 1.jdkNameChanged$lambda$0$0($jdk, arg_0)));
                return Unit.INSTANCE;
            }

            private static final Unit jdkNameChanged$lambda$0$0(Sdk $jdk, ProjectSettingsEntityBuilder entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                String string = $jdk.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = $jdk.getSdkType().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                entity.setProjectSdk(new SdkId(string, string2));
                return Unit.INSTANCE;
            }
        });
        SimpleMessageBusConnection simpleMessageBusConnection2 = this.project.getMessageBus().simpleConnect();
        Topic topic2 = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        simpleMessageBusConnection2.subscribe(topic2, (Object)new ModuleListener(){

            public void moduleRemoved(Project project, Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                moduleRootManagerInstances.remove(module);
            }
        });
        this.rootsChanged = new BatchSession<RootsChangeRescanningInfo, List<RootsChangeRescanningInfo>>(this){
            final /* synthetic */ ProjectRootManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(false);
            }

            protected boolean fireRootsChanged(List<RootsChangeRescanningInfo> change) {
                Intrinsics.checkNotNullParameter(change, (String)"change");
                return ProjectRootManagerImpl.access$fireRootsChanged(this.this$0, false, change);
            }

            protected List<RootsChangeRescanningInfo> accumulate(List<RootsChangeRescanningInfo> current, RootsChangeRescanningInfo change) {
                Intrinsics.checkNotNullParameter(current, (String)"current");
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                current.add(change);
                return current;
            }

            protected RootsChangeRescanningInfo getGenericChange() {
                RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.TOTAL_RESCAN;
                Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"TOTAL_RESCAN");
                return rootsChangeRescanningInfo;
            }

            protected SmartList<RootsChangeRescanningInfo> initiateChangelist(RootsChangeRescanningInfo change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                return new SmartList((Object)change);
            }

            protected List<RootsChangeRescanningInfo> copy(List<RootsChangeRescanningInfo> changes) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                return new ArrayList<E>(changes);
            }
        };
        this.fileTypesChanged = new BatchSession<Boolean, Boolean>(this){
            final /* synthetic */ ProjectRootManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(true);
            }

            protected boolean fireRootsChanged(boolean change) {
                return ProjectRootManagerImpl.access$fireRootsChanged(this.this$0, true, CollectionsKt.emptyList());
            }

            protected Boolean accumulate(boolean current, boolean change) {
                return current || change;
            }

            protected Boolean getGenericChange() {
                return true;
            }

            protected Boolean initiateChangelist(boolean change) {
                return change;
            }

            protected Boolean copy(boolean changes) {
                return changes;
            }
        };
        this.rootsValidityChangedListener = new VirtualFilePointerListener(){};
    }

    @ApiStatus.Internal
    @NotNull
    public final BatchSession<RootsChangeRescanningInfo, List<RootsChangeRescanningInfo>> getRootsChanged() {
        return this.rootsChanged;
    }

    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        return this.rootsValidityChangedListener;
    }

    @NotNull
    public final ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        return projectFileIndex;
    }

    @ApiStatus.Internal
    @NotNull
    public final List<String> getContentRootUrls() {
        Module[] modules = this.getModuleManager().getModules();
        ArrayList result = new ArrayList(modules.length);
        for (Module module : modules) {
            Collection collection = result;
            String[] stringArray = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getContentRootUrls(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])stringArray);
        }
        return result;
    }

    @ApiStatus.Internal
    @NotNull
    public VirtualFile[] getContentRoots() {
        Module[] modules = this.getModuleManager().getModules();
        ArrayList result = new ArrayList(modules.length);
        int n = modules.length;
        for (int i = 0; i < n; ++i) {
            Object[] contentRoots;
            Module module = modules[i];
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module).getContentRoots(), (String)"getContentRoots(...)");
            if (modules.length == 1) {
                return contentRoots;
            }
            CollectionsKt.addAll((Collection)result, (Object[])contentRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
        return virtualFileArray;
    }

    @ApiStatus.Internal
    @NotNull
    public VirtualFile[] getContentSourceRoots() {
        Module[] modules = this.getModuleManager().getModules();
        ArrayList result = new ArrayList(modules.length);
        for (Module module : modules) {
            Collection collection = result;
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])virtualFileArray);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
        return virtualFileArray;
    }

    @ApiStatus.Internal
    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        Intrinsics.checkNotNullParameter(rootTypes, (String)"rootTypes");
        Module[] modules = this.getModuleManager().getModules();
        ArrayList roots = new ArrayList(modules.length);
        for (Module module : modules) {
            roots.addAll(ModuleRootManager.getInstance((Module)module).getSourceRoots(rootTypes));
        }
        return roots;
    }

    @ApiStatus.Internal
    @NotNull
    public OrderEnumerator orderEntries() {
        return new ProjectOrderEnumerator(this.project, this.rootCache);
    }

    @ApiStatus.Internal
    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        return new ModulesOrderEnumerator(this.project, modules);
    }

    @ApiStatus.Internal
    @NotNull
    public VirtualFile[] getContentRootsFromAllModules() {
        Module[] modules = this.getModuleManager().getSortedModules();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(modules.length + 1);
        for (Module module : modules) {
            Collection collection = result;
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])virtualFileArray);
        }
        VirtualFile virtualFile = this.project.getBaseDir();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            result.add(it);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"toVirtualFileArray(...)");
        return virtualFileArray;
    }

    @ApiStatus.Internal
    @Nullable
    public final Sdk getProjectSdk() {
        String sdkName = this.getProjectSdkName();
        if (sdkName == null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"getInstance(...)");
        ProjectJdkTable projectJdkTable2 = projectJdkTable;
        String sdkType = this.getProjectSdkTypeName();
        return sdkType == null ? projectJdkTable2.findJdk(sdkName) : projectJdkTable2.findJdk(sdkName, sdkType);
    }

    @ApiStatus.Internal
    @Nullable
    public String getProjectSdkName() {
        ProjectSettingsEntity settings = WsmSingletonEntityUtils.INSTANCE.getSingleEntity((EntityStorage)WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot(), ProjectSettingsEntity.class);
        ProjectSettingsEntity projectSettingsEntity = settings;
        return projectSettingsEntity != null && (projectSettingsEntity = projectSettingsEntity.getProjectSdk()) != null ? projectSettingsEntity.getName() : null;
    }

    @ApiStatus.Internal
    @Nullable
    public String getProjectSdkTypeName() {
        ProjectSettingsEntity settings = WsmSingletonEntityUtils.INSTANCE.getSingleEntity((EntityStorage)WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot(), ProjectSettingsEntity.class);
        ProjectSettingsEntity projectSettingsEntity = settings;
        return projectSettingsEntity != null && (projectSettingsEntity = projectSettingsEntity.getProjectSdk()) != null ? projectSettingsEntity.getType() : null;
    }

    @ApiStatus.Internal
    @RequiresWriteLock(generateAssertion=false)
    public void setProjectSdk(@Nullable Sdk sdk) {
        if (sdk == null) {
            this.setOrClearProjectSdkName(null, null);
        } else {
            this.setOrClearProjectSdkName(sdk.getName(), sdk.getSdkType().getName());
        }
    }

    public final void projectJdkChanged() {
        this.incModificationCount();
        this.getActionToRunWhenProjectJdkChanges().run();
        this.fireJdkChanged();
    }

    private final void fireJdkChanged() {
        Sdk sdk = this.getProjectSdk();
        for (ProjectExtension extension : ProjectRootManagerImplKt.access$getEP_NAME$p().getExtensions((AreaInstance)this.project)) {
            extension.projectSdkChanged(sdk);
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected Runnable getActionToRunWhenProjectJdkChanges() {
        return () -> ProjectRootManagerImpl._get_actionToRunWhenProjectJdkChanges_$lambda$0(this);
    }

    @ApiStatus.Internal
    @RequiresWriteLock(generateAssertion=false)
    public void setProjectSdkName(@NotNull String name, @NotNull String sdkTypeName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sdkTypeName, (String)"sdkTypeName");
        this.setOrClearProjectSdkName(name, sdkTypeName);
    }

    private final void setOrClearProjectSdkName(String name, String sdkTypeName) {
        ThreadingAssertions.assertWriteAccess();
        SdkId newSdk = name != null && sdkTypeName != null ? new SdkId(name, sdkTypeName) : null;
        WorkspaceModelKt.getWorkspaceModel((Project)this.project).updateProjectModel("setOrClearProjectSdkName", arg_0 -> ProjectRootManagerImpl.setOrClearProjectSdkName$lambda$0(this, newSdk, arg_0));
    }

    public void addProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.projectJdkEventDispatcher.addListener((EventListener)listener);
    }

    public void removeProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.projectJdkEventDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void mergeRootsChangesDuring(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        BatchSession<RootsChangeRescanningInfo, List<RootsChangeRescanningInfo>> batchSession = this.rootsChanged;
        batchSession.levelUp();
        try {
            runnable.run();
        }
        finally {
            batchSession.levelDown();
        }
    }

    @ApiStatus.Internal
    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    @ApiStatus.Internal
    public void clearScopesCachesForModules() {
        this.rootCache.clearCache();
        for (Module module : ModuleManager.Companion.getInstance(this.project).getModules()) {
            ModuleRootManagerEx.getInstanceEx(module).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="")
    public void makeRootsChange(@NotNull Runnable runnable, boolean fileTypes, boolean fireEvents) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (this.project.isDisposed()) {
            return;
        }
        BatchSession<Boolean, Object> session = fileTypes ? this.fileTypesChanged : this.rootsChanged;
        try {
            if (fireEvents) {
                session.beforeRootsChanged();
            }
            runnable.run();
        }
        finally {
            if (fireEvents) {
                BatchSession.rootsChanged$default(session, null, 1, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRootsChange(@NotNull Runnable runnable, @NotNull RootsChangeRescanningInfo changes) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        if (this.project.isDisposed()) {
            return;
        }
        try {
            this.rootsChanged.beforeRootsChanged();
            runnable.run();
        }
        finally {
            this.rootsChanged.rootsChanged(changes);
        }
    }

    @NotNull
    public AutoCloseable withRootsChange(@NotNull RootsChangeRescanningInfo changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        this.rootsChanged.beforeRootsChanged();
        return () -> ProjectRootManagerImpl.withRootsChange$lambda$0(this, changes);
    }

    @NotNull
    public ModuleRootManager getModuleRootManager(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = this.moduleRootManagerInstances.computeIfAbsent(module, arg_0 -> ProjectRootManagerImpl.getModuleRootManager$lambda$1(arg_0 -> ProjectRootManagerImpl.getModuleRootManager$lambda$0(module, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"computeIfAbsent(...)");
        return moduleRootManager;
    }

    public final boolean isFiringEvent() {
        return this.isFiringEvent;
    }

    protected final void setFiringEvent(boolean bl) {
        this.isFiringEvent = bl;
    }

    private final void fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ProjectRootManagerImplKt.access$getLOG$p().assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        this.fireBeforeRootsChangeEvent(fileTypes);
    }

    @ApiStatus.Internal
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private final boolean fireRootsChanged(boolean fileTypes, List<? extends RootsChangeRescanningInfo> indexingInfos) {
        if (this.project.isDisposed()) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ProjectRootManagerImplKt.access$getLOG$p().assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        this.clearScopesCaches();
        this.incModificationCount();
        this.fireRootsChangedEvent(fileTypes, indexingInfos);
        return true;
    }

    @ApiStatus.Internal
    protected void fireRootsChangedEvent(boolean fileTypes, @NotNull List<? extends RootsChangeRescanningInfo> indexingInfos) {
        Intrinsics.checkNotNullParameter(indexingInfos, (String)"indexingInfos");
    }

    @ApiStatus.Internal
    @NotNull
    protected OrderRootsCache getOrderRootsCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new OrderRootsCache((Disposable)project);
    }

    private final ModuleManager getModuleManager() {
        return ModuleManager.Companion.getInstance(this.project);
    }

    @ApiStatus.Internal
    @NotNull
    public List<VirtualFile> markRootsForRefresh() {
        return CollectionsKt.emptyList();
    }

    private static final void _get_actionToRunWhenProjectJdkChanges_$lambda$0(ProjectRootManagerImpl this$0) {
        ((ProjectRootManagerEx.ProjectJdkListener)this$0.projectJdkEventDispatcher.getMulticaster()).projectJdkChanged();
    }

    private static final Unit setOrClearProjectSdkName$lambda$0(ProjectRootManagerImpl this$0, SdkId $newSdk, MutableEntityStorage mutableStorage) {
        Intrinsics.checkNotNullParameter((Object)mutableStorage, (String)"mutableStorage");
        WsmProjectSettingsEntityUtils.INSTANCE.addOrModifyProjectSettingsEntity(this$0.project, mutableStorage, (Function1<? super ProjectSettingsEntityBuilder, Unit>)((Function1)arg_0 -> ProjectRootManagerImpl.setOrClearProjectSdkName$lambda$0$0($newSdk, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit setOrClearProjectSdkName$lambda$0$0(SdkId $newSdk, ProjectSettingsEntityBuilder entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.setProjectSdk($newSdk);
        return Unit.INSTANCE;
    }

    private static final void withRootsChange$lambda$0(ProjectRootManagerImpl this$0, RootsChangeRescanningInfo $changes) {
        this$0.rootsChanged.rootsChanged($changes);
    }

    private static final ModuleRootManager getModuleRootManager$lambda$0(Module $module, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ModuleRootComponentBridge($module);
    }

    private static final ModuleRootManager getModuleRootManager$lambda$1(Function1 $tmp0, Object p0) {
        return (ModuleRootManager)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final ProjectRootManagerImpl getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    public static final /* synthetic */ boolean access$fireRootsChanged(ProjectRootManagerImpl $this, boolean fileTypes, List indexingInfos) {
        return $this.fireRootsChanged(fileTypes, indexingInfos);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u00a7\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0017\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00028\u0001H%\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0000H%\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0000H%\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u00012\u0006\u0010\f\u001a\u00028\u0001H%\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u001d\u001a\u00028\u00008%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl$BatchSession;", "Change", "ChangeList", "", "fileTypes", "", "<init>", "(Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl;Z)V", "batchLevel", "", "pendingRootsChanged", "isChanged", "changes", "Ljava/lang/Object;", "levelUp", "", "levelDown", "beforeRootsChanged", "rootsChanged", "change", "(Ljava/lang/Object;)V", "fireRootsChanged", "(Ljava/lang/Object;)Z", "initiateChangelist", "(Ljava/lang/Object;)Ljava/lang/Object;", "accumulate", "current", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "copy", "genericChange", "getGenericChange", "()Ljava/lang/Object;", "intellij.platform.projectModel.impl"})
    @ApiStatus.Internal
    public abstract class BatchSession<Change, ChangeList> {
        private final boolean fileTypes;
        private int batchLevel;
        private int pendingRootsChanged;
        private boolean isChanged;
        @Nullable
        private ChangeList changes;

        public BatchSession(boolean fileTypes) {
            this.fileTypes = fileTypes;
        }

        public final void levelUp() {
            if (this.batchLevel == 0) {
                this.isChanged = false;
                this.changes = null;
            }
            ++this.batchLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void levelDown() {
            --this.batchLevel;
            if (this.isChanged && this.batchLevel == 0) {
                try {
                    if (this.changes == null) {
                        this.changes = this.initiateChangelist(this.getGenericChange());
                    }
                    int n = this.pendingRootsChanged;
                    this.pendingRootsChanged = n + -1;
                    ApplicationManager.getApplication().runWriteAction(() -> BatchSession.levelDown$lambda$0(this));
                }
                finally {
                    if (this.pendingRootsChanged == 0) {
                        this.isChanged = false;
                        this.changes = null;
                    }
                }
            }
        }

        public final void beforeRootsChanged() {
            if (this.batchLevel == 0 || !this.isChanged) {
                ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.fileTypes);
                int n = this.pendingRootsChanged;
                this.pendingRootsChanged = n + 1;
                this.isChanged = true;
            }
        }

        @JvmOverloads
        public final void rootsChanged(Change change) {
            if (this.changes == null) {
                v0 = this.initiateChangelist(change);
            } else {
                ChangeList ChangeList = this.changes;
                Intrinsics.checkNotNull(ChangeList);
                v0 = this.changes = this.accumulate(ChangeList, change);
            }
            if (this.batchLevel == 0 && this.isChanged) {
                int n = this.pendingRootsChanged;
                this.pendingRootsChanged = n + -1;
                ChangeList ChangeList = this.changes;
                Intrinsics.checkNotNull(ChangeList);
                if (this.fireRootsChanged(this.copy(ChangeList)) && this.pendingRootsChanged == 0) {
                    this.isChanged = false;
                    this.changes = null;
                }
            }
        }

        public static /* synthetic */ void rootsChanged$default(BatchSession batchSession, Object object, int n, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rootsChanged");
            }
            if ((n & 1) != 0) {
                object = batchSession.getGenericChange();
            }
            batchSession.rootsChanged(object);
        }

        @ApiStatus.Internal
        protected abstract boolean fireRootsChanged(ChangeList var1);

        @ApiStatus.Internal
        protected abstract ChangeList initiateChangelist(Change var1);

        @ApiStatus.Internal
        protected abstract ChangeList accumulate(ChangeList var1, Change var2);

        @ApiStatus.Internal
        protected abstract ChangeList copy(ChangeList var1);

        @ApiStatus.Internal
        protected abstract Change getGenericChange();

        @JvmOverloads
        public final void rootsChanged() {
            BatchSession.rootsChanged$default(this, null, 1, null);
        }

        private static final void levelDown$lambda$0(BatchSession this$0) {
            Object ChangeList = this$0.changes;
            Intrinsics.checkNotNull(ChangeList);
            this$0.fireRootsChanged(this$0.copy(ChangeList));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl$Companion;", "", "<init>", "()V", "getInstanceImpl", "Lcom/intellij/openapi/roots/impl/ProjectRootManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "extractLocalPath", "", "url", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectRootManagerImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProjectRootManager projectRootManager = ProjectRootManagerEx.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)projectRootManager, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.ProjectRootManagerImpl");
            return (ProjectRootManagerImpl)projectRootManager;
        }

        @ApiStatus.Internal
        @NotNull
        public final String extractLocalPath(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = URLUtil.extractPath((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractPath(...)");
            String path = string;
            int separatorIndex = StringsKt.indexOf$default((CharSequence)path, (String)"!/", (int)0, (boolean)false, (int)6, null);
            return separatorIndex > 0 ? StringsKt.take((String)path, (int)separatorIndex) : path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

