/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.LibraryTypeId;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeModifiableBase;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryOrigin;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectModifiableLibraryTableBridgeImplKt;
import com.intellij.workspaceModel.ide.legacyBridge.LegacyBridgeJpsEntitySourceFactory;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectModifiableLibraryTableBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0006\b\u0000\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J(\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e\u0018\u00010\u001dH\u0016J2\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0016J\b\u0010$\u001a\u00020\"H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0013\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010+\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectModifiableLibraryTableBridgeImpl;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeModifiableBase;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ProjectModifiableLibraryTableBridge;", "originalStorage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "libraryTable", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl;", "project", "Lcom/intellij/openapi/project/Project;", "diff", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "cacheStorageResult", "", "<init>", "(Lcom/intellij/platform/workspace/storage/EntityStorage;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Z)V", "myAddedLibraries", "", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridgeImpl;", "librariesArrayValue", "Lcom/intellij/platform/workspace/storage/CachedValue;", "", "Lcom/intellij/openapi/roots/libraries/Library;", "librariesArray", "getLibrariesArray", "()[Lcom/intellij/openapi/roots/libraries/Library;", "createLibrary", "name", "", "type", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "removeLibrary", "", "library", "commit", "prepareForCommit", "getLibraryIterator", "", "getLibraryByName", "getLibraries", "dispose", "isChanged", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nProjectModifiableLibraryTableBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModifiableLibraryTableBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectModifiableLibraryTableBridgeImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,162:1\n13805#2,2:163\n13805#2,2:169\n1869#3,2:165\n1869#3,2:167\n37#4,2:171\n1#5:173\n13#6:174\n*S KotlinDebug\n*F\n+ 1 ProjectModifiableLibraryTableBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectModifiableLibraryTableBridgeImpl\n*L\n112#1:163,2\n144#1:169,2\n119#1:165,2\n142#1:167,2\n40#1:171,2\n151#1:174\n*E\n"})
public final class ProjectModifiableLibraryTableBridgeImpl
extends LegacyBridgeModifiableBase
implements ProjectModifiableLibraryTableBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectLibraryTableBridgeImpl libraryTable;
    @NotNull
    private final Project project;
    @NotNull
    private final List<LibraryBridgeImpl> myAddedLibraries;
    @NotNull
    private final CachedValue<Library[]> librariesArrayValue;
    @NotNull
    private static final Logger LOG;

    public ProjectModifiableLibraryTableBridgeImpl(@NotNull EntityStorage originalStorage, @NotNull ProjectLibraryTableBridgeImpl libraryTable, @NotNull Project project, @NotNull MutableEntityStorage diff, boolean cacheStorageResult) {
        Intrinsics.checkNotNullParameter((Object)originalStorage, (String)"originalStorage");
        Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        super(diff, cacheStorageResult);
        this.libraryTable = libraryTable;
        this.project = project;
        this.myAddedLibraries = new ArrayList();
        this.librariesArrayValue = new CachedValue(ProjectModifiableLibraryTableBridgeImpl::librariesArrayValue$lambda$0);
    }

    public /* synthetic */ ProjectModifiableLibraryTableBridgeImpl(EntityStorage entityStorage, ProjectLibraryTableBridgeImpl projectLibraryTableBridgeImpl, Project project, MutableEntityStorage mutableEntityStorage, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            mutableEntityStorage = MutableEntityStorage.Companion.from(ProjectModifiableLibraryTableBridgeImplKt.access$toSnapshot(entityStorage));
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(entityStorage, projectLibraryTableBridgeImpl, project, mutableEntityStorage, bl);
    }

    private final Library[] getLibrariesArray() {
        return (Library[])this.getEntityStorageOnDiff().cachedValue(this.librariesArrayValue);
    }

    @NotNull
    public Library createLibrary(@Nullable String name) {
        return this.createLibrary(name, null);
    }

    @NotNull
    public Library createLibrary(@Nullable String name, @Nullable PersistentLibraryKind<? extends LibraryProperties<?>> type) {
        return this.createLibrary(name, type, null);
    }

    @NotNull
    public Library createLibrary(@Nullable String name, @Nullable PersistentLibraryKind<? extends LibraryProperties<?>> type, @Nullable ProjectModelExternalSource externalSource) {
        LibraryEntity libraryEntity;
        CharSequence charSequence = name;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new IllegalStateException("Project Library must have a name".toString());
        }
        this.assertModelIsLive();
        LibraryTableId.ProjectLibraryTableId libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
        LibraryId libraryId = new LibraryId(name, (LibraryTableId)libraryTableId);
        if (this.getDiff().contains((SymbolicEntityId)libraryId)) {
            LOG.error("Project library with name '" + name + "' already exists.");
        }
        LibraryEntityBuilder libraryEntity2 = LibraryEntityModifications.createLibraryEntity((String)name, (LibraryTableId)((LibraryTableId)libraryTableId), (List)CollectionsKt.emptyList(), (EntitySource)LegacyBridgeJpsEntitySourceFactory.Companion.getInstance(this.project).createEntitySourceForProjectLibrary(externalSource), arg_0 -> ProjectModifiableLibraryTableBridgeImpl.createLibrary$lambda$0(type, arg_0));
        if (type != null) {
            LibraryEntityModifications.setLibraryProperties((LibraryEntityBuilder)libraryEntity2, (LibraryPropertiesEntityBuilder)LibraryPropertiesEntityModifications.createLibraryPropertiesEntity((EntitySource)libraryEntity2.getEntitySource(), arg_0 -> ProjectModifiableLibraryTableBridgeImpl.createLibrary$lambda$1(type, arg_0)));
            libraryEntity = (LibraryEntity)this.getDiff().addEntity((WorkspaceEntity.Builder)libraryEntity2);
        } else {
            libraryEntity = (LibraryEntity)this.getDiff().addEntity((WorkspaceEntity.Builder)libraryEntity2);
        }
        LibraryEntity addedEntity = libraryEntity;
        LibraryBridgeImpl library = new LibraryBridgeImpl(this.libraryTable, new LibraryOrigin.OfProject(this.project), libraryId, this.getEntityStorageOnDiff(), this.getDiff());
        this.myAddedLibraries.add(library);
        ProjectLibraryTableBridgeImpl.Companion.getMutableLibraryMap(this.getDiff()).addMapping((WorkspaceEntity)addedEntity, (Object)library);
        return (Library)library;
    }

    public void removeLibrary(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.assertModelIsLive();
        LibraryEntity libraryEntity = ProjectLibraryTableBridgeImpl.Companion.findLibraryEntity(this.getEntityStorageOnDiff().getCurrent(), (LibraryBridge)library);
        if (libraryEntity != null) {
            ((LibraryBridgeImpl)library).clearTargetBuilder();
            this.getDiff().removeEntity((WorkspaceEntity)libraryEntity);
            if (this.myAddedLibraries.remove(library)) {
                Disposer.dispose((Disposable)((Disposable)library));
            }
        }
    }

    public void commit() {
        this.prepareForCommit();
        WorkspaceModel.Companion.getInstance(this.project).updateProjectModel("Project library table commit", arg_0 -> ProjectModifiableLibraryTableBridgeImpl.commit$lambda$0(this, arg_0));
        Library[] $this$forEach$iv = this.getLibrariesArray();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Library element$iv;
            Library library = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl");
            ((LibraryBridgeImpl)library).clearTargetBuilder();
        }
    }

    @Override
    public void prepareForCommit() {
        this.assertModelIsLive();
        this.setModelIsCommittedOrDisposed(true);
        ImmutableEntityStorage storage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        Iterable $this$forEach$iv = this.myAddedLibraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryBridgeImpl library = (LibraryBridgeImpl)element$iv;
            boolean bl = false;
            if (storage.contains((SymbolicEntityId)library.getLibraryId())) {
                this.getDiff().removeEntity((WorkspaceEntity)SequencesKt.first((Sequence)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)this.getDiff()).getEntities((Object)library)));
                Disposer.dispose((Disposable)library);
            }
            library.clearTargetBuilder();
        }
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        return ArrayIteratorKt.iterator((Object[])this.getLibrariesArray());
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LibraryEntity libraryEntity = (LibraryEntity)this.getDiff().resolve((SymbolicEntityId)new LibraryId(name, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE));
        if (libraryEntity == null) {
            return null;
        }
        LibraryEntity libraryEntity2 = libraryEntity;
        return (Library)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)this.getDiff()).getDataByEntity((WorkspaceEntity)libraryEntity2);
    }

    @NotNull
    public Library[] getLibraries() {
        return this.getLibrariesArray();
    }

    public void dispose() {
        this.setModelIsCommittedOrDisposed(true);
        Library[] $this$forEach$iv = (Library[])this.myAddedLibraries;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            LibraryBridgeImpl it = (LibraryBridgeImpl)t;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.myAddedLibraries.clear();
        $this$forEach$iv = this.getLibrariesArray();
        $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Library element$iv;
            Library library = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl");
            ((LibraryBridgeImpl)library).clearTargetBuilder();
        }
    }

    public boolean isChanged() {
        MutableEntityStorage mutableEntityStorage = this.getDiff();
        Intrinsics.checkNotNull((Object)mutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        return ((MutableEntityStorageInstrumentation)mutableEntityStorage).hasChanges();
    }

    private static final Library[] librariesArrayValue$lambda$0(EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)storage.entities(LibraryEntity.class), ProjectModifiableLibraryTableBridgeImpl::librariesArrayValue$lambda$0$0), arg_0 -> ProjectModifiableLibraryTableBridgeImpl.librariesArrayValue$lambda$0$1(storage, arg_0)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Library[0]);
    }

    private static final boolean librariesArrayValue$lambda$0$0(LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE);
    }

    private static final LibraryBridge librariesArrayValue$lambda$0$1(EntityStorage $storage, LibraryEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return (LibraryBridge)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap($storage).getDataByEntity((WorkspaceEntity)entity);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createLibrary$lambda$0(PersistentLibraryKind $type, LibraryEntityBuilder $this$LibraryEntity) {
        LibraryTypeId libraryTypeId;
        Intrinsics.checkNotNullParameter((Object)$this$LibraryEntity, (String)"$this$LibraryEntity");
        LibraryEntityBuilder libraryEntityBuilder = $this$LibraryEntity;
        Object object = $type;
        if (object != null && (object = object.getKindId()) != null) {
            void it;
            Object object2 = object;
            LibraryEntityBuilder libraryEntityBuilder2 = libraryEntityBuilder;
            boolean bl = false;
            libraryTypeId = new LibraryTypeId((String)it);
            libraryEntityBuilder = libraryEntityBuilder2;
        } else {
            libraryTypeId = null;
        }
        libraryEntityBuilder.setTypeId(libraryTypeId);
        return Unit.INSTANCE;
    }

    private static final Unit createLibrary$lambda$1(PersistentLibraryKind $type, LibraryPropertiesEntityBuilder $this$LibraryPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$LibraryPropertiesEntity, (String)"$this$LibraryPropertiesEntity");
        $this$LibraryPropertiesEntity.setPropertiesXmlTag(LegacyBridgeModifiableBase.Companion.serializeComponentAsString("properties", (PersistentStateComponent)$type.createDefaultProperties()));
        return Unit.INSTANCE;
    }

    private static final Unit commit$lambda$0(ProjectModifiableLibraryTableBridgeImpl this$0, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.applyChangesFrom(this$0.getDiff());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectModifiableLibraryTableBridgeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectModifiableLibraryTableBridgeImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

