// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
@file:JvmName("ModuleEntityUtils")
package com.intellij.workspaceModel.ide.impl.legacyBridge.module

import com.intellij.platform.workspace.jps.entities.LibraryEntity
import com.intellij.platform.workspace.jps.entities.ModuleEntity
import com.intellij.platform.workspace.storage.EntityStorage
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl.Companion.moduleMap
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge
import org.jetbrains.annotations.ApiStatus
import org.jetbrains.annotations.ApiStatus.Obsolete

/**
 * Use [com.intellij.workspaceModel.ide.legacyBridge.findModule] from API instead.
 */
@Obsolete
@ApiStatus.Internal
fun ModuleEntity.findModule(snapshot: EntityStorage): ModuleBridge? {
  return snapshot.moduleMap.getDataByEntity(this)
}

/**
 * Returns all module-level libraries defined in this module.
 */
fun ModuleEntity.getModuleLevelLibraries(snapshot: EntityStorage): Sequence<LibraryEntity> {
  return snapshot.referrers(symbolicId, LibraryEntity::class.java)
}

/**
 * Return all [ModuleEntity] that has this module as dependency.
 * If [recursive] is true computes dependency graph for this module
 */
@ApiStatus.Internal
fun ModuleEntity.getDependantModules(snapshot: EntityStorage, recursive: Boolean): Collection<ModuleEntity> {
  val firstLevelDependant = snapshot.referrers(symbolicId, ModuleEntity::class.java)
  if (!recursive) {
    return firstLevelDependant.toList()
  }
  val queue = ArrayDeque<ModuleEntity>()
  val result = HashSet<ModuleEntity>()
  firstLevelDependant.toCollection(queue)
  while (queue.isNotEmpty()) {
    val module = queue.removeFirst()
    if (!result.add(module)) {
      continue
    }
    snapshot.referrers(module.symbolicId, ModuleEntity::class.java).toCollection(queue)
  }
  return result
}