/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.multiverse;

import com.intellij.codeInsight.multiverse.ModuleContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/multiverse/ModuleContextImpl;", "Lcom/intellij/codeInsight/multiverse/ModuleContext;", "modulePointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/workspace/storage/EntityPointer;Lcom/intellij/openapi/project/Project;)V", "getModule", "Lcom/intellij/openapi/module/Module;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
public final class ModuleContextImpl
implements ModuleContext {
    @NotNull
    private final EntityPointer<ModuleEntity> modulePointer;
    @NotNull
    private final Project project;

    public ModuleContextImpl(@NotNull EntityPointer<? extends ModuleEntity> modulePointer, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(modulePointer, (String)"modulePointer");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.modulePointer = modulePointer;
        this.project = project;
    }

    @Nullable
    public Module getModule() {
        ImmutableEntityStorage storage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        ModuleEntity moduleEntity = (ModuleEntity)this.modulePointer.resolve((EntityStorage)storage);
        if (moduleEntity == null) {
            return null;
        }
        ModuleEntity entity = moduleEntity;
        return ModuleBridges.findModule(entity, (EntityStorage)storage);
    }

    public boolean equals(@Nullable Object other) {
        ModuleContextImpl moduleContextImpl = other instanceof ModuleContextImpl ? (ModuleContextImpl)other : null;
        return Intrinsics.areEqual(this.modulePointer, moduleContextImpl != null ? moduleContextImpl.modulePointer : null);
    }

    public int hashCode() {
        return this.modulePointer.hashCode();
    }

    @NotNull
    public String toString() {
        return "ModuleContextImpl(modulePointer=" + this.modulePointer + ", project=" + this.project.getName() + ")";
    }
}

