/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u001a\u001b\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a%\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0001\u001a&\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\b\u001a \u0010\u000e\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\b\u001a\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0007\"\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0012\u001a\u00020\b*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"displayUrlRelativeToProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "project", "Lcom/intellij/openapi/project/Project;", "isIncludeFilePath", "", "moduleOnTheLeft", "displayFilePath", "Lcom/intellij/openapi/util/NlsSafe;", "decorateWithLibraryName", "result", "appendModuleName", "module", "Lcom/intellij/openapi/module/Module;", "enableExternalStorageByDefaultInTests", "isExternalStorageEnabled", "(Lcom/intellij/openapi/project/Project;)Z", "doNotEnableExternalStorageByDefaultInTests", "", "action", "Lkotlin/Function0;", "intellij.platform.projectModel"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    private static boolean enableExternalStorageByDefaultInTests = true;

    @NlsSafe
    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file, @NlsSafe @NotNull String url, @NotNull Project project, boolean isIncludeFilePath, boolean moduleOnTheLeft) {
        String urlWithLibraryName;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String result = url;
        if (isIncludeFilePath) {
            result = ProjectUtilCore.displayFilePath(project, result, file);
        }
        if ((urlWithLibraryName = ProjectUtilCore.decorateWithLibraryName(file, project, result)) != null) {
            return urlWithLibraryName;
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return result;
        }
        return ProjectUtilCore.appendModuleName(file, project, result, moduleOnTheLeft);
    }

    @NotNull
    public static final String displayFilePath(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPresentableUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableUrl(...)");
        return ProjectUtilCore.displayFilePath(project, string, file);
    }

    private static final String displayFilePath(Project project, String url, VirtualFile file) {
        Object object;
        String projectHomeUrl = PathUtil.toSystemDependentName((String)project.getBasePath());
        if (projectHomeUrl != null && StringsKt.startsWith$default((String)url, (String)projectHomeUrl, (boolean)false, (int)2, null)) {
            String string = url.substring(projectHomeUrl.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = "\u2026" + string;
        } else {
            String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
        }
        return object;
    }

    @Nullable
    public static final String decorateWithLibraryName(@NotNull VirtualFile file, @NotNull Project project, @NotNull String result) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (Intrinsics.areEqual((Object)file.getFileSystem().getProtocol(), (Object)"jar")) {
            OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file, project);
            if (libraryEntry instanceof JdkOrderEntry) {
                return result + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + "]";
            }
            if (libraryEntry != null) {
                return result + " [" + libraryEntry.getPresentableName() + "]";
            }
        }
        return null;
    }

    @NotNull
    public static final String appendModuleName(@NotNull VirtualFile file, @NotNull Project project, @NotNull String result, boolean moduleOnTheLeft) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Module module = ModuleUtilCore.findModuleForFile(file, project);
        return ProjectUtilCore.appendModuleName(module, result, moduleOnTheLeft);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String appendModuleName(@Nullable Module module, @NotNull String result, boolean moduleOnTheLeft) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (module == null) break block4;
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (ModuleManager.Companion.getInstance(project).getModules().length != 1) break block5;
            }
            object = result;
            return object;
        }
        if (moduleOnTheLeft) {
            object = "[" + module.getName() + "] " + result;
            return object;
        }
        object = result + " [" + module.getName() + "]";
        return object;
    }

    public static final boolean isExternalStorageEnabled(@NotNull Project $this$isExternalStorageEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalStorageEnabled, (String)"<this>");
        String string = $this$isExternalStorageEnabled.getProjectFilePath();
        boolean bl = string != null ? StringsKt.endsWith$default((String)string, (String)".ipr", (boolean)false, (int)2, null) : false;
        if (bl) {
            return false;
        }
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance($this$isExternalStorageEnabled);
        if (externalStorageConfigurationManager == null) {
            return false;
        }
        ExternalStorageConfigurationManager manager = externalStorageConfigurationManager;
        if (manager.isEnabled()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean testMode = application != null ? application.isUnitTestMode() : false;
        return testMode && enableExternalStorageByDefaultInTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static final void doNotEnableExternalStorageByDefaultInTests(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        enableExternalStorageByDefaultInTests = false;
        try {
            action.invoke();
        }
        finally {
            enableExternalStorageByDefaultInTests = true;
        }
    }
}

