/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class ImmutableSyntheticLibrary
extends SyntheticLibrary {
    private final List<VirtualFile> mySourceRoots;
    private final List<VirtualFile> myBinaryRoots;
    private final Set<VirtualFile> myExcludedRoots;
    private final Condition<? super VirtualFile> myExcludeCondition;
    private final int hashCode;

    public ImmutableSyntheticLibrary(@Nullable String comparisonId, @NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition, @Nullable SyntheticLibrary.ExcludeFileCondition constantCondition) {
        if (sourceRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(0);
        }
        if (binaryRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(1);
        }
        if (excludedRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(2);
        }
        super(comparisonId, constantCondition);
        this.mySourceRoots = List.copyOf(sourceRoots);
        this.myBinaryRoots = List.copyOf(binaryRoots);
        this.myExcludedRoots = ContainerUtil.unmodifiableOrEmptySet(excludedRoots);
        this.myExcludeCondition = excludeCondition;
        this.hashCode = 31 * (31 * sourceRoots.hashCode() + binaryRoots.hashCode()) + excludedRoots.hashCode();
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<VirtualFile> getSourceRoots() {
        List<VirtualFile> list = this.mySourceRoots;
        if (list == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list = this.myBinaryRoots;
        if (list == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = this.myExcludedRoots;
        if (set == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @Nullable
    public Condition<? super VirtualFile> getExcludeFileCondition() {
        return this.myExcludeCondition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSyntheticLibrary library = (ImmutableSyntheticLibrary)o;
        if (!Objects.equals(this.getComparisonId(), library.getComparisonId())) {
            return false;
        }
        if (!this.mySourceRoots.equals(library.getSourceRoots())) {
            return false;
        }
        if (!this.myBinaryRoots.equals(library.getBinaryRoots())) {
            return false;
        }
        if (!this.myExcludedRoots.equals(library.getExcludedRoots())) {
            return false;
        }
        return Objects.equals(this.myExcludeCondition, library.getExcludeFileCondition());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

