/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTableProjectViewProvider;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public abstract class ProjectJdkTable {
    @Topic.AppLevel
    public static final Topic<Listener> JDK_TABLE_TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);

    public static ProjectJdkTable getInstance() {
        return (ProjectJdkTable)ApplicationManager.getApplication().getService(ProjectJdkTable.class);
    }

    @ApiStatus.Experimental
    @NotNull
    public static ProjectJdkTable getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectJdkTable.$$$reportNull$$$0(0);
        }
        ProjectJdkTable projectJdkTable = ((SdkTableProjectViewProvider)project.getService(SdkTableProjectViewProvider.class)).getSdkTableView();
        if (projectJdkTable == null) {
            ProjectJdkTable.$$$reportNull$$$0(1);
        }
        return projectJdkTable;
    }

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1);

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1, @NotNull String var2);

    public abstract Sdk @NotNull [] getAllJdks();

    public abstract @Unmodifiable @NotNull List<Sdk> getSdksOfType(@NotNull SdkTypeId var1);

    @Nullable
    public Sdk findMostRecentSdkOfType(@NotNull SdkTypeId type) {
        if (type == null) {
            ProjectJdkTable.$$$reportNull$$$0(2);
        }
        return this.getSdksOfType(type).stream().max(type.versionComparator()).orElse(null);
    }

    @RequiresWriteLock
    public abstract void addJdk(@NotNull Sdk var1);

    @TestOnly
    public void addJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        Sdk existingJdk;
        if (jdk == null) {
            ProjectJdkTable.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            ProjectJdkTable.$$$reportNull$$$0(4);
        }
        if ((existingJdk = this.findJdk(jdk.getName(), jdk.getSdkType().getName())) == null || existingJdk.getSdkAdditionalData() != jdk.getSdkAdditionalData()) {
            this.addJdk(jdk);
        }
        Disposer.register((Disposable)parentDisposable, () -> WriteAction.runAndWait(() -> this.removeJdk(jdk)));
    }

    @RequiresWriteLock
    public abstract void removeJdk(@NotNull Sdk var1);

    @RequiresWriteLock
    public abstract void updateJdk(@NotNull Sdk var1, @NotNull Sdk var2);

    @NotNull
    public abstract SdkTypeId getDefaultSdkType();

    @NotNull
    public abstract SdkTypeId getSdkTypeByName(@NotNull String var1);

    @NotNull
    public abstract Sdk createSdk(@NotNull String var1, @NotNull SdkTypeId var2);

    public void preconfigure() {
    }

    @TestOnly
    public void saveOnDisk() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ProjectJdkTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ProjectJdkTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findMostRecentSdkOfType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addJdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        default public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (previousName == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/projectRoots/ProjectJdkTable$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkRemoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkNameChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

