/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.project;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.platform.project.ProjectId;
import com.intellij.util.CoroutinesKt;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/project/ProjectIdsStorage;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "idsToProject", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/project/ProjectId;", "Lcom/intellij/openapi/project/Project;", "registerProject", "project", "unregisterProject", "", "getProjectId", "findProject", "projectId", "setProjectId", "newProjectId", "Companion", "intellij.platform.project"})
public final class ProjectIdsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<ProjectId, Project> idsToProject;
    @ApiStatus.Internal
    @NotNull
    private static final Key<ProjectId> PROJECT_ID;

    public ProjectIdsStorage(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.idsToProject = new ConcurrentHashMap();
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ProjectIdsStorage this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.idsToProject.clear();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final ProjectId registerProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectId projectId = ProjectId.Companion.create$intellij_platform_project();
        project.putUserData(PROJECT_ID, (Object)projectId);
        ((Map)this.idsToProject).put(projectId, project);
        return projectId;
    }

    public final void unregisterProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectId currentId = (ProjectId)project.getUserData(PROJECT_ID);
        if (currentId != null) {
            this.idsToProject.remove(currentId);
        }
    }

    @Nullable
    public final ProjectId getProjectId(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ProjectId)project.getUserData(PROJECT_ID);
    }

    @Nullable
    public final Project findProject(@NotNull ProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.idsToProject.get(projectId);
    }

    public final void setProjectId(@NotNull Project project, @NotNull ProjectId newProjectId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newProjectId, (String)"newProjectId");
        ProjectId oldId = (ProjectId)project.getUserData(PROJECT_ID);
        TypeIntrinsics.asMutableMap((Object)this.idsToProject).remove(oldId);
        project.putUserData(PROJECT_ID, (Object)newProjectId);
        ((Map)this.idsToProject).put(newProjectId, project);
    }

    @JvmStatic
    @NotNull
    public static final ProjectIdsStorage getInstance() {
        return Companion.getInstance();
    }

    static {
        Key key = Key.create((String)"ProjectImpl.PROJECT_ID");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PROJECT_ID = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/project/ProjectIdsStorage$Companion;", "", "<init>", "()V", "PROJECT_ID", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/platform/project/ProjectId;", "getInstance", "Lcom/intellij/platform/project/ProjectIdsStorage;", "intellij.platform.project"})
    @SourceDebugExtension(value={"SMAP\nProjectIdsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectIdsStorage.kt\ncom/intellij/platform/project/ProjectIdsStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,72:1\n42#2,3:73\n*S KotlinDebug\n*F\n+ 1 ProjectIdsStorage.kt\ncom/intellij/platform/project/ProjectIdsStorage$Companion\n*L\n70#1:73,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectIdsStorage getInstance() {
            boolean $i$f$service = false;
            Class<ProjectIdsStorage> serviceClass$iv = ProjectIdsStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ProjectIdsStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

