/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.refactoring.RefactoringUiService;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElement2UsageTargetAdapter
implements PsiElementUsageTarget,
UiCompatibleDataProvider,
PsiElementNavigationItem,
ItemPresentation,
ConfigurableUsageTarget {
    private final SmartPsiElementPointer<?> myPointer;
    @NotNull
    protected final FindUsagesOptions myOptions;
    private String myPresentableText;
    private String myLocationText;
    private Icon myIcon;

    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element, @NotNull FindUsagesOptions options, boolean update) {
        if (element == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(0);
        }
        if (options == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(1);
        }
        if (!(element instanceof NavigationItem)) {
            throw new IllegalArgumentException("Element is not a navigation item: " + String.valueOf(element));
        }
        this.myOptions = options;
        PsiFile file = element.getContainingFile();
        SmartPsiElementPointer smartPsiElementPointer = this.myPointer = file == null ? SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element) : SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer(element, file);
        if (update) {
            this.update(element, file);
        }
    }

    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element, boolean update) {
        if (element == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(2);
        }
        this(element, new FindUsagesOptions(element.getProject()), update);
    }

    @Deprecated(forRemoval=true)
    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element) {
        if (element == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(3);
        }
        this(element, true);
    }

    public String getName() {
        PsiElement element = this.getElement();
        return element instanceof NavigationItem ? ((NavigationItem)element).getName() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PsiElement2UsageTargetAdapter psiElement2UsageTargetAdapter = this;
        if (psiElement2UsageTargetAdapter == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(4);
        }
        return psiElement2UsageTargetAdapter;
    }

    public void navigate(boolean requestFocus) {
        PsiElement element = this.getElement();
        if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        PsiElement element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        PsiElement element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigateToSource();
    }

    public PsiElement getTargetElement() {
        return this.getElement();
    }

    public String toString() {
        return this.getPresentableText();
    }

    public void findUsages() {
        PsiElement element = this.getElement();
        if (element != null) {
            RefactoringUiService.getInstance().startFindUsages(element, this.myOptions);
        }
    }

    public PsiElement getElement() {
        return this.myPointer.getElement();
    }

    public void findUsagesInEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(5);
        }
        PsiElement element = this.getElement();
        FindManager.getInstance(element.getProject()).findUsagesInEditor(element, editor);
    }

    public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
        if (file == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(7);
        }
        PsiElement target = this.getElement();
        RefactoringUiService.getInstance().highlightUsageReferences((PsiElement)file, target, editor, clearHighlights);
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    public boolean isReadOnly() {
        return this.isValid() && !this.getElement().isWritable();
    }

    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray;
        if (!this.isValid()) {
            return null;
        }
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFileArray = null;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile;
        }
        return virtualFileArray;
    }

    @Deprecated(forRemoval=true)
    public static PsiElement2UsageTargetAdapter @NotNull [] convert(PsiElement @NotNull [] psiElements) {
        if (psiElements == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(8);
        }
        return PsiElement2UsageTargetAdapter.convert(psiElements, true);
    }

    public static PsiElement2UsageTargetAdapter @NotNull [] convert(PsiElement @NotNull [] psiElements, boolean update) {
        if (psiElements == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(9);
        }
        PsiElement2UsageTargetAdapter[] targets = new PsiElement2UsageTargetAdapter[psiElements.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new PsiElement2UsageTargetAdapter(psiElements[i], update);
        }
        if (targets == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(10);
        }
        return targets;
    }

    public static PsiElement @NotNull [] convertToPsiElements(PsiElement2UsageTargetAdapter @NotNull [] adapters) {
        if (adapters == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(11);
        }
        PsiElement[] targets = new PsiElement[adapters.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = adapters[i].getElement();
        }
        if (targets == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(12);
        }
        return targets;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(13);
        }
        sink.set(UsageView.USAGE_SCOPE, (Object)this.myOptions.searchScope);
        sink.lazy(UsageView.USAGE_INFO_KEY, () -> {
            PsiElement element = this.getElement();
            return element != null && element.getTextRange() != null ? new UsageInfo(element) : null;
        });
    }

    public KeyboardShortcut getShortcut() {
        return UsageViewUtil.getShowUsagesWithSettingsShortcut();
    }

    @Nls
    @NotNull
    public String getLongDescriptiveName() {
        PsiElement psiElement = this.getElement();
        String string = psiElement == null ? UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) : FindBundle.message((String)"recent.find.usages.action.popup", (Object[])new Object[]{StringUtil.capitalize((String)UsageViewUtil.getType((PsiElement)psiElement)), DescriptiveNameUtil.getDescriptiveName((PsiElement)psiElement), this.myOptions.searchScope.getDisplayName()});
        if (string == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void showSettings() {
        PsiElement element = this.getElement();
        if (element != null) {
            RefactoringUiService.getInstance().findUsages(this.myPointer.getProject(), element, null, null, true, null);
        }
    }

    public void update() {
        PsiElement element = this.getElement();
        if (element != null) {
            this.update(element, element.getContainingFile());
        }
    }

    private void update(@NotNull PsiElement element, PsiFile file) {
        if (element == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(15);
        }
        if (file == null ? element.isValid() : file.isValid()) {
            ItemPresentation presentation = ((NavigationItem)element).getPresentation();
            this.myIcon = presentation == null ? null : presentation.getIcon(true);
            this.myPresentableText = presentation == null ? UsageViewUtil.createNodeText((PsiElement)element) : presentation.getPresentableText();
            String string = this.myLocationText = presentation == null ? null : StringUtil.nullize((String)presentation.getLocationString());
            if (this.myIcon == null) {
                PsiFile psiFile;
                VirtualFile virtualFile;
                if (element instanceof PsiMetaOwner) {
                    PsiMetaOwner psiMetaOwner = (PsiMetaOwner)element;
                    PsiMetaData metaData = psiMetaOwner.getMetaData();
                    if (metaData instanceof PsiPresentableMetaData) {
                        PsiPresentableMetaData psiPresentableMetaData = (PsiPresentableMetaData)metaData;
                        if (this.myIcon == null) {
                            this.myIcon = psiPresentableMetaData.getIcon();
                        }
                    }
                } else if (element instanceof PsiFile && (virtualFile = (psiFile = (PsiFile)element).getVirtualFile()) != null) {
                    this.myIcon = VirtualFilePresentation.getIcon((VirtualFile)virtualFile);
                }
            }
        }
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    @Nullable
    public String getLocationString() {
        return this.myLocationText;
    }

    public Icon getIcon(boolean open) {
        return this.myIcon;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPointer.getProject();
        if (project == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(16);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/PsiElement2UsageTargetAdapter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/PsiElement2UsageTargetAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPsiElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightUsages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

