/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.listeners.impl.RefactoringTransactionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RefactoringListenerManagerImpl
extends RefactoringListenerManager {
    private final List<RefactoringElementListenerProvider> myListenerProviders = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Project myProject;

    public RefactoringListenerManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void addListenerProvider(RefactoringElementListenerProvider provider) {
        this.myListenerProviders.add(provider);
    }

    public RefactoringTransaction startTransaction() {
        ArrayList<RefactoringElementListenerProvider> providers = new ArrayList<RefactoringElementListenerProvider>(this.myListenerProviders);
        providers.addAll(RefactoringElementListenerProvider.EP_NAME.getExtensionList((AreaInstance)this.myProject));
        return new RefactoringTransactionImpl(this.myProject, providers);
    }
}

