/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessorBase;
import com.intellij.refactoring.rename.RenameRefactoringDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.UiInterceptors;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance(PsiElementRenameHandler.class);
    private static final ExtensionPointName<Condition<? super PsiElement>> VETO_RENAME_CONDITION_EP = ExtensionPointName.create((String)"com.intellij.vetoRenameCondition");
    public static final DataKey<String> DEFAULT_NAME = DataKey.create((String)"DEFAULT_NAME");
    public static final DataKey<List<String>> NAME_SUGGESTIONS = DataKey.create((String)"renameNameSuggestions");

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @NotNull DataContext dataContext) {
        String newName;
        PsiElement element;
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(1);
        }
        if ((element = PsiElementRenameHandler.getElement(dataContext)) == null) {
            element = CommonRefactoringUtil.getElementAtCaret(editor, file);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (newName = (String)DEFAULT_NAME.getData(dataContext)) != null) {
            PsiElementRenameHandler.rename(element, project, element, editor, newName);
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset());
        boolean checkInProject = this.shouldCheckInProject();
        List<String> suggestedNames = Objects.requireNonNullElse((List)NAME_SUGGESTIONS.getData(dataContext), List.of());
        PsiElementRenameHandler.invoke(element, project, nameSuggestionContext, suggestedNames, editor, checkInProject);
    }

    @Override
    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)DEFAULT_NAME.getData(dataContext);
            LOG.assertTrue(newName != null);
            PsiElementRenameHandler.rename(element, project, element, editor, newName);
        } else {
            PsiElementRenameHandler.invoke(element, project, element, editor, this.shouldCheckInProject());
        }
    }

    protected boolean shouldCheckInProject() {
        return true;
    }

    public static void invoke(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(5);
        }
        PsiElementRenameHandler.invoke(element, project, nameSuggestionContext, editor, true);
    }

    public static void invoke(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, @Nullable Editor editor, boolean checkInProject) {
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(7);
        }
        PsiElementRenameHandler.invoke(element, project, nameSuggestionContext, List.of(), editor, checkInProject);
    }

    private static void invoke(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, @NotNull List<String> suggestedNames, @Nullable Editor editor, boolean checkInProject) {
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(9);
        }
        if (suggestedNames == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(10);
        }
        if (!PsiElementRenameHandler.canRename(project, editor, element)) {
            return;
        }
        VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)nameSuggestionContext);
        if (checkInProject && nameSuggestionContext != null && nameSuggestionContext.isPhysical() && (contextFile == null || !ScratchUtil.isScratch((VirtualFile)contextFile)) && !PsiManager.getInstance((Project)project).isInProject(nameSuggestionContext)) {
            String message = RefactoringBundle.message("dialog.message.selected.element.used.from.non.project.files");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException(message);
            }
            if (!MessageDialogBuilder.yesNo((String)RefactoringBundle.getCannotRefactorMessage(null), (String)message, (Icon)UIUtil.getWarningIcon()).ask(project)) {
                return;
            }
        }
        RenamePsiElementProcessorBase processor = RenamePsiElementProcessorBase.forPsiElement(element);
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, suggestedNames, editor, null, processor);
    }

    public static boolean canRename(@NotNull Project project, Editor editor, PsiElement element) {
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(11);
        }
        if (element == null) {
            return false;
        }
        String message = PsiElementRenameHandler.getErrorMessage(project, editor, element);
        if (message != null) {
            CommonRefactoringUtil.showErrorHint(project, editor, RefactoringBundle.getCannotRefactorMessage(message), RefactoringBundle.message("rename.title"), null);
            return false;
        }
        return true;
    }

    @NlsContexts.DialogMessage
    @Nullable
    private static String getErrorMessage(@NotNull Project project, Editor editor, PsiElement element) {
        PsiMetaOwner o;
        boolean hasWritableMetaData;
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(12);
        }
        boolean hasRenameProcessor = !(RenamePsiElementProcessorBase.forPsiElement(element) instanceof RenamePsiElementProcessorBase.DefaultRenamePsiElementProcessor);
        boolean bl = hasWritableMetaData = element instanceof PsiMetaOwner && (o = (PsiMetaOwner)element).getMetaData() instanceof PsiWritableMetaData;
        if (!(hasRenameProcessor || hasWritableMetaData || element instanceof PsiNamedElement)) {
            return editor == null ? RefactoringBundle.message("error.cannot.be.renamed") : RefactoringBundle.message("error.wrong.caret.position.symbol.to.rename");
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element)) {
            VirtualFile virtualFile;
            if (element.isPhysical() && ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null || !NonProjectFileWritingAccessProvider.isWriteAccessAllowed((VirtualFile)virtualFile, (Project)project))) {
                return RefactoringBundle.message("error.out.of.project.element", RenameUtil.getUsageViewType(element));
            }
            if (!element.isWritable()) {
                return RefactoringBundle.message("error.cannot.be.renamed");
            }
        }
        if (InjectedLanguageUtilBase.isInInjectedLanguagePrefixSuffix((PsiElement)element)) {
            return RefactoringBundle.message("error.in.injected.lang.prefix.suffix", RenameUtil.getUsageViewType(element));
        }
        return null;
    }

    public static void rename(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, Editor editor) {
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(14);
        }
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor, null);
    }

    public static void rename(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, Editor editor, String defaultName) {
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(15);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(16);
        }
        RenamePsiElementProcessorBase processor = RenamePsiElementProcessorBase.forPsiElement(element);
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor, defaultName, processor);
    }

    public static void rename(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, Editor editor, String defaultName, RenamePsiElementProcessorBase processor) {
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(17);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(18);
        }
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, List.of(), editor, defaultName, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rename(@NotNull PsiElement element, @NotNull Project project, PsiElement nameSuggestionContext, @NotNull Collection<String> suggestedNames, Editor editor, String defaultName, RenamePsiElementProcessorBase processor) {
        PsiElement substituted;
        if (element == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(19);
        }
        if (project == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(20);
        }
        if (suggestedNames == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(21);
        }
        if ((substituted = processor.substituteElementToRename(element, editor)) == null || !PsiElementRenameHandler.canRename(project, editor, substituted)) {
            return;
        }
        RenameRefactoringDialog dialog = processor.createDialog(project, substituted, nameSuggestionContext, editor);
        dialog.addSuggestedNames(suggestedNames);
        if (UiInterceptors.tryIntercept((Object)dialog)) {
            return;
        }
        if (defaultName == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] strings = dialog.getSuggestedNames();
            if (strings != null && strings.length > 0) {
                Arrays.sort(strings);
                defaultName = strings[0];
            } else {
                defaultName = "undefined";
            }
        }
        if (defaultName != null) {
            try {
                dialog.performRename((String)defaultName);
            }
            finally {
                dialog.close();
            }
        } else {
            dialog.show();
        }
    }

    @Override
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(22);
        }
        return !PsiElementRenameHandler.isVetoed(PsiElementRenameHandler.getElement(dataContext));
    }

    public static boolean isVetoed(PsiElement element) {
        PsiNamedElement namedElement;
        if (element == null || element instanceof SyntheticElement || element instanceof PsiNamedElement && (namedElement = (PsiNamedElement)element).getName() == null) {
            return true;
        }
        for (Condition condition : VETO_RENAME_CONDITION_EP.getExtensionList()) {
            if (!condition.value((Object)element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getElement(@NotNull DataContext dataContext) {
        PsiElement[] elementArray;
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(23);
        }
        return (elementArray = CommonRefactoringUtil.getPsiElementArray(dataContext)).length != 1 ? null : elementArray[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedNames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/PsiElementRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canRename";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

